/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hlysine.create_connected.CCJukeboxSongs;
import com.hlysine.create_connected.CCPonderPlugin;
import com.hlysine.create_connected.CCSoundEvents;
import com.hlysine.create_connected.CreateConnected;
import com.hlysine.create_connected.datagen.CCTagGen;
import com.hlysine.create_connected.datagen.advancements.CCAdvancements;
import com.hlysine.create_connected.datagen.recipes.CCStandardRecipes;
import com.hlysine.create_connected.datagen.recipes.ProcessingRecipeGen;
import com.hlysine.create_connected.datagen.recipes.SequencedAssemblyGen;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateDataProvider;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class CCDatagen {
    public static void gatherData(GatherDataEvent event) {
        if (!event.getMods().contains("create_connected")) {
            return;
        }
        CCDatagen.addExtraRegistrateData();
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(true, (DataProvider)CCSoundEvents.provider(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new CCAdvancements(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new CCStandardRecipes(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new SequencedAssemblyGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)CCJukeboxSongs.provider(output, lookupProvider, existingFileHelper));
        if (event.includeServer()) {
            ProcessingRecipeGen.registerAll(generator, output, lookupProvider);
        }
        event.getGenerator().addProvider(true, (DataProvider)CreateConnected.getRegistrate().setDataProvider(new RegistrateDataProvider((AbstractRegistrate)CreateConnected.getRegistrate(), "create_connected", event)));
    }

    private static void addExtraRegistrateData() {
        CCTagGen.addGenerators();
        CreateConnected.getRegistrate().addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            CCDatagen.provideDefaultLang("interface", langConsumer);
            CCDatagen.provideDefaultLang("tooltips", langConsumer);
            CCAdvancements.provideLang(langConsumer);
            CCSoundEvents.provideLang(langConsumer);
            CCDatagen.providePonderLang(langConsumer);
        });
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/create_connected/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }

    private static void providePonderLang(BiConsumer<String, String> consumer) {
        PonderIndex.addPlugin((PonderPlugin)new CCPonderPlugin());
        PonderIndex.getLangAccess().provideLang("create_connected", consumer);
    }
}

