/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.datagen.recipes;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.CCItems;
import com.hlysine.create_connected.CreateConnected;
import com.hlysine.create_connected.compat.CopycatsManager;
import com.hlysine.create_connected.datagen.recipes.FeatureEnabledCondition;
import com.hlysine.create_connected.datagen.recipes.FeatureEnabledInCopycatsCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.simibubi.create.foundation.mixin.accessor.MappedRegistryAccessor;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCStandardRecipes
extends CreateRecipeProvider {
    private final Marker KINETICS = this.enterFolder("kinetics");
    CreateRecipeProvider.GeneratedRecipe ENCASED_CHAIN_COGWHEEL = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.ENCASED_CHAIN_COGWHEEL).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.ENCASED_CHAIN_DRIVE).get())).requiresResultFeature().viaShapeless(b -> b.requires((ItemLike)AllBlocks.ENCASED_CHAIN_DRIVE).requires((ItemLike)AllBlocks.COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe CRANK_WHEEL = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.CRANK_WHEEL).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.COGWHEEL).get())).requiresResultFeature().viaShapeless(b -> b.requires((ItemLike)AllBlocks.HAND_CRANK).requires((ItemLike)AllBlocks.COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe LARGE_CRANK_WHEEL = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.LARGE_CRANK_WHEEL).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.LARGE_COGWHEEL).get())).requiresResultFeature().viaShapeless(b -> b.requires((ItemLike)AllBlocks.HAND_CRANK).requires((ItemLike)AllBlocks.LARGE_COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe INVERTED_CLUTCH_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of((Object)AllBlocks.CLUTCH, CCBlocks.INVERTED_CLUTCH));
    CreateRecipeProvider.GeneratedRecipe INVERTED_GEARSHIFT_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of((Object)AllBlocks.GEARSHIFT, CCBlocks.INVERTED_GEARSHIFT));
    CreateRecipeProvider.GeneratedRecipe PARALLEL_GEARBOX = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.PARALLEL_GEARBOX).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.LARGE_COGWHEEL).get())).requiresResultFeature().viaShapeless(b -> b.requires((ItemLike)AllBlocks.GEARBOX).requires((ItemLike)AllBlocks.LARGE_COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe PARALLEL_GEARBOX_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(CCBlocks.PARALLEL_GEARBOX, CCItems.VERTICAL_PARALLEL_GEARBOX));
    CreateRecipeProvider.GeneratedRecipe SIX_WAY_GEARBOX = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.SIX_WAY_GEARBOX).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.LARGE_COGWHEEL).get())).requiresResultFeature().viaShaped(b -> b.define(Character.valueOf('c'), (ItemLike)AllBlocks.COGWHEEL).define(Character.valueOf('l'), (ItemLike)AllBlocks.LARGE_COGWHEEL).define(Character.valueOf('s'), (ItemLike)AllBlocks.ANDESITE_CASING).pattern("lc ").pattern("csc").pattern(" cl"));
    CreateRecipeProvider.GeneratedRecipe SIX_WAY_GEARBOX_FROM_GEARBOX = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.SIX_WAY_GEARBOX).withSuffix("_from_gearbox").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.GEARBOX).get())).requiresResultFeature().viaShapeless(b -> b.requires((ItemLike)AllBlocks.GEARBOX).requires((ItemLike)AllBlocks.LARGE_COGWHEEL).requires((ItemLike)AllBlocks.LARGE_COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe SIX_WAY_GEARBOX_FROM_PARALLEL = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.SIX_WAY_GEARBOX).withSuffix("_from_parallel").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCBlocks.PARALLEL_GEARBOX.get())).requiresResultFeature().requiresFeature(CCBlocks.PARALLEL_GEARBOX).viaShapeless(b -> b.requires(CCBlocks.PARALLEL_GEARBOX).requires((ItemLike)AllBlocks.LARGE_COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe SIX_WAY_GEARBOX_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(CCBlocks.SIX_WAY_GEARBOX, CCItems.VERTICAL_SIX_WAY_GEARBOX));
    CreateRecipeProvider.GeneratedRecipe BRASS_GEARBOX = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.BRASS_GEARBOX).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.ROTATION_SPEED_CONTROLLER).get())).requiresResultFeature().viaShaped(b -> b.define(Character.valueOf('c'), (ItemLike)AllBlocks.COGWHEEL).define(Character.valueOf('s'), (ItemLike)AllBlocks.ROTATION_SPEED_CONTROLLER).pattern(" c ").pattern("csc").pattern(" c "));
    CreateRecipeProvider.GeneratedRecipe BRASS_GEARBOX_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(CCBlocks.BRASS_GEARBOX, CCItems.VERTICAL_BRASS_GEARBOX));
    CreateRecipeProvider.GeneratedRecipe CROSS_CONNECTOR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.CROSS_CONNECTOR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.GEARBOX).get())).requiresResultFeature().viaShaped(b -> b.define(Character.valueOf('g'), (ItemLike)AllBlocks.GEARBOX).define(Character.valueOf('s'), (ItemLike)AllBlocks.SHAFT).pattern(" s ").pattern("sgs").pattern(" s "));
    CreateRecipeProvider.GeneratedRecipe OVERSTRESS_CLUTCH = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.OVERSTRESS_CLUTCH).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.ELECTRON_TUBE).get())).requiresResultFeature().viaShapeless(b -> b.requires((ItemLike)AllBlocks.ANDESITE_CASING).requires((ItemLike)AllBlocks.SHAFT).requires((ItemLike)AllItems.IRON_SHEET).requires((ItemLike)AllItems.ELECTRON_TUBE));
    CreateRecipeProvider.GeneratedRecipe CENTRIFUGAL_CLUTCH = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.CENTRIFUGAL_CLUTCH).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.SPEEDOMETER).get())).requiresResultFeature().viaShapeless(b -> b.requires((ItemLike)AllBlocks.ANDESITE_CASING).requires((ItemLike)AllBlocks.SHAFT).requires((ItemLike)AllItems.IRON_SHEET).requires((ItemLike)AllBlocks.SPEEDOMETER));
    CreateRecipeProvider.GeneratedRecipe FREEWHEEL_CLUTCH = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.FREEWHEEL_CLUTCH).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.COGWHEEL).get())).requiresResultFeature().viaShapeless(b -> b.requires((ItemLike)AllBlocks.ANDESITE_CASING).requires((ItemLike)AllBlocks.SHAFT).requires((ItemLike)AllItems.IRON_SHEET).requires((ItemLike)AllBlocks.COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe BRAKE = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.BRAKE).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((Block)Blocks.OBSIDIAN).asItem())).requiresResultFeature().viaShapeless(b -> b.requires((ItemLike)AllBlocks.ANDESITE_CASING).requires((ItemLike)AllBlocks.SHAFT).requires((ItemLike)Blocks.REDSTONE_WIRE).requires((ItemLike)Blocks.OBSIDIAN));
    CreateRecipeProvider.GeneratedRecipe KINETIC_BRIDGE = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.KINETIC_BRIDGE).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.CLUTCH).get())).requiresResultFeature().viaShaped(b -> b.define(Character.valueOf('c'), (ItemLike)AllBlocks.CLUTCH).define(Character.valueOf('s'), (ItemLike)AllBlocks.SHAFT).define(Character.valueOf('b'), (ItemLike)AllBlocks.BRASS_CASING).pattern(" b ").pattern("scs").pattern(" b "));
    CreateRecipeProvider.GeneratedRecipe KINETIC_BATTERY = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.KINETIC_BATTERY).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.ELECTRON_TUBE).get())).requiresResultFeature().returns(8).viaShaped(b -> b.define(Character.valueOf('p'), (ItemLike)AllItems.PRECISION_MECHANISM).define(Character.valueOf('b'), (ItemLike)AllBlocks.BRASS_CASING).define(Character.valueOf('r'), (ItemLike)Blocks.REDSTONE_WIRE).define(Character.valueOf('i'), (ItemLike)AllItems.IRON_SHEET).pattern(" p ").pattern(" b ").pattern("iri"));
    CreateRecipeProvider.GeneratedRecipe SEQUENCED_PULSE_GENERATOR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.SEQUENCED_PULSE_GENERATOR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCItems.CONTROL_CHIP.get())).requiresResultFeature().viaShaped(b -> b.define(Character.valueOf('E'), (ItemLike)AllItems.ELECTRON_TUBE).define(Character.valueOf('B'), (ItemLike)AllItems.BRASS_SHEET).define(Character.valueOf('C'), CCItems.CONTROL_CHIP).define(Character.valueOf('T'), (ItemLike)Blocks.REDSTONE_TORCH).define(Character.valueOf('S'), Tags.Items.STONES).pattern("EC ").pattern("EBT").pattern("SSS"));
    CreateRecipeProvider.GeneratedRecipe LINKED_TRANSMITTER_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(CCItems.LINKED_TRANSMITTER, (Object)AllBlocks.REDSTONE_LINK));
    CreateRecipeProvider.GeneratedRecipe REDSTONE_LINK_WILDCARD = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCItems.REDSTONE_LINK_WILDCARD).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.TRANSMITTER).get())).requiresResultFeature().viaShapeless(b -> b.requires((ItemLike)AllItems.TRANSMITTER).requires((ItemLike)AllItems.CRAFTER_SLOT_COVER));
    CreateRecipeProvider.GeneratedRecipe ITEM_SILO = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.ITEM_SILO).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)() -> Tags.Items.BARRELS_WOODEN)).requiresResultFeature().viaShaped(b -> b.define(Character.valueOf('B'), (ItemLike)AllItems.IRON_SHEET).define(Character.valueOf('C'), Tags.Items.BARRELS_WOODEN).pattern("BCB"));
    CreateRecipeProvider.GeneratedRecipe ITEM_SILO_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(CCBlocks.ITEM_SILO, (Object)AllBlocks.ITEM_VAULT));
    CreateRecipeProvider.GeneratedRecipe FLUID_VESSEL = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.FLUID_VESSEL).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)() -> Tags.Items.BARRELS_WOODEN)).requiresResultFeature().viaShaped(b -> b.define(Character.valueOf('B'), (ItemLike)AllItems.COPPER_SHEET).define(Character.valueOf('C'), Tags.Items.BARRELS_WOODEN).pattern("BCB"));
    CreateRecipeProvider.GeneratedRecipe FLUID_VESSEL_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(CCBlocks.FLUID_VESSEL, (Object)AllBlocks.FLUID_TANK));
    CreateRecipeProvider.GeneratedRecipe INVENTORY_ACCESS_PORT = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.INVENTORY_ACCESS_PORT).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.ELECTRON_TUBE).get())).requiresResultFeature().returns(2).viaShaped(b -> b.define(Character.valueOf('B'), (ItemLike)AllBlocks.BRASS_CASING).define(Character.valueOf('C'), (ItemLike)AllBlocks.CHUTE).define(Character.valueOf('E'), (ItemLike)AllItems.ELECTRON_TUBE).pattern("B").pattern("C").pattern("E"));
    CreateRecipeProvider.GeneratedRecipe INVENTORY_BRIDGE = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.INVENTORY_BRIDGE).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.ELECTRON_TUBE).get())).requiresResultFeature().viaShapeless(b -> b.requires(CCBlocks.INVENTORY_ACCESS_PORT).requires(CCBlocks.INVENTORY_ACCESS_PORT));
    CreateRecipeProvider.GeneratedRecipe EMPTY_FAN_CATALYST = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.EMPTY_FAN_CATALYST).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.BRASS_BLOCK).get())).requiresResultFeature().viaShaped(b -> b.define(Character.valueOf('b'), (ItemLike)AllItems.BRASS_INGOT).define(Character.valueOf('i'), (ItemLike)Blocks.IRON_BARS).pattern("bib").pattern("i i").pattern("bib"));
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_BLASTING = this.clearFanCatalyst("blasting", (ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.FAN_BLASTING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_SMOKING = this.clearFanCatalyst("smoking", (ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.FAN_SMOKING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_SPLASHING = this.clearFanCatalyst("splashing", (ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.FAN_SPLASHING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_HAUNTING = this.clearFanCatalyst("haunting", (ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.FAN_HAUNTING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_FREEZING = this.clearFanCatalyst("freezing", (ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.FAN_FREEZING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_SEETHING = this.clearFanCatalyst("seething", (ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.FAN_SEETHING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_SANDING = this.clearFanCatalyst("sanding", (ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.FAN_SANDING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_ENRICHED = this.clearFanCatalyst("enriched", (ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.FAN_ENRICHED_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_ENDING_DRAGONS_BREATH = this.clearFanCatalyst("ending_dragons_breath", (ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.FAN_ENDING_CATALYST_DRAGONS_BREATH);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_ENDING_DRAGON_HEAD = this.clearFanCatalyst("ending_dragon_head", (ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.FAN_ENDING_CATALYST_DRAGON_HEAD);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_WITHERING = this.clearFanCatalyst("withering", (ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.FAN_WITHERING_CATALYST);
    private final Marker PALETTES = this.enterFolder("palettes");
    CreateRecipeProvider.GeneratedRecipe COPYCAT_SLAB = this.copycat((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.COPYCAT_SLAB, 2);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_SLAB_FROM_PANELS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.COPYCAT_SLAB).withSuffix("_from_panels").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.COPYCAT_PANEL).get())).requiresResultFeature().disabledInCopycats().viaShaped(b -> b.define(Character.valueOf('p'), (ItemLike)AllBlocks.COPYCAT_PANEL).pattern("p").pattern("p"));
    CreateRecipeProvider.GeneratedRecipe COPYCAT_SLAB_FROM_STEPS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.COPYCAT_SLAB).withSuffix("_from_steps").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.COPYCAT_STEP).get())).requiresResultFeature().disabledInCopycats().viaShaped(b -> b.define(Character.valueOf('s'), (ItemLike)AllBlocks.COPYCAT_STEP).pattern("ss"));
    CreateRecipeProvider.GeneratedRecipe COPYCAT_SLAB_FROM_BEAMS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.COPYCAT_SLAB).withSuffix("_from_beams").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCBlocks.COPYCAT_BEAM.get())).requiresResultFeature().disabledInCopycats().requiresFeature(CCBlocks.COPYCAT_BEAM).viaShaped(b -> b.define(Character.valueOf('s'), CCBlocks.COPYCAT_BEAM).pattern("ss"));
    CreateRecipeProvider.GeneratedRecipe COPYCAT_BLOCK = this.copycat((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.COPYCAT_BLOCK, 1);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_BLOCK_FROM_SLABS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.COPYCAT_BLOCK).withSuffix("_from_slabs").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCBlocks.COPYCAT_SLAB.get())).requiresResultFeature().disabledInCopycats().requiresFeature(CCBlocks.COPYCAT_SLAB).viaShaped(b -> b.define(Character.valueOf('s'), CCBlocks.COPYCAT_SLAB).pattern("s").pattern("s"));
    CreateRecipeProvider.GeneratedRecipe COPYCAT_BEAM = this.copycat((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.COPYCAT_BEAM, 4);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_STEP_CYCLE = this.copycatCycle((List<ItemProviderEntry<? extends ItemLike, ?>>)ImmutableList.of((Object)AllBlocks.COPYCAT_STEP, CCBlocks.COPYCAT_VERTICAL_STEP));
    CreateRecipeProvider.GeneratedRecipe COPYCAT_VERTICAL_STEP = this.copycat((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.COPYCAT_VERTICAL_STEP, 4);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_STAIRS = this.copycat((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.COPYCAT_STAIRS, 1);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_FENCE = this.copycat((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.COPYCAT_FENCE, 1);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_FENCE_GATE = this.copycat((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.COPYCAT_FENCE_GATE, 1);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_WALL = this.copycat((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.COPYCAT_WALL, 1);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_BOARD = this.copycat((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.COPYCAT_BOARD, 8);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_BOX = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCItems.COPYCAT_BOX).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCBlocks.COPYCAT_BOARD.get())).requiresResultFeature().disabledInCopycats().viaShaped(b -> b.define(Character.valueOf('s'), CCBlocks.COPYCAT_BOARD).pattern("ss ").pattern("s s").pattern(" ss"));
    CreateRecipeProvider.GeneratedRecipe COPYCAT_CATWALK = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCItems.COPYCAT_CATWALK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCBlocks.COPYCAT_BOARD.get())).requiresResultFeature().disabledInCopycats().viaShaped(b -> b.define(Character.valueOf('s'), CCBlocks.COPYCAT_BOARD).pattern("s s").pattern(" s "));
    String currentFolder = "";

    Marker enterFolder(String folder) {
        this.currentFolder = folder;
        return new Marker();
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike, ? extends ItemLike> result) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get()));
    }

    CreateRecipeProvider.GeneratedRecipe createSpecial(Function<CraftingBookCategory, Recipe<?>> builder, String recipeType, String path) {
        ResourceLocation location = CreateConnected.asResource(recipeType + "/" + this.currentFolder + "/" + path);
        return this.register(consumer -> {
            SpecialRecipeBuilder b = SpecialRecipeBuilder.special((Function)builder);
            b.save(consumer, location.toString());
        });
    }

    CreateRecipeProvider.GeneratedRecipe copycatCycle(List<ItemProviderEntry<? extends ItemLike, ?>> cycle) {
        CreateRecipeProvider.GeneratedRecipe result = null;
        for (int i = 0; i < cycle.size(); ++i) {
            ItemProviderEntry<? extends ItemLike, ?> currentEntry = cycle.get(i);
            ItemProviderEntry<? extends ItemLike, ?> nextEntry = cycle.get((i + 1) % cycle.size());
            result = this.create(nextEntry).withSuffix("_from_conversion").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> currentEntry.get())).requiresFeature(currentEntry.getId()).disabledInCopycats().requiresFeature(nextEntry.getId()).viaShapeless(b -> b.requires((ItemLike)currentEntry.get()));
        }
        return result;
    }

    CreateRecipeProvider.GeneratedRecipe conversionCycle(List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>> cycle) {
        CreateRecipeProvider.GeneratedRecipe result = null;
        for (int i = 0; i < cycle.size(); ++i) {
            ItemProviderEntry<? extends ItemLike, ? extends ItemLike> currentEntry = cycle.get(i);
            ItemProviderEntry<? extends ItemLike, ? extends ItemLike> nextEntry = cycle.get((i + 1) % cycle.size());
            result = this.create(nextEntry).withSuffix("_from_conversion").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> currentEntry.get())).requiresFeature(currentEntry.getId()).requiresFeature(nextEntry.getId()).viaShapeless(b -> b.requires((ItemLike)currentEntry.get()));
        }
        return result;
    }

    CreateRecipeProvider.GeneratedRecipe clearFanCatalyst(String key, ItemProviderEntry<? extends ItemLike, ? extends ItemLike> from) {
        return this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CCBlocks.EMPTY_FAN_CATALYST).withSuffix("_from_" + key).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCBlocks.EMPTY_FAN_CATALYST.get())).requiresResultFeature().viaShapeless(b -> b.requires((ItemLike)from));
    }

    CreateRecipeProvider.GeneratedRecipe copycat(ItemProviderEntry<? extends ItemLike, ? extends ItemLike> result, int resultCount) {
        if (CopycatsManager.convert(result) != result) {
            this.create((Supplier<ItemLike>)((Supplier)() -> CopycatsManager.convert((ItemLike)result))).withSuffix("_compat").requiresFeature(RegisteredObjectsHelper.getKeyOrThrow((Item)result.asItem())).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> result.get())).enabledInCopycats().viaShapeless(b -> b.requires((ItemLike)result));
        }
        return this.create(result).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.ZINC_INGOT).get())).requiresResultFeature().disabledInCopycats().viaStonecutting(Ingredient.of((TagKey)AllTags.commonItemTag((String)"ingots/zinc")), resultCount);
    }

    @NotNull
    public String getName() {
        return "Create: Connected's Standard Recipes";
    }

    public CCStandardRecipes(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected static class Marker {
        protected Marker() {
        }
    }

    class GeneratedRecipeBuilder {
        private String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private RecipeCategory category = null;
        private ResourceLocation compatDatagenOutput;
        List<ICondition> recipeConditions;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.recipeConditions = new ArrayList<ICondition>();
            this.suffix = "";
            this.amount = 1;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)item.get()}).build();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of((TagKey)tag.get()).build();
            return this;
        }

        GeneratedRecipeBuilder inCategory(RecipeCategory category) {
            this.category = category;
            return this;
        }

        GeneratedRecipeBuilder whenModLoaded(String modid) {
            return this.withCondition((ICondition)new ModLoadedCondition(modid));
        }

        GeneratedRecipeBuilder whenModMissing(String modid) {
            return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
        }

        GeneratedRecipeBuilder withCondition(ICondition condition) {
            this.recipeConditions.add(condition);
            return this;
        }

        GeneratedRecipeBuilder requiresFeature(ResourceLocation location) {
            this.recipeConditions.add(new FeatureEnabledCondition(location));
            return this;
        }

        GeneratedRecipeBuilder requiresFeature(BlockEntry<?> block) {
            return this.requiresFeature(block.getId());
        }

        GeneratedRecipeBuilder requiresResultFeature() {
            return this.requiresFeature(RegisteredObjectsHelper.getKeyOrThrow((Item)((ItemLike)this.result.get()).asItem()));
        }

        GeneratedRecipeBuilder disabledInCopycats() {
            return this.withCondition((ICondition)new NotCondition((ICondition)new FeatureEnabledInCopycatsCondition(RegisteredObjectsHelper.getKeyOrThrow((Item)((ItemLike)this.result.get()).asItem()))));
        }

        GeneratedRecipeBuilder enabledInCopycats() {
            return this.withCondition(new FeatureEnabledInCopycatsCondition(RegisteredObjectsHelper.getKeyOrThrow((Item)((ItemLike)this.result.get()).asItem())));
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        CreateRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return CCStandardRecipes.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.shaped((RecipeCategory)(this.category == null ? RecipeCategory.MISC : this.category), (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", CCStandardRecipes.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                if (!this.recipeConditions.isEmpty()) {
                    consumer = consumer.withConditions(this.recipeConditions.toArray(new ICondition[0]));
                }
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        CreateRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return CCStandardRecipes.this.register(consumer -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.shapeless((RecipeCategory)(this.category == null ? RecipeCategory.MISC : this.category), (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", CCStandardRecipes.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                if (!this.recipeConditions.isEmpty()) {
                    consumer = consumer.withConditions(this.recipeConditions.toArray(new ICondition[0]));
                }
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        CreateRecipeProvider.GeneratedRecipe viaStonecutting(Ingredient ingredient, int resultCount) {
            return CCStandardRecipes.this.register(consumer -> {
                SingleItemRecipeBuilder b = SingleItemRecipeBuilder.stonecutting((Ingredient)ingredient, (RecipeCategory)(this.category == null ? RecipeCategory.BUILDING_BLOCKS : this.category), (ItemLike)((ItemLike)this.result.get()), (int)resultCount);
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", CCStandardRecipes.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                if (!this.recipeConditions.isEmpty()) {
                    consumer = consumer.withConditions(this.recipeConditions.toArray(new ICondition[0]));
                }
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        CreateRecipeProvider.GeneratedRecipe viaStonecutting(Ingredient ingredient) {
            return this.viaStonecutting(ingredient, 1);
        }

        CreateRecipeProvider.GeneratedRecipe viaNetheriteSmithing(Supplier<? extends Item> base, Ingredient upgradeMaterial) {
            return CCStandardRecipes.this.register(consumer -> {
                SmithingTransformRecipeBuilder b = SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)base.get()}), (Ingredient)upgradeMaterial, (RecipeCategory)(this.category == null ? RecipeCategory.COMBAT : this.category), (Item)((ItemLike)this.result.get()).asItem());
                b.unlocks("has_item", CCStandardRecipes.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)base.get()}).build()}));
                if (!this.recipeConditions.isEmpty()) {
                    consumer = consumer.withConditions(this.recipeConditions.toArray(new ICondition[0]));
                }
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return CreateConnected.asResource(recipeType + "/" + this.getRegistryName().getPath() + this.suffix);
        }

        private ResourceLocation createLocation(String recipeType) {
            return CreateConnected.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().getPath() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? RegisteredObjectsHelper.getKeyOrThrow((Item)((ItemLike)this.result.get()).asItem()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)item.get()})));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.of((TagKey)((TagKey)tag.get()))));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private final Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            CreateRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
            }

            CreateRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                this.create(RecipeSerializer.CAMPFIRE_COOKING_RECIPE, builder, CampfireCookingRecipe::new, 3.0f);
                return this.create(RecipeSerializer.SMOKING_RECIPE, builder, SmokingRecipe::new, 0.5f);
            }

            CreateRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                return this.create(RecipeSerializer.BLASTING_RECIPE, builder, BlastingRecipe::new, 0.5f);
            }

            private <T extends AbstractCookingRecipe> CreateRecipeProvider.GeneratedRecipe create(RecipeSerializer<T> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, AbstractCookingRecipe.Factory<T> factory, float cookingTimeModifier) {
                return CCStandardRecipes.this.register(recipeOutput -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.generic((Ingredient)((Ingredient)this.ingredient.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.DIRT : (ItemLike)GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer, (AbstractCookingRecipe.Factory)factory));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.unlockedBy("has_item", CCStandardRecipes.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    if (!GeneratedRecipeBuilder.this.recipeConditions.isEmpty()) {
                        recipeOutput = recipeOutput.withConditions(GeneratedRecipeBuilder.this.recipeConditions.toArray(new ICondition[0]));
                    }
                    b.save((RecipeOutput)(isOtherMod ? new ModdedCookingRecipeOutput(recipeOutput, GeneratedRecipeBuilder.this.compatDatagenOutput) : recipeOutput), GeneratedRecipeBuilder.this.createSimpleLocation(RegisteredObjectsHelper.getKeyOrThrow((RecipeSerializer)serializer).getPath()));
                });
            }
        }
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private record ModdedCookingRecipeOutput(RecipeOutput wrapped, ResourceLocation outputOverride) implements RecipeOutput
    {
        public Advancement.Builder advancement() {
            return this.wrapped.advancement();
        }

        public void accept(ResourceLocation id, Recipe<?> recipe, @Nullable AdvancementHolder advancement, ICondition ... conditions) {
            this.wrapped.accept(id, (Recipe)new ModdedCookingRecipeOutputShim(recipe, this.outputOverride), advancement, conditions);
        }
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class ModdedCookingRecipeOutputShim
    implements Recipe<RecipeInput> {
        private static final Map<RecipeType<?>, Serializer> serializers = new ConcurrentHashMap();
        private final Recipe<?> wrapped;
        private final ResourceLocation overrideID;

        private ModdedCookingRecipeOutputShim(Recipe<?> wrapped, ResourceLocation overrideID) {
            this.wrapped = wrapped;
            this.overrideID = overrideID;
        }

        public boolean matches(RecipeInput recipeInput, Level level) {
            throw new AssertionError((Object)"Only for datagen output");
        }

        public ItemStack assemble(RecipeInput input, HolderLookup.Provider registries) {
            throw new AssertionError((Object)"Only for datagen output");
        }

        public boolean canCraftInDimensions(int pWidth, int pHeight) {
            throw new AssertionError((Object)"Only for datagen output");
        }

        public ItemStack getResultItem(HolderLookup.Provider registries) {
            throw new AssertionError((Object)"Only for datagen output");
        }

        public RecipeSerializer<?> getSerializer() {
            return serializers.computeIfAbsent(this.getType(), t -> Serializer.create(this.wrapped));
        }

        public RecipeType<?> getType() {
            return this.wrapped.getType();
        }

        private record Serializer(MapCodec<Recipe<?>> wrappedCodec) implements RecipeSerializer<ModdedCookingRecipeOutputShim>
        {
            private static Serializer create(Recipe<?> wrapped) {
                MappedRegistryAccessor mra;
                RecipeSerializer wrappedSerializer = wrapped.getSerializer();
                Serializer serializer = new Serializer(wrappedSerializer.codec());
                Registry registry = BuiltInRegistries.RECIPE_SERIALIZER;
                if (!(registry instanceof MappedRegistryAccessor)) {
                    throw new AssertionError((Object)("ModdedCookingRecipeOutputShim will not be able to serialize without injecting into a registry. Expected BuiltInRegistries.RECIPE_SERIALIZER to be of class MappedRegistry, is of class " + String.valueOf(BuiltInRegistries.RECIPE_SERIALIZER.getClass())));
                }
                MappedRegistryAccessor mra$ = mra = (MappedRegistryAccessor)registry;
                int wrappedId = mra$.getToId().getOrDefault((Object)wrappedSerializer, -1);
                ResourceKey wrappedKey = ((Holder.Reference)mra$.getByValue().get(wrappedSerializer)).key();
                mra$.getToId().put((Object)serializer, wrappedId);
                mra$.getByValue().put(serializer, Holder.Reference.createStandAlone(null, (ResourceKey)wrappedKey));
                return serializer;
            }

            public MapCodec<ModdedCookingRecipeOutputShim> codec() {
                return RecordCodecBuilder.mapCodec(instance -> instance.group((App)this.wrappedCodec.forGetter(i -> i.wrapped), (App)FakeItemStack.CODEC.fieldOf("result").forGetter(i -> new FakeItemStack(i.overrideID))).apply((Applicative)instance, (wrappedRecipe, fakeItemStack) -> {
                    throw new AssertionError((Object)"Only for datagen output");
                }));
            }

            public StreamCodec<RegistryFriendlyByteBuf, ModdedCookingRecipeOutputShim> streamCodec() {
                throw new AssertionError((Object)"Only for datagen output");
            }
        }

        private record FakeItemStack(ResourceLocation id) {
            public static Codec<FakeItemStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(FakeItemStack::id)).apply((Applicative)instance, FakeItemStack::new));
        }
    }
}

