/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.copycat.beam;

import com.hlysine.create_connected.content.copycat.beam.CopycatBeamBlock;
import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;

public class CopycatBeamModel
extends CopycatModel {
    protected static final AABB CUBE_AABB = new AABB(BlockPos.ZERO);

    public CopycatBeamModel(BakedModel originalModel) {
        super(originalModel);
    }

    protected List<BakedQuad> getCroppedQuads(BlockState state, Direction side, RandomSource rand, BlockState material, ModelData wrappedData, RenderType renderType) {
        Direction.Axis axis = state.getOptionalValue(CopycatBeamBlock.AXIS).orElse(Direction.Axis.Y);
        BakedModel model = CopycatBeamModel.getModelOf((BlockState)material);
        List templateQuads = model.getQuads(material, side, rand, wrappedData, renderType);
        int size = templateQuads.size();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).getNormal());
        Vec3 rowNormal = axis.isVertical() ? new Vec3(1.0, 0.0, 0.0) : new Vec3(0.0, 1.0, 0.0);
        Vec3 columnNormal = axis.isVertical() || axis == Direction.Axis.X ? new Vec3(0.0, 0.0, 1.0) : new Vec3(1.0, 0.0, 0.0);
        AABB bb = CUBE_AABB.contract((1.0 - normal.x) * 12.0 / 16.0, (1.0 - normal.y) * 12.0 / 16.0, (1.0 - normal.z) * 12.0 / 16.0);
        for (boolean row : Iterate.trueAndFalse) {
            for (boolean column : Iterate.trueAndFalse) {
                AABB bb1 = bb;
                if (row) {
                    bb1 = bb1.move(rowNormal.scale(0.75));
                }
                if (column) {
                    bb1 = bb1.move(columnNormal.scale(0.75));
                }
                Vec3 offset = Vec3.ZERO;
                Vec3 rowShift = rowNormal.scale(row ? -0.25 : 0.25);
                Vec3 columnShift = columnNormal.scale(column ? -0.25 : 0.25);
                offset = offset.add(rowShift);
                offset = offset.add(columnShift);
                rowShift = rowShift.normalize();
                columnShift = columnShift.normalize();
                Vec3i rowShiftNormal = new Vec3i((int)rowShift.x, (int)rowShift.y, (int)rowShift.z);
                Vec3i columnShiftNormal = new Vec3i((int)columnShift.x, (int)columnShift.y, (int)columnShift.z);
                for (int i = 0; i < size; ++i) {
                    BakedQuad quad = (BakedQuad)templateQuads.get(i);
                    Direction direction = quad.getDirection();
                    if (rowShiftNormal.equals((Object)direction.getNormal()) || columnShiftNormal.equals((Object)direction.getNormal())) continue;
                    quads.add(BakedQuadHelper.cloneWithCustomGeometry((BakedQuad)quad, (int[])BakedModelHelper.cropAndMove((int[])quad.getVertices(), (TextureAtlasSprite)quad.getSprite(), (AABB)bb1, (Vec3)offset)));
                }
            }
        }
        return quads;
    }
}

