/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.fluidvessel;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.content.fluidvessel.BoilerData;
import com.hlysine.create_connected.content.fluidvessel.FluidVesselBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

@EventBusSubscriber(modid="create_connected", bus=EventBusSubscriber.Bus.MOD)
public class FluidVesselBlockEntity
extends FluidTankBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid {
    private static final int MAX_SIZE = 3;
    private static final int SYNC_RATE = 8;
    protected FluidVesselBlock.WindowType windowType = FluidVesselBlock.WindowType.SIDE_WIDE;
    private LerpedFloat fluidLevel;

    public FluidVesselBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.boiler = new BoilerData();
        this.refreshCapability();
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CCBlockEntityTypes.FLUID_VESSEL.get(), (be, context) -> {
            if (be.fluidCapability == null) {
                be.refreshCapability();
            }
            return be.fluidCapability;
        });
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CCBlockEntityTypes.CREATIVE_FLUID_VESSEL.get(), (be, context) -> {
            if (be.fluidCapability == null) {
                be.refreshCapability();
            }
            return be.fluidCapability;
        });
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(FluidVesselBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level.isClientSide) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void tick() {
        super.tick();
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public Direction.Axis getAxis() {
        return (Direction.Axis)this.getBlockState().getValue(FluidVesselBlock.AXIS);
    }

    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.worldPosition;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.hasLevel()) {
            return;
        }
        FluidType attributes = newFluidStack.getFluid().getFluidType();
        int luminosity = (int)((float)attributes.getLightLevel(newFluidStack) / 1.2f);
        boolean reversed = attributes.isLighterThanAir();
        int maxY = (int)(this.getFillState() * (float)this.width + 1.0f);
        Direction.Axis axis = this.getAxis();
        for (int yOffset = 0; yOffset < this.width; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.width - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int lengthOffset = 0; lengthOffset < this.height; ++lengthOffset) {
                for (int widthOffset = 0; widthOffset < this.width; ++widthOffset) {
                    BlockPos pos = this.worldPosition.offset(axis == Direction.Axis.X ? lengthOffset : widthOffset, yOffset, axis == Direction.Axis.Z ? lengthOffset : widthOffset);
                    FluidVesselBlockEntity vesselAt = (FluidVesselBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.getType(), (BlockGetter)this.level, (BlockPos)pos);
                    if (vesselAt == null) continue;
                    this.level.updateNeighbourForOutputSignal(pos, vesselAt.getBlockState().getBlock());
                    if (vesselAt.luminosity == actualLuminosity) continue;
                    vesselAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
            }
            this.fluidLevel.chase((double)this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    public FluidVesselBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof FluidVesselBlockEntity) {
            return (FluidVesselBlockEntity)blockEntity;
        }
        return null;
    }

    public void removeController(boolean keepFluids) {
        if (this.level.isClientSide) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.boiler.clear();
        this.onFluidStackChanged(this.tankInventory.getFluid());
        BlockState state = this.getBlockState();
        if (FluidVesselBlock.isVessel(state)) {
            state = (BlockState)state.setValue((Property)FluidVesselBlock.POSITIVE, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.setValue((Property)FluidVesselBlock.NEGATIVE, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.setValue(FluidVesselBlock.SHAPE, (Comparable)((Object)(this.window ? FluidVesselBlock.Shape.WINDOW : FluidVesselBlock.Shape.PLAIN)));
            this.getLevel().setBlock(this.worldPosition, state, 22);
        }
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    public boolean isWindowTypeAllowed(FluidVesselBlock.WindowType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case FluidVesselBlock.WindowType.SIDE_WIDE -> true;
            case FluidVesselBlock.WindowType.SIDE_NARROW_ENDS -> {
                if (this.height >= 2) {
                    yield true;
                }
                yield false;
            }
            case FluidVesselBlock.WindowType.SIDE_NARROW_THIRDS -> {
                if (this.height >= 3) {
                    yield true;
                }
                yield false;
            }
            case FluidVesselBlock.WindowType.SIDE_HORIZONTAL -> this.width > 2 && this.width % 2 == 1;
        };
    }

    public void toggleWindows() {
        FluidVesselBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        if (be.boiler.isActive()) {
            return;
        }
        if (!be.window) {
            be.setWindowType(FluidVesselBlock.WindowType.SIDE_WIDE);
            be.setWindows(true);
        } else {
            FluidVesselBlock.WindowType[] types = FluidVesselBlock.WindowType.values();
            if (be.windowType.ordinal() >= types.length - 1) {
                be.setWindows(false);
                return;
            }
            FluidVesselBlock.WindowType nextType = types[be.windowType.ordinal() + 1];
            while (!be.isWindowTypeAllowed(nextType)) {
                if (nextType.ordinal() >= types.length - 1) {
                    be.setWindows(false);
                    return;
                }
                nextType = types[nextType.ordinal() + 1];
            }
            be.setWindowType(nextType);
            be.setWindows(true);
        }
    }

    public FluidVesselBlock.WindowType getWindowType() {
        return this.windowType;
    }

    public void setWindowType(FluidVesselBlock.WindowType windowType) {
        this.windowType = windowType;
    }

    public void setWindows(boolean window) {
        this.window = window;
        Direction.Axis axis = this.getAxis();
        for (int yOffset = 0; yOffset < this.width; ++yOffset) {
            for (int lengthOffset = 0; lengthOffset < this.height; ++lengthOffset) {
                for (int widthOffset = 0; widthOffset < this.width; ++widthOffset) {
                    BlockPos pos = this.worldPosition.offset(axis == Direction.Axis.X ? lengthOffset : widthOffset, yOffset, axis == Direction.Axis.Z ? lengthOffset : widthOffset);
                    BlockState blockState = this.level.getBlockState(pos);
                    if (!FluidVesselBlock.isVessel(blockState)) continue;
                    FluidVesselBlock.Shape shape = FluidVesselBlock.Shape.PLAIN;
                    if (window) {
                        if (this.windowType == FluidVesselBlock.WindowType.SIDE_HORIZONTAL) {
                            if (yOffset == this.width / 2) {
                                shape = FluidVesselBlock.Shape.WINDOW;
                            }
                        } else if (this.windowType == FluidVesselBlock.WindowType.SIDE_WIDE || this.height <= 1) {
                            if (widthOffset == 0 || widthOffset == this.width - 1) {
                                shape = this.width == 1 ? FluidVesselBlock.Shape.WINDOW : (yOffset == 0 ? FluidVesselBlock.Shape.WINDOW_TOP : (yOffset == this.width - 1 ? FluidVesselBlock.Shape.WINDOW_BOTTOM : FluidVesselBlock.Shape.WINDOW_MIDDLE));
                            }
                        } else if (this.windowType == FluidVesselBlock.WindowType.SIDE_NARROW_ENDS || this.windowType == FluidVesselBlock.WindowType.SIDE_NARROW_THIRDS) {
                            int windowOffset;
                            int n = windowOffset = this.windowType == FluidVesselBlock.WindowType.SIDE_NARROW_ENDS ? 0 : Math.max(1, this.height / 3 - 1);
                            if (!(lengthOffset != windowOffset && lengthOffset != this.height - 1 - windowOffset || widthOffset != 0 && widthOffset != this.width - 1)) {
                                shape = this.width == 1 ? FluidVesselBlock.Shape.WINDOW_SINGLE : (yOffset == 0 ? FluidVesselBlock.Shape.WINDOW_TOP_SINGLE : (yOffset == this.width - 1 ? FluidVesselBlock.Shape.WINDOW_BOTTOM_SINGLE : FluidVesselBlock.Shape.WINDOW_MIDDLE_SINGLE));
                            }
                        }
                    }
                    this.level.setBlock(pos, (BlockState)blockState.setValue(FluidVesselBlock.SHAPE, (Comparable)((Object)shape)), 22);
                    this.level.getChunkSource().getLightEngine().checkBlock(pos);
                }
            }
        }
    }

    public void updateBoilerState() {
        if (!this.isController()) {
            return;
        }
        boolean wasBoiler = this.boiler.isActive();
        boolean changed = this.boiler.evaluate((FluidTankBlockEntity)this);
        if (wasBoiler != this.boiler.isActive()) {
            if (this.boiler.isActive()) {
                this.setWindows(false);
            }
            Direction.Axis axis = this.getAxis();
            for (int yOffset = 0; yOffset < this.width; ++yOffset) {
                for (int lengthOffset = 0; lengthOffset < this.height; ++lengthOffset) {
                    for (int widthOffset = 0; widthOffset < this.width; ++widthOffset) {
                        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.offset(axis == Direction.Axis.X ? lengthOffset : widthOffset, yOffset, axis == Direction.Axis.Z ? lengthOffset : widthOffset));
                        if (!(blockEntity instanceof FluidVesselBlockEntity)) continue;
                        FluidVesselBlockEntity fbe = (FluidVesselBlockEntity)blockEntity;
                        fbe.refreshCapability();
                    }
                }
            }
        }
        if (changed) {
            this.notifyUpdate();
            this.boiler.checkPipeOrganAdvancement((FluidTankBlockEntity)this);
        }
    }

    public void setController(BlockPos controller) {
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    protected void refreshCapability() {
        this.fluidCapability = this.handlerForCapability();
        this.invalidateCapabilities();
    }

    protected IFluidHandler handlerForCapability() {
        return this.isController() ? (this.boiler.isActive() ? this.boiler.createHandler() : this.tankInventory) : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            Direction.Axis axis = this.getAxis();
            return super.createRenderBoundingBox().expandTowards(axis == Direction.Axis.X ? (double)(this.height - 1) : (double)(this.width - 1), (double)(this.width - 1), axis == Direction.Axis.Z ? (double)(this.height - 1) : (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    @Nullable
    public FluidVesselBlockEntity getOtherFluidTankBlockEntity(Direction direction) {
        BlockEntity otherBE = this.level.getBlockEntity(this.worldPosition.relative(direction));
        if (otherBE instanceof FluidVesselBlockEntity) {
            return (FluidVesselBlockEntity)otherBE;
        }
        return null;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        FluidVesselBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        if (controllerBE.boiler.addToGoggleTooltip(tooltip, isPlayerSneaking, controllerBE.getTotalTankSize())) {
            return true;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, controllerBE.getBlockPos(), null));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, registries, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevWidth = this.width;
        int prevLength = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.contains("Uninitialized");
        this.luminosity = compound.getInt("Luminosity");
        this.lastKnownPos = null;
        if (compound.contains("LastKnownPos")) {
            this.lastKnownPos = NBTHelper.readBlockPos((CompoundTag)compound, (String)"LastKnownPos");
        }
        this.controller = null;
        if (compound.contains("Controller")) {
            this.controller = NBTHelper.readBlockPos((CompoundTag)compound, (String)"Controller");
        }
        if (this.isController()) {
            this.window = compound.getBoolean("Window");
            this.windowType = (FluidVesselBlock.WindowType)NBTHelper.readEnum((CompoundTag)compound, (String)"WindowType", FluidVesselBlock.WindowType.class);
            this.width = compound.getInt("Size");
            this.height = compound.getInt("Height");
            this.tankInventory.setCapacity(this.getTotalTankSize() * FluidVesselBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(registries, compound.getCompound("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        this.boiler.read(compound.getCompound("Boiler"), this.width * this.width * this.height);
        if (compound.contains("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (changeOfController || prevWidth != this.width || prevLength != this.height) {
            if (this.hasLevel()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(FluidVesselBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (compound.contains("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)fillState);
            }
            this.fluidLevel.chase((double)fillState, 0.5, LerpedFloat.Chaser.EXP);
        }
        if (this.luminosity != prevLum && this.hasLevel()) {
            this.level.getChunkSource().getLightEngine().checkBlock(this.worldPosition);
        }
        if (compound.contains("LazySync")) {
            this.fluidLevel.chase((double)this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.putBoolean("Uninitialized", true);
        }
        compound.put("Boiler", (Tag)this.boiler.write());
        if (this.lastKnownPos != null) {
            compound.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.putBoolean("Window", this.window);
            NBTHelper.writeEnum((CompoundTag)compound, (String)"WindowType", (Enum)this.windowType);
            compound.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
            compound.putInt("Size", this.width);
            compound.putInt("Height", this.height);
        }
        compound.putInt("Luminosity", this.luminosity);
        super.write(compound, registries, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.putBoolean("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.putBoolean("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    public static int getMaxSize() {
        return 3;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public static int getMaxHeight() {
        return (Integer)AllConfigs.server().fluids.fluidTankMaxHeight.get();
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(LerpedFloat fluidLevel) {
        this.fluidLevel = fluidLevel;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.getBlockState();
        if (FluidVesselBlock.isVessel(state)) {
            Direction.Axis axis = this.getAxis();
            state = (BlockState)state.setValue((Property)FluidVesselBlock.NEGATIVE, (Comparable)Boolean.valueOf(axis == Direction.Axis.X ? this.getController().getX() == this.getBlockPos().getX() : this.getController().getZ() == this.getBlockPos().getZ()));
            state = (BlockState)state.setValue((Property)FluidVesselBlock.POSITIVE, (Comparable)Boolean.valueOf(axis == Direction.Axis.X ? this.getController().getX() + this.height - 1 == this.getBlockPos().getX() : this.getController().getZ() + this.height - 1 == this.getBlockPos().getZ()));
            this.level.setBlock(this.getBlockPos(), state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.updateBoilerState();
        this.setChanged();
    }

    public void setExtraData(@Nullable Object data) {
        if (data == null) {
            this.window = false;
            this.windowType = FluidVesselBlock.WindowType.SIDE_WIDE;
        } else if (data instanceof FluidVesselBlock.WindowType) {
            FluidVesselBlock.WindowType type = (FluidVesselBlock.WindowType)((Object)data);
            this.window = true;
            this.windowType = type;
        }
    }

    @Nullable
    public Object getExtraData() {
        return this.window ? this.windowType : null;
    }

    public Object modifyExtraData(Object data) {
        if (data == null || data instanceof FluidVesselBlock.WindowType) {
            if (data != null && !this.window) {
                return data;
            }
            if (this.window) {
                return this.windowType;
            }
            return null;
        }
        return data;
    }

    public Direction.Axis getMainConnectionAxis() {
        return this.getAxis();
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return this.getMaxWidth();
        }
        return FluidVesselBlockEntity.getMaxHeight();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getTankSize(int tank) {
        return FluidVesselBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public boolean hasWindow() {
        return this.window;
    }

    public int getLuminosity() {
        return this.luminosity;
    }
}

