/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.sequencedpulsegenerator;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.content.sequencedpulsegenerator.SequencedPulseGeneratorBlockEntity;
import com.hlysine.create_connected.content.sequencedpulsegenerator.SequencedPulseGeneratorScreen;
import com.hlysine.create_connected.datagen.advancements.AdvancementBehaviour;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.redstone.diodes.AbstractDiodeBlock;
import com.simibubi.create.content.redstone.diodes.BrassDiodeBlock;
import com.simibubi.create.content.redstone.diodes.PoweredLatchBlock;
import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SequencedPulseGeneratorBlock
extends AbstractDiodeBlock
implements IBE<SequencedPulseGeneratorBlockEntity> {
    public static final BooleanProperty POWERING = BrassDiodeBlock.POWERING;
    public static final BooleanProperty POWERED_SIDE = PoweredLatchBlock.POWERED_SIDE;
    public static final MapCodec<SequencedPulseGeneratorBlock> CODEC = SequencedPulseGeneratorBlock.simpleCodec(SequencedPulseGeneratorBlock::new);

    public SequencedPulseGeneratorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERING, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED_SIDE, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends DiodeBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, POWERING, POWERED_SIDE, FACING});
        super.createBlockStateDefinition(builder);
    }

    public void setPlacedBy(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull LivingEntity placer, @NotNull ItemStack stack) {
        AdvancementBehaviour.trackOwner(worldIn, pos, placer);
    }

    protected void checkTickOnNeighbor(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        if (!this.isLocked((LevelReader)pLevel, pPos, pState)) {
            boolean currSide;
            boolean prevPower = (Boolean)pState.getValue((Property)POWERED);
            boolean currPower = this.shouldTurnOn(pLevel, pPos, pState);
            boolean prevSide = (Boolean)pState.getValue((Property)POWERED_SIDE);
            boolean bl = currSide = this.getAlternateSignal((SignalGetter)pLevel, pPos, pState) > 0;
            if (!(prevPower == currPower && prevSide == currSide || pLevel.getBlockTicks().willTickThisTick(pPos, (Object)this))) {
                TickPriority tickpriority = TickPriority.HIGH;
                if (this.shouldPrioritize((BlockGetter)pLevel, pPos, pState)) {
                    tickpriority = TickPriority.EXTREMELY_HIGH;
                } else if (prevPower || prevSide) {
                    tickpriority = TickPriority.VERY_HIGH;
                }
                pLevel.scheduleTick(pPos, (Block)this, this.getDelay(pState), tickpriority);
            }
        }
    }

    public void updateNeighborsInFront(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        super.updateNeighborsInFront(pLevel, pPos, pState);
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel worldIn, @NotNull BlockPos pos, @NotNull RandomSource r) {
        if (!this.isLocked((LevelReader)worldIn, pos, state)) {
            boolean prevPower = (Boolean)state.getValue((Property)POWERED);
            boolean currPower = this.shouldTurnOn((Level)worldIn, pos, state);
            boolean prevSide = (Boolean)state.getValue((Property)POWERED_SIDE);
            boolean currSide = this.getAlternateSignal((SignalGetter)worldIn, pos, state) > 0;
            BlockState oldState = state;
            if (prevPower != currPower) {
                state = (BlockState)state.cycle((Property)POWERED);
            }
            if (prevSide != currSide) {
                state = (BlockState)state.cycle((Property)POWERED_SIDE);
            }
            if (oldState != state) {
                worldIn.setBlock(pos, state, 2);
            }
            if (currSide) {
                this.withBlockEntityDo((BlockGetter)worldIn, pos, SequencedPulseGeneratorBlockEntity::reset);
                return;
            }
            this.withBlockEntityDo((BlockGetter)worldIn, pos, spg -> spg.onRedstoneUpdate(currPower));
        }
    }

    protected int getOutputSignal(@NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        BlockEntity be = worldIn.getBlockEntity(pos);
        if (!(be instanceof SequencedPulseGeneratorBlockEntity)) {
            return (Boolean)state.getValue((Property)POWERING) != false ? 15 : 0;
        }
        SequencedPulseGeneratorBlockEntity spg = (SequencedPulseGeneratorBlockEntity)be;
        return spg.getCurrentSignal();
    }

    public int getSignal(BlockState blockState, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        return blockState.getValue((Property)FACING) == side ? this.getOutputSignal(blockAccess, pos, blockState) : 0;
    }

    protected int getDelay(@NotNull BlockState state) {
        return 2;
    }

    public boolean canConnectRedstone(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, Direction side) {
        if (side == null) {
            return false;
        }
        return side.getAxis().isHorizontal();
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)world, pos).map(be -> be.currentInstruction + 1).orElse(0);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (AllItems.WRENCH.isIn(stack)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> this.withBlockEntityDo((BlockGetter)level, pos, be -> this.displayScreen((SequencedPulseGeneratorBlockEntity)((Object)((Object)((Object)be))), player)));
        return ItemInteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> this.displayScreen((SequencedPulseGeneratorBlockEntity)((Object)((Object)((Object)be))), player)));
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(SequencedPulseGeneratorBlockEntity be, Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new SequencedPulseGeneratorScreen(be));
        }
    }

    public Class<SequencedPulseGeneratorBlockEntity> getBlockEntityClass() {
        return SequencedPulseGeneratorBlockEntity.class;
    }

    public BlockEntityType<? extends SequencedPulseGeneratorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.SEQUENCED_PULSE_GENERATOR.get();
    }
}

