/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.mixin;

import com.hlysine.create_connected.content.IConnectionForwardingBlock;
import com.hlysine.create_connected.content.ISplitShaftBlockEntity;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RotationPropagator.class})
public abstract class RotationPropagatorMixin {
    @Inject(method={"getAxisModifier"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getSplitShaftModifier(KineticBlockEntity be, Direction direction, CallbackInfoReturnable<Float> cir) {
        if (!be.hasSource() && !be.isSource()) {
            return;
        }
        if (be instanceof ISplitShaftBlockEntity) {
            ISplitShaftBlockEntity splitShaftBE = (ISplitShaftBlockEntity)be;
            cir.setReturnValue((Object)Float.valueOf(splitShaftBE.getRotationSpeedModifier(direction)));
        }
    }

    @Inject(method={"getPotentialNeighbourLocations"}, at={@At(value="RETURN")}, cancellable=true)
    private static void forwardConnection(KineticBlockEntity be, CallbackInfoReturnable<List<BlockPos>> cir) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>((Collection)cir.getReturnValue());
        for (int i = 0; i < positions.size(); ++i) {
            Block block;
            BlockPos sourcePos = be.getBlockPos();
            BlockPos neighborPos = (BlockPos)positions.get(i);
            while (sourcePos != neighborPos && (block = be.getLevel().getBlockState(neighborPos).getBlock()) instanceof IConnectionForwardingBlock) {
                IConnectionForwardingBlock forwardingBlock = (IConnectionForwardingBlock)block;
                BlockPos tempSource = sourcePos;
                sourcePos = neighborPos;
                neighborPos = forwardingBlock.forwardConnection(be.getLevel(), tempSource, be.getLevel().getBlockState(tempSource), neighborPos);
            }
            positions.set(i, neighborPos);
        }
        cir.setReturnValue(positions);
    }
}

