/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.datagen.recipes;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.CCItems;
import com.hlysine.create_connected.CreateConnected;
import com.hlysine.create_connected.compat.CopycatsManager;
import com.hlysine.create_connected.datagen.recipes.FeatureEnabledCondition;
import com.hlysine.create_connected.datagen.recipes.FeatureEnabledInCopycatsCondition;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import org.jetbrains.annotations.NotNull;

public class CCStandardRecipes
extends CreateRecipeProvider {
    private final Marker KINETICS = this.enterFolder("kinetics");
    CreateRecipeProvider.GeneratedRecipe ENCASED_CHAIN_COGWHEEL = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.ENCASED_CHAIN_COGWHEEL).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.ENCASED_CHAIN_DRIVE).get())).requiresResultFeature().viaShapeless(b -> b.m_126209_((ItemLike)AllBlocks.ENCASED_CHAIN_DRIVE).m_126209_((ItemLike)AllBlocks.COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe CRANK_WHEEL = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.CRANK_WHEEL).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.COGWHEEL).get())).requiresResultFeature().viaShapeless(b -> b.m_126209_((ItemLike)AllBlocks.HAND_CRANK).m_126209_((ItemLike)AllBlocks.COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe LARGE_CRANK_WHEEL = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.LARGE_CRANK_WHEEL).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.LARGE_COGWHEEL).get())).requiresResultFeature().viaShapeless(b -> b.m_126209_((ItemLike)AllBlocks.HAND_CRANK).m_126209_((ItemLike)AllBlocks.LARGE_COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe INVERTED_CLUTCH_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike>>)ImmutableList.of((Object)AllBlocks.CLUTCH, CCBlocks.INVERTED_CLUTCH));
    CreateRecipeProvider.GeneratedRecipe INVERTED_GEARSHIFT_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike>>)ImmutableList.of((Object)AllBlocks.GEARSHIFT, CCBlocks.INVERTED_GEARSHIFT));
    CreateRecipeProvider.GeneratedRecipe PARALLEL_GEARBOX = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.PARALLEL_GEARBOX).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.LARGE_COGWHEEL).get())).requiresResultFeature().viaShapeless(b -> b.m_126209_((ItemLike)AllBlocks.GEARBOX).m_126209_((ItemLike)AllBlocks.LARGE_COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe PARALLEL_GEARBOX_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike>>)ImmutableList.of(CCBlocks.PARALLEL_GEARBOX, CCItems.VERTICAL_PARALLEL_GEARBOX));
    CreateRecipeProvider.GeneratedRecipe SIX_WAY_GEARBOX = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.SIX_WAY_GEARBOX).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.LARGE_COGWHEEL).get())).requiresResultFeature().viaShaped(b -> b.m_126127_(Character.valueOf('c'), (ItemLike)AllBlocks.COGWHEEL).m_126127_(Character.valueOf('l'), (ItemLike)AllBlocks.LARGE_COGWHEEL).m_126127_(Character.valueOf('s'), (ItemLike)AllBlocks.ANDESITE_CASING).m_126130_("lc ").m_126130_("csc").m_126130_(" cl"));
    CreateRecipeProvider.GeneratedRecipe SIX_WAY_GEARBOX_FROM_GEARBOX = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.SIX_WAY_GEARBOX).withSuffix("_from_gearbox").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.GEARBOX).get())).requiresResultFeature().viaShapeless(b -> b.m_126209_((ItemLike)AllBlocks.GEARBOX).m_126209_((ItemLike)AllBlocks.LARGE_COGWHEEL).m_126209_((ItemLike)AllBlocks.LARGE_COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe SIX_WAY_GEARBOX_FROM_PARALLEL = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.SIX_WAY_GEARBOX).withSuffix("_from_parallel").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCBlocks.PARALLEL_GEARBOX.get())).requiresResultFeature().requiresFeature(CCBlocks.PARALLEL_GEARBOX).viaShapeless(b -> b.m_126209_(CCBlocks.PARALLEL_GEARBOX).m_126209_((ItemLike)AllBlocks.LARGE_COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe SIX_WAY_GEARBOX_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike>>)ImmutableList.of(CCBlocks.SIX_WAY_GEARBOX, CCItems.VERTICAL_SIX_WAY_GEARBOX));
    CreateRecipeProvider.GeneratedRecipe BRASS_GEARBOX = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.BRASS_GEARBOX).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.ROTATION_SPEED_CONTROLLER).get())).requiresResultFeature().viaShaped(b -> b.m_126127_(Character.valueOf('c'), (ItemLike)AllBlocks.COGWHEEL).m_126127_(Character.valueOf('s'), (ItemLike)AllBlocks.ROTATION_SPEED_CONTROLLER).m_126130_(" c ").m_126130_("csc").m_126130_(" c "));
    CreateRecipeProvider.GeneratedRecipe BRASS_GEARBOX_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike>>)ImmutableList.of(CCBlocks.BRASS_GEARBOX, CCItems.VERTICAL_BRASS_GEARBOX));
    CreateRecipeProvider.GeneratedRecipe CROSS_CONNECTOR = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.CROSS_CONNECTOR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.GEARBOX).get())).requiresResultFeature().viaShaped(b -> b.m_126127_(Character.valueOf('g'), (ItemLike)AllBlocks.GEARBOX).m_126127_(Character.valueOf('s'), (ItemLike)AllBlocks.SHAFT).m_126130_(" s ").m_126130_("sgs").m_126130_(" s "));
    CreateRecipeProvider.GeneratedRecipe OVERSTRESS_CLUTCH = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.OVERSTRESS_CLUTCH).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.ELECTRON_TUBE).get())).requiresResultFeature().viaShapeless(b -> b.m_126209_((ItemLike)AllBlocks.ANDESITE_CASING).m_126209_((ItemLike)AllBlocks.SHAFT).m_126209_((ItemLike)AllItems.IRON_SHEET).m_126209_((ItemLike)AllItems.ELECTRON_TUBE));
    CreateRecipeProvider.GeneratedRecipe CENTRIFUGAL_CLUTCH = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.CENTRIFUGAL_CLUTCH).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.SPEEDOMETER).get())).requiresResultFeature().viaShapeless(b -> b.m_126209_((ItemLike)AllBlocks.ANDESITE_CASING).m_126209_((ItemLike)AllBlocks.SHAFT).m_126209_((ItemLike)AllItems.IRON_SHEET).m_126209_((ItemLike)AllBlocks.SPEEDOMETER));
    CreateRecipeProvider.GeneratedRecipe FREEWHEEL_CLUTCH = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.FREEWHEEL_CLUTCH).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.COGWHEEL).get())).requiresResultFeature().viaShapeless(b -> b.m_126209_((ItemLike)AllBlocks.ANDESITE_CASING).m_126209_((ItemLike)AllBlocks.SHAFT).m_126209_((ItemLike)AllItems.IRON_SHEET).m_126209_((ItemLike)AllBlocks.COGWHEEL));
    CreateRecipeProvider.GeneratedRecipe BRAKE = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.BRAKE).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((Block)Blocks.f_50080_).m_5456_())).requiresResultFeature().viaShapeless(b -> b.m_126209_((ItemLike)AllBlocks.ANDESITE_CASING).m_126209_((ItemLike)AllBlocks.SHAFT).m_126209_((ItemLike)Blocks.f_50088_).m_126209_((ItemLike)Blocks.f_50080_));
    CreateRecipeProvider.GeneratedRecipe KINETIC_BRIDGE = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.KINETIC_BRIDGE).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.CLUTCH).get())).requiresResultFeature().viaShaped(b -> b.m_126127_(Character.valueOf('c'), (ItemLike)AllBlocks.CLUTCH).m_126127_(Character.valueOf('s'), (ItemLike)AllBlocks.SHAFT).m_126127_(Character.valueOf('b'), (ItemLike)AllBlocks.BRASS_CASING).m_126130_(" b ").m_126130_("scs").m_126130_(" b "));
    CreateRecipeProvider.GeneratedRecipe KINETIC_BATTERY = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.KINETIC_BATTERY).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.ELECTRON_TUBE).get())).requiresResultFeature().returns(8).viaShaped(b -> b.m_126127_(Character.valueOf('p'), (ItemLike)AllItems.PRECISION_MECHANISM).m_126127_(Character.valueOf('b'), (ItemLike)AllBlocks.BRASS_CASING).m_126127_(Character.valueOf('r'), (ItemLike)Blocks.f_50088_).m_126127_(Character.valueOf('i'), (ItemLike)AllItems.IRON_SHEET).m_126130_(" p ").m_126130_(" b ").m_126130_("iri"));
    CreateRecipeProvider.GeneratedRecipe SEQUENCED_PULSE_GENERATOR = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.SEQUENCED_PULSE_GENERATOR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCItems.CONTROL_CHIP.get())).requiresResultFeature().viaShaped(b -> b.m_126127_(Character.valueOf('E'), (ItemLike)AllItems.ELECTRON_TUBE).m_126127_(Character.valueOf('B'), (ItemLike)AllItems.BRASS_SHEET).m_126127_(Character.valueOf('C'), CCItems.CONTROL_CHIP).m_126127_(Character.valueOf('T'), (ItemLike)Blocks.f_50174_).m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_126130_("EC ").m_126130_("EBT").m_126130_("SSS"));
    CreateRecipeProvider.GeneratedRecipe LINKED_TRANSMITTER_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike>>)ImmutableList.of(CCItems.LINKED_TRANSMITTER, (Object)AllBlocks.REDSTONE_LINK));
    CreateRecipeProvider.GeneratedRecipe REDSTONE_LINK_WILDCARD = this.create((ItemProviderEntry<? extends ItemLike>)CCItems.REDSTONE_LINK_WILDCARD).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.TRANSMITTER).get())).requiresResultFeature().viaShapeless(b -> b.m_126209_((ItemLike)AllItems.TRANSMITTER).m_126209_((ItemLike)AllItems.CRAFTER_SLOT_COVER));
    CreateRecipeProvider.GeneratedRecipe ITEM_SILO = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.ITEM_SILO).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)() -> Tags.Items.BARRELS_WOODEN)).requiresResultFeature().viaShaped(b -> b.m_126127_(Character.valueOf('B'), (ItemLike)AllItems.IRON_SHEET).m_206416_(Character.valueOf('C'), Tags.Items.BARRELS_WOODEN).m_126130_("BCB"));
    CreateRecipeProvider.GeneratedRecipe ITEM_SILO_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike>>)ImmutableList.of(CCBlocks.ITEM_SILO, (Object)AllBlocks.ITEM_VAULT));
    CreateRecipeProvider.GeneratedRecipe FLUID_VESSEL = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.FLUID_VESSEL).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)() -> Tags.Items.BARRELS_WOODEN)).requiresResultFeature().viaShaped(b -> b.m_126127_(Character.valueOf('B'), (ItemLike)AllItems.COPPER_SHEET).m_206416_(Character.valueOf('C'), Tags.Items.BARRELS_WOODEN).m_126130_("BCB"));
    CreateRecipeProvider.GeneratedRecipe FLUID_VESSEL_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike>>)ImmutableList.of(CCBlocks.FLUID_VESSEL, (Object)AllBlocks.FLUID_TANK));
    CreateRecipeProvider.GeneratedRecipe INVENTORY_ACCESS_PORT = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.INVENTORY_ACCESS_PORT).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.ELECTRON_TUBE).get())).requiresResultFeature().returns(2).viaShaped(b -> b.m_126127_(Character.valueOf('B'), (ItemLike)AllBlocks.BRASS_CASING).m_126127_(Character.valueOf('C'), (ItemLike)AllBlocks.CHUTE).m_126127_(Character.valueOf('E'), (ItemLike)AllItems.ELECTRON_TUBE).m_126130_("B").m_126130_("C").m_126130_("E"));
    CreateRecipeProvider.GeneratedRecipe INVENTORY_BRIDGE = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.INVENTORY_BRIDGE).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.ELECTRON_TUBE).get())).requiresResultFeature().viaShapeless(b -> b.m_126209_(CCBlocks.INVENTORY_ACCESS_PORT).m_126209_(CCBlocks.INVENTORY_ACCESS_PORT));
    CreateRecipeProvider.GeneratedRecipe EMPTY_FAN_CATALYST = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.EMPTY_FAN_CATALYST).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.BRASS_BLOCK).get())).requiresResultFeature().viaShaped(b -> b.m_126127_(Character.valueOf('b'), (ItemLike)AllItems.BRASS_INGOT).m_126127_(Character.valueOf('i'), (ItemLike)Blocks.f_50183_).m_126130_("bib").m_126130_("i i").m_126130_("bib"));
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_BLASTING = this.clearFanCatalyst("blasting", (ItemProviderEntry<? extends ItemLike>)CCBlocks.FAN_BLASTING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_SMOKING = this.clearFanCatalyst("smoking", (ItemProviderEntry<? extends ItemLike>)CCBlocks.FAN_SMOKING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_SPLASHING = this.clearFanCatalyst("splashing", (ItemProviderEntry<? extends ItemLike>)CCBlocks.FAN_SPLASHING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_HAUNTING = this.clearFanCatalyst("haunting", (ItemProviderEntry<? extends ItemLike>)CCBlocks.FAN_HAUNTING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_FREEZING = this.clearFanCatalyst("freezing", (ItemProviderEntry<? extends ItemLike>)CCBlocks.FAN_FREEZING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_SEETHING = this.clearFanCatalyst("seething", (ItemProviderEntry<? extends ItemLike>)CCBlocks.FAN_SEETHING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_SANDING = this.clearFanCatalyst("sanding", (ItemProviderEntry<? extends ItemLike>)CCBlocks.FAN_SANDING_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_ENRICHED = this.clearFanCatalyst("enriched", (ItemProviderEntry<? extends ItemLike>)CCBlocks.FAN_ENRICHED_CATALYST);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_ENDING_DRAGONS_BREATH = this.clearFanCatalyst("ending_dragons_breath", (ItemProviderEntry<? extends ItemLike>)CCBlocks.FAN_ENDING_CATALYST_DRAGONS_BREATH);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_ENDING_DRAGON_HEAD = this.clearFanCatalyst("ending_dragon_head", (ItemProviderEntry<? extends ItemLike>)CCBlocks.FAN_ENDING_CATALYST_DRAGON_HEAD);
    CreateRecipeProvider.GeneratedRecipe EMPTY_CATALYST_FROM_WITHERING = this.clearFanCatalyst("withering", (ItemProviderEntry<? extends ItemLike>)CCBlocks.FAN_WITHERING_CATALYST);
    private final Marker PALETTES = this.enterFolder("palettes");
    CreateRecipeProvider.GeneratedRecipe COPYCAT_SLAB = this.copycat((ItemProviderEntry<? extends ItemLike>)CCBlocks.COPYCAT_SLAB, 2);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_SLAB_FROM_PANELS = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.COPYCAT_SLAB).withSuffix("_from_panels").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.COPYCAT_PANEL).get())).requiresResultFeature().disabledInCopycats().viaShaped(b -> b.m_126127_(Character.valueOf('p'), (ItemLike)AllBlocks.COPYCAT_PANEL).m_126130_("p").m_126130_("p"));
    CreateRecipeProvider.GeneratedRecipe COPYCAT_SLAB_FROM_STEPS = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.COPYCAT_SLAB).withSuffix("_from_steps").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.COPYCAT_STEP).get())).requiresResultFeature().disabledInCopycats().viaShaped(b -> b.m_126127_(Character.valueOf('s'), (ItemLike)AllBlocks.COPYCAT_STEP).m_126130_("ss"));
    CreateRecipeProvider.GeneratedRecipe COPYCAT_SLAB_FROM_BEAMS = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.COPYCAT_SLAB).withSuffix("_from_beams").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCBlocks.COPYCAT_BEAM.get())).requiresResultFeature().disabledInCopycats().requiresFeature(CCBlocks.COPYCAT_BEAM).viaShaped(b -> b.m_126127_(Character.valueOf('s'), CCBlocks.COPYCAT_BEAM).m_126130_("ss"));
    CreateRecipeProvider.GeneratedRecipe COPYCAT_BLOCK = this.copycat((ItemProviderEntry<? extends ItemLike>)CCBlocks.COPYCAT_BLOCK, 1);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_BLOCK_FROM_SLABS = this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.COPYCAT_BLOCK).withSuffix("_from_slabs").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCBlocks.COPYCAT_SLAB.get())).requiresResultFeature().disabledInCopycats().requiresFeature(CCBlocks.COPYCAT_SLAB).viaShaped(b -> b.m_126127_(Character.valueOf('s'), CCBlocks.COPYCAT_SLAB).m_126130_("s").m_126130_("s"));
    CreateRecipeProvider.GeneratedRecipe COPYCAT_BEAM = this.copycat((ItemProviderEntry<? extends ItemLike>)CCBlocks.COPYCAT_BEAM, 4);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_STEP_CYCLE = this.copycatCycle((List<ItemProviderEntry<? extends ItemLike>>)ImmutableList.of((Object)AllBlocks.COPYCAT_STEP, CCBlocks.COPYCAT_VERTICAL_STEP));
    CreateRecipeProvider.GeneratedRecipe COPYCAT_VERTICAL_STEP = this.copycat((ItemProviderEntry<? extends ItemLike>)CCBlocks.COPYCAT_VERTICAL_STEP, 4);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_STAIRS = this.copycat((ItemProviderEntry<? extends ItemLike>)CCBlocks.COPYCAT_STAIRS, 1);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_FENCE = this.copycat((ItemProviderEntry<? extends ItemLike>)CCBlocks.COPYCAT_FENCE, 1);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_FENCE_GATE = this.copycat((ItemProviderEntry<? extends ItemLike>)CCBlocks.COPYCAT_FENCE_GATE, 1);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_WALL = this.copycat((ItemProviderEntry<? extends ItemLike>)CCBlocks.COPYCAT_WALL, 1);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_BOARD = this.copycat((ItemProviderEntry<? extends ItemLike>)CCBlocks.COPYCAT_BOARD, 8);
    CreateRecipeProvider.GeneratedRecipe COPYCAT_BOX = this.create((ItemProviderEntry<? extends ItemLike>)CCItems.COPYCAT_BOX).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCBlocks.COPYCAT_BOARD.get())).requiresResultFeature().disabledInCopycats().viaShaped(b -> b.m_126127_(Character.valueOf('s'), CCBlocks.COPYCAT_BOARD).m_126130_("ss ").m_126130_("s s").m_126130_(" ss"));
    CreateRecipeProvider.GeneratedRecipe COPYCAT_CATWALK = this.create((ItemProviderEntry<? extends ItemLike>)CCItems.COPYCAT_CATWALK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCBlocks.COPYCAT_BOARD.get())).requiresResultFeature().disabledInCopycats().viaShaped(b -> b.m_126127_(Character.valueOf('s'), CCBlocks.COPYCAT_BOARD).m_126130_("s s").m_126130_(" s "));
    String currentFolder = "";

    Marker enterFolder(String folder) {
        this.currentFolder = folder;
        return new Marker();
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike> result) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get()));
    }

    CreateRecipeProvider.GeneratedRecipe createSpecial(Supplier<? extends SimpleCraftingRecipeSerializer<?>> serializer, String recipeType, String path) {
        ResourceLocation location = CreateConnected.asResource(recipeType + "/" + this.currentFolder + "/" + path);
        return this.register(consumer -> {
            SpecialRecipeBuilder b = SpecialRecipeBuilder.m_245676_((RecipeSerializer)((RecipeSerializer)serializer.get()));
            b.m_126359_(consumer, location.toString());
        });
    }

    CreateRecipeProvider.GeneratedRecipe copycatCycle(List<ItemProviderEntry<? extends ItemLike>> cycle) {
        CreateRecipeProvider.GeneratedRecipe result = null;
        for (int i = 0; i < cycle.size(); ++i) {
            ItemProviderEntry<? extends ItemLike> currentEntry = cycle.get(i);
            ItemProviderEntry<? extends ItemLike> nextEntry = cycle.get((i + 1) % cycle.size());
            result = this.create(nextEntry).withSuffix("_from_conversion").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> currentEntry.get())).requiresFeature(currentEntry.getId()).disabledInCopycats().requiresFeature(nextEntry.getId()).viaShapeless(b -> b.m_126209_((ItemLike)currentEntry.get()));
        }
        return result;
    }

    CreateRecipeProvider.GeneratedRecipe conversionCycle(List<ItemProviderEntry<? extends ItemLike>> cycle) {
        CreateRecipeProvider.GeneratedRecipe result = null;
        for (int i = 0; i < cycle.size(); ++i) {
            ItemProviderEntry<? extends ItemLike> currentEntry = cycle.get(i);
            ItemProviderEntry<? extends ItemLike> nextEntry = cycle.get((i + 1) % cycle.size());
            result = this.create(nextEntry).withSuffix("_from_conversion").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> currentEntry.get())).requiresFeature(currentEntry.getId()).requiresFeature(nextEntry.getId()).viaShapeless(b -> b.m_126209_((ItemLike)currentEntry.get()));
        }
        return result;
    }

    CreateRecipeProvider.GeneratedRecipe clearFanCatalyst(String key, ItemProviderEntry<? extends ItemLike> from) {
        return this.create((ItemProviderEntry<? extends ItemLike>)CCBlocks.EMPTY_FAN_CATALYST).withSuffix("_from_" + key).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CCBlocks.EMPTY_FAN_CATALYST.get())).requiresResultFeature().viaShapeless(b -> b.m_126209_((ItemLike)from));
    }

    CreateRecipeProvider.GeneratedRecipe copycat(ItemProviderEntry<? extends ItemLike> result, int resultCount) {
        if (CopycatsManager.convert(result) != result) {
            this.create((Supplier<ItemLike>)((Supplier)() -> CopycatsManager.convert((ItemLike)result))).withSuffix("_compat").requiresFeature(CatnipServices.REGISTRIES.getKeyOrThrow(result.m_5456_())).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> result.get())).enabledInCopycats().viaShapeless(b -> b.m_126209_((ItemLike)result));
        }
        return this.create(result).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.ZINC_INGOT).get())).requiresResultFeature().disabledInCopycats().viaStonecutting((Ingredient)DataIngredient.tag((TagKey)AllTags.forgeItemTag((String)"ingots/zinc")), resultCount);
    }

    CreateRecipeProvider.GeneratedRecipe window(Supplier<? extends ItemLike> ingredient, ItemProviderEntry<? extends ItemLike> result) {
        return this.create(result).unlockedBy(ingredient).inCategory(RecipeCategory.BUILDING_BLOCKS).requiresResultFeature().returns(2).viaShaped(b -> b.m_126130_(" # ").m_126130_("#X#").m_126127_(Character.valueOf('#'), (ItemLike)ingredient.get()).m_126124_(Character.valueOf('X'), (Ingredient)DataIngredient.tag((TagKey)Tags.Items.GLASS_COLORLESS)));
    }

    CreateRecipeProvider.GeneratedRecipe windowPane(Supplier<? extends ItemLike> ingredient, ItemProviderEntry<? extends ItemLike> result) {
        return this.create(result).unlockedBy(ingredient).inCategory(RecipeCategory.BUILDING_BLOCKS).requiresResultFeature().returns(16).viaShaped(b -> b.m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)ingredient.get()));
    }

    @NotNull
    public String m_6055_() {
        return "Create: Connected's Standard Recipes";
    }

    public CCStandardRecipes(PackOutput p_i48262_1_) {
        super(p_i48262_1_);
    }

    protected static class Marker {
        protected Marker() {
        }
    }

    class GeneratedRecipeBuilder {
        private final String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private RecipeCategory category = null;
        private ResourceLocation compatDatagenOutput;
        List<ICondition> recipeConditions;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.recipeConditions = new ArrayList<ICondition>();
            this.suffix = "";
            this.amount = 1;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)item.get()}).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_204145_((TagKey)tag.get()).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder inCategory(RecipeCategory category) {
            this.category = category;
            return this;
        }

        GeneratedRecipeBuilder whenModLoaded(String modid) {
            return this.withCondition((ICondition)new ModLoadedCondition(modid));
        }

        GeneratedRecipeBuilder whenModMissing(String modid) {
            return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
        }

        GeneratedRecipeBuilder withCondition(ICondition condition) {
            this.recipeConditions.add(condition);
            return this;
        }

        GeneratedRecipeBuilder requiresFeature(ResourceLocation location) {
            this.recipeConditions.add(new FeatureEnabledCondition(location));
            return this;
        }

        GeneratedRecipeBuilder requiresFeature(BlockEntry<?> block) {
            return this.requiresFeature(block.getId());
        }

        GeneratedRecipeBuilder requiresResultFeature() {
            return this.requiresFeature(CatnipServices.REGISTRIES.getKeyOrThrow(((ItemLike)this.result.get()).m_5456_()));
        }

        GeneratedRecipeBuilder disabledInCopycats() {
            return this.withCondition((ICondition)new NotCondition((ICondition)new FeatureEnabledInCopycatsCondition(CatnipServices.REGISTRIES.getKeyOrThrow(((ItemLike)this.result.get()).m_5456_()))));
        }

        GeneratedRecipeBuilder enabledInCopycats() {
            return this.withCondition(new FeatureEnabledInCopycatsCondition(CatnipServices.REGISTRIES.getKeyOrThrow(((ItemLike)this.result.get()).m_5456_())));
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        CreateRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return this.handleConditions(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)(this.category == null ? RecipeCategory.MISC : this.category), (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)CCStandardRecipes.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createLocation("crafting"));
            });
        }

        CreateRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return this.handleConditions(consumer -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)(this.category == null ? RecipeCategory.MISC : this.category), (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)CCStandardRecipes.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createLocation("crafting"));
            });
        }

        CreateRecipeProvider.GeneratedRecipe viaStonecutting(Ingredient ingredient, int resultCount) {
            return this.handleConditions(consumer -> {
                SingleItemRecipeBuilder b = SingleItemRecipeBuilder.m_246944_((Ingredient)ingredient, (RecipeCategory)(this.category == null ? RecipeCategory.BUILDING_BLOCKS : this.category), (ItemLike)((ItemLike)this.result.get()), (int)resultCount);
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)CCStandardRecipes.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createLocation("crafting"));
            });
        }

        CreateRecipeProvider.GeneratedRecipe viaStonecutting(Ingredient ingredient) {
            return this.viaStonecutting(ingredient, 1);
        }

        CreateRecipeProvider.GeneratedRecipe viaNetheriteSmithing(Supplier<? extends Item> base, Supplier<Ingredient> upgradeMaterial) {
            return this.handleConditions(consumer -> {
                SmithingTransformRecipeBuilder b = SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_265918_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)base.get()}), (Ingredient)((Ingredient)upgradeMaterial.get()), (RecipeCategory)(this.category == null ? RecipeCategory.COMBAT : this.category), (Item)((ItemLike)this.result.get()).m_5456_());
                b.m_266439_("has_item", (CriterionTriggerInstance)CCStandardRecipes.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)base.get()}).m_45077_()}));
                b.m_266371_(consumer, this.createLocation("crafting"));
            });
        }

        private CreateRecipeProvider.GeneratedRecipe handleConditions(Consumer<Consumer<FinishedRecipe>> recipe) {
            return CCStandardRecipes.this.register(consumer -> {
                if (!this.recipeConditions.isEmpty()) {
                    ConditionalRecipe.Builder b = ConditionalRecipe.builder();
                    this.recipeConditions.forEach(arg_0 -> ((ConditionalRecipe.Builder)b).addCondition(arg_0));
                    b.addRecipe(recipe);
                    b.generateAdvancement();
                    b.build(consumer, this.createLocation("crafting"));
                } else {
                    recipe.accept(consumer);
                }
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return CreateConnected.asResource(recipeType + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation createLocation(String recipeType) {
            return CreateConnected.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? CatnipServices.REGISTRIES.getKeyOrThrow(((ItemLike)this.result.get()).m_5456_()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()})));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.m_204132_((TagKey)((TagKey)tag.get()))));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private final Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;
            private final RecipeSerializer<? extends AbstractCookingRecipe> FURNACE = RecipeSerializer.f_44091_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> SMOKER = RecipeSerializer.f_44093_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> BLAST = RecipeSerializer.f_44092_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> CAMPFIRE = RecipeSerializer.f_44094_;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            CreateRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(this.FURNACE, builder, 1.0f);
            }

            CreateRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                this.create(this.CAMPFIRE, builder, 3.0f);
                return this.create(this.SMOKER, builder, 0.5f);
            }

            CreateRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                return this.create(this.BLAST, builder, 0.5f);
            }

            private CreateRecipeProvider.GeneratedRecipe create(RecipeSerializer<? extends AbstractCookingRecipe> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, float cookingTimeModifier) {
                return CCStandardRecipes.this.register(consumer -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.m_247607_((Ingredient)((Ingredient)this.ingredient.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.f_42329_ : (ItemLike)GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.m_126132_("has_item", (CriterionTriggerInstance)CCStandardRecipes.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    b.m_126140_(result -> consumer.accept(isOtherMod ? new ModdedCookingRecipeResult((FinishedRecipe)result, GeneratedRecipeBuilder.this.compatDatagenOutput, GeneratedRecipeBuilder.this.recipeConditions) : result), GeneratedRecipeBuilder.this.createSimpleLocation(CatnipServices.REGISTRIES.getKeyOrThrow(serializer).m_135815_()));
                });
            }
        }
    }

    private static class ModdedCookingRecipeResult
    implements FinishedRecipe {
        private final FinishedRecipe wrapped;
        private final ResourceLocation outputOverride;
        private final List<ICondition> conditions;

        @NotNull
        public ResourceLocation m_6445_() {
            return this.wrapped.m_6445_();
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return this.wrapped.m_6637_();
        }

        public JsonObject m_5860_() {
            return this.wrapped.m_5860_();
        }

        public ResourceLocation m_6448_() {
            return this.wrapped.m_6448_();
        }

        public void m_7917_(@NotNull JsonObject object) {
            this.wrapped.m_7917_(object);
            object.addProperty("result", this.outputOverride.toString());
            JsonArray conds = new JsonArray();
            this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            object.add("conditions", (JsonElement)conds);
        }

        public ModdedCookingRecipeResult(FinishedRecipe wrapped, ResourceLocation outputOverride, List<ICondition> conditions) {
            this.wrapped = wrapped;
            this.outputOverride = outputOverride;
            this.conditions = conditions;
        }
    }
}

