/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.crossconnector;

import com.hlysine.create_connected.CCShapes;
import com.hlysine.create_connected.content.IConnectionForwardingBlock;
import com.hlysine.create_connected.content.KineticHelper;
import com.simibubi.create.content.decoration.encasing.EncasableBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CrossConnectorBlock
extends Block
implements IWrenchable,
IConnectionForwardingBlock,
IRotate,
EncasableBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;

    public CrossConnectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Y));
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public static Direction.Axis getPreferredAxis(BlockPlaceContext context) {
        Direction.Axis prefferedAxis = null;
        for (Direction side : Iterate.directions) {
            BlockState blockState = context.m_43725_().m_8055_(context.m_8083_().m_121945_(side));
            if (!(blockState.m_60734_() instanceof IRotate) || !((IRotate)blockState.m_60734_()).hasShaftTowards((LevelReader)context.m_43725_(), context.m_8083_().m_121945_(side), blockState, side.m_122424_())) continue;
            if (prefferedAxis != null && prefferedAxis != side.m_122434_()) {
                prefferedAxis = null;
                break;
            }
            prefferedAxis = side.m_122434_();
        }
        return prefferedAxis;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Direction.Axis preferredAxis = CrossConnectorBlock.getPreferredAxis(context);
        if (!(preferredAxis == null || context.m_43723_() != null && context.m_43723_().m_6144_())) {
            Direction.Axis lookingAxis = context.m_7820_().m_122434_();
            if (lookingAxis == preferredAxis) {
                return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)(preferredAxis.m_122478_() ? Direction.Axis.X : Direction.Axis.Y));
            }
            return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)lookingAxis);
        }
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)(preferredAxis != null && context.m_43723_().m_6144_() ? context.m_43719_().m_122434_() : context.m_7820_().m_122434_()));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        return this.tryEncase(state, level, pos, stack, player, hand, hitResult);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return CCShapes.CROSS_CONNECTOR.get((Direction.Axis)state.m_61143_(AXIS));
    }

    public void updateConnections(Level level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
            for (Direction direction : Iterate.directions) {
                Block block;
                if (direction.m_122434_() == axis) continue;
                BlockPos sourcePos = pos;
                BlockPos neighborPos = pos.m_121945_(direction);
                while (sourcePos != neighborPos && (block = level.m_8055_(neighborPos).m_60734_()) instanceof IConnectionForwardingBlock) {
                    IConnectionForwardingBlock forwardingBlock = (IConnectionForwardingBlock)block;
                    BlockPos tempSource = sourcePos;
                    sourcePos = neighborPos;
                    neighborPos = forwardingBlock.forwardConnection(level, tempSource, tempSource.equals((Object)pos) ? state : level.m_8055_(tempSource), neighborPos);
                }
                BlockEntity neighbourTE = level.m_7702_(neighborPos);
                if (!(neighbourTE instanceof KineticBlockEntity)) continue;
                KineticBlockEntity kineticTE = (KineticBlockEntity)neighbourTE;
                KineticHelper.updateKineticBlock(kineticTE);
            }
        }
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        super.m_6807_(state, level, pos, oldState, movedByPiston);
        this.updateConnections(level, pos, state);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        this.updateConnections(level, pos, state);
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    @Override
    public BlockPos forwardConnection(Level level, BlockPos sourcePos, BlockState sourceState, BlockPos neighbourPos) {
        BlockState state = level.m_8055_(neighbourPos);
        if (state.m_60734_() != this) {
            return neighbourPos;
        }
        BlockPos offset = neighbourPos.m_121996_((Vec3i)sourcePos);
        Block block = sourceState.m_60734_();
        if (!(block instanceof IRotate)) {
            return neighbourPos;
        }
        IRotate rotatingBlock = (IRotate)block;
        Direction offsetDirection = Direction.m_122378_((int)offset.m_123341_(), (int)offset.m_123342_(), (int)offset.m_123343_());
        if (offsetDirection == null) {
            return neighbourPos;
        }
        if (!rotatingBlock.hasShaftTowards((LevelReader)level, sourcePos, sourceState, offsetDirection)) {
            return neighbourPos;
        }
        if (offsetDirection.m_122434_() == state.m_61143_(AXIS)) {
            return neighbourPos;
        }
        return neighbourPos.m_121955_((Vec3i)offset);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() != state.m_61143_(AXIS);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_(AXIS);
    }
}

