/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.attributefilter;

import com.hlysine.create_connected.CCItemAttributes;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ItemDamageAttribute(int maxDamage) implements ItemAttribute
{
    public static final MapCodec<ItemDamageAttribute> CODEC = Codec.INT.xmap(ItemDamageAttribute::new, ItemDamageAttribute::maxDamage).fieldOf("value");
    public static final StreamCodec<ByteBuf, ItemDamageAttribute> STREAM_CODEC = ByteBufCodecs.INT.map(ItemDamageAttribute::new, ItemDamageAttribute::maxDamage);

    public boolean appliesTo(ItemStack stack, Level world) {
        return stack.getMaxDamage() == this.maxDamage;
    }

    public ItemAttributeType getType() {
        return CCItemAttributes.MAX_DAMAGE;
    }

    public String getTranslationKey() {
        return "max_damage";
    }

    public Object[] getTranslationParameters() {
        return new Object[]{String.valueOf(this.maxDamage)};
    }

    public static class Type
    implements ItemAttributeType {
        @NotNull
        public ItemAttribute createAttribute() {
            return new ItemDamageAttribute(0);
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
            attributes.add(new ItemDamageAttribute(stack.getMaxDamage()));
            return attributes;
        }

        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, ? extends ItemAttribute> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

