/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.copycat;

import java.util.function.Function;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public interface ICopycatWithWrappedBlock {
    public Block getWrappedBlock();

    public static Block unwrap(Block block) {
        if (block instanceof ICopycatWithWrappedBlock) {
            ICopycatWithWrappedBlock wrapper = (ICopycatWithWrappedBlock)block;
            return wrapper.getWrappedBlock();
        }
        return block;
    }

    public static BlockState unwrapForOperation(Block wrappedBlock, BlockState state, Function<BlockState, BlockState> operation) {
        BlockState wrappedState = ICopycatWithWrappedBlock.wrappedState(wrappedBlock, state);
        BlockState newState = operation.apply(wrappedState);
        return ICopycatWithWrappedBlock.wrappedState(state.getBlock(), newState);
    }

    public static BlockState wrappedState(Block wrappedBlock, BlockState state) {
        BlockState newState = wrappedBlock.defaultBlockState();
        for (Property property : newState.getProperties()) {
            newState = ICopycatWithWrappedBlock.tryCopyProperty(state, newState, property);
        }
        return newState;
    }

    public static BlockState copyState(BlockState source, BlockState destination, boolean includeWaterlogged) {
        BlockState newState = destination;
        for (Property property : source.getProperties()) {
            if (property == BlockStateProperties.WATERLOGGED && !includeWaterlogged) continue;
            newState = ICopycatWithWrappedBlock.tryCopyProperty(source, newState, property);
        }
        return newState;
    }

    public static <T extends Comparable<T>> BlockState tryCopyProperty(BlockState state, BlockState newState, Property<T> property) {
        if (state.hasProperty(property) && newState.hasProperty(property)) {
            newState = (BlockState)newState.setValue(property, state.getValue(property));
        }
        return newState;
    }
}

