/*
 * Decompiled with CFR 0.152.
 */
package io.github.xen0r_star.droneworks.entity;

import io.github.xen0r_star.droneworks.block.StationBlockEntity;
import io.github.xen0r_star.droneworks.client.renderer.DRONE_COLOR;
import io.github.xen0r_star.droneworks.entity.DroneMoveControl;
import io.github.xen0r_star.droneworks.entity.goal.DroneHarvestCropsGoal;
import io.github.xen0r_star.droneworks.entity.goal.DroneReturnToStationGoal;
import io.github.xen0r_star.droneworks.entity.goal.DroneTillAndPlantGoal;
import io.github.xen0r_star.droneworks.registry.ModItems;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class DroneEntity
extends class_1314 {
    private class_2338 linkedStationPos;
    private int particleCooldown = 0;
    private boolean forcedReturnToStation = false;
    private final class_1277 inventory = new class_1277(10);
    private boolean bodyVisible = true;
    public boolean antennaVisible = true;
    public boolean toolSocketVisible = true;
    public boolean eyeVisible = true;
    public boolean chargeSocketVisible = true;
    public boolean propeller1Visible = true;
    public boolean propeller2Visible = true;
    private static final class_2940<Integer> COLOR = class_2945.method_12791(DroneEntity.class, (class_2941)class_2943.field_13327);

    public DroneEntity(class_1299<? extends class_1314> type, class_1937 world) {
        super(type, world);
        this.field_6207 = new DroneMoveControl(this);
        this.method_5875(true);
        this.method_5971();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COLOR, (Object)0);
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23720, 0.2).method_26868(class_5134.field_23719, 0.15);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new DroneReturnToStationGoal(this, 0.15));
        this.field_6201.method_6277(2, (class_1352)new DroneHarvestCropsGoal(this, 10, 0.15));
        this.field_6201.method_6277(3, (class_1352)new DroneTillAndPlantGoal(this, 10, 0.15));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
    }

    protected class_1408 method_5965(class_1937 world) {
        return new class_1407((class_1308)this, world);
    }

    public void method_6007() {
        super.method_6007();
        this.method_5875(true);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            return;
        }
        --this.particleCooldown;
        if (this.particleCooldown > 0) {
            return;
        }
        this.particleCooldown = 10;
        float healthPercent = this.method_6032() / this.method_6063();
        if (healthPercent <= 0.5f && healthPercent > 0.25f) {
            ((class_3218)this.method_37908()).method_65096((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 2, 0.1, 0.1, 0.1, 0.01);
        } else if (healthPercent <= 0.25f) {
            ((class_3218)this.method_37908()).method_65096((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 6, 0.2, 0.2, 0.2, 0.02);
        }
    }

    public boolean areFirstSixSlotsFull() {
        for (int i = 0; i < 3 && i < this.inventory.method_5439(); ++i) {
            if (!this.inventory.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public void dumpInventoryToStation() {
        if (this.linkedStationPos == null || this.method_37908().field_9236) {
            return;
        }
        class_2586 be = this.method_37908().method_8321(this.linkedStationPos);
        if (!(be instanceof StationBlockEntity)) {
            return;
        }
        StationBlockEntity station = (StationBlockEntity)be;
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 stack = this.inventory.method_5438(i);
            if (stack.method_7960()) continue;
            class_1799 remaining = this.insertStackIntoStation(station, stack);
            if (remaining.method_7960()) {
                this.inventory.method_5447(i, class_1799.field_8037);
                continue;
            }
            this.inventory.method_5447(i, remaining);
        }
        station.method_5431();
    }

    private class_1799 insertStackIntoStation(StationBlockEntity station, class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 remaining = stack.method_7972();
        for (int slot = 0; slot < station.method_5439(); ++slot) {
            int canAdd;
            class_1799 existing = station.method_5438(slot);
            if (existing.method_7960()) {
                int toInsert = Math.min(remaining.method_7947(), remaining.method_7914());
                class_1799 insert = remaining.method_7972();
                insert.method_7939(toInsert);
                station.method_5447(slot, insert);
                remaining.method_7934(toInsert);
                if (!remaining.method_7960()) continue;
                return class_1799.field_8037;
            }
            if (!class_1799.method_31577((class_1799)existing, (class_1799)remaining) || !existing.method_7946() || (canAdd = Math.min(remaining.method_7947(), existing.method_7914() - existing.method_7947())) <= 0) continue;
            existing.method_7933(canAdd);
            remaining.method_7934(canAdd);
            station.method_5447(slot, existing);
            if (!remaining.method_7960()) continue;
            return class_1799.field_8037;
        }
        return remaining;
    }

    protected boolean method_27071() {
        return false;
    }

    public void method_6078(class_1282 source) {
        class_3218 serverWorld = (class_3218)this.method_37908();
        if (!serverWorld.field_9236) {
            class_2586 be;
            switch (this.getColor()) {
                case WHITE: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_WHITE_ITEM);
                    break;
                }
                case LIGHT_GRAY: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_LIGHT_GRAY_ITEM);
                    break;
                }
                case GRAY: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_GRAY_ITEM);
                    break;
                }
                case BLACK: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_BLACK_ITEM);
                    break;
                }
                case BROWN: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_BROWN_ITEM);
                    break;
                }
                case RED: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_RED_ITEM);
                    break;
                }
                case ORANGE: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_ORANGE_ITEM);
                    break;
                }
                case YELLOW: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_YELLOW_ITEM);
                    break;
                }
                case LIME: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_LIME_ITEM);
                    break;
                }
                case GREEN: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_GREEN_ITEM);
                    break;
                }
                case CYAN: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_CYAN_ITEM);
                    break;
                }
                case LIGHT_BLUE: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_LIGHT_BLUE_ITEM);
                    break;
                }
                case BLUE: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_BLUE_ITEM);
                    break;
                }
                case PURPLE: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_PURPLE_ITEM);
                    break;
                }
                case MAGENTA: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_MAGENTA_ITEM);
                    break;
                }
                case PINK: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_PINK_ITEM);
                    break;
                }
                default: {
                    this.method_5706(serverWorld, (class_1935)ModItems.DRONE_DEFAULT_ITEM);
                }
            }
            if (this.linkedStationPos != null && (be = serverWorld.method_8321(this.linkedStationPos)) instanceof StationBlockEntity) {
                StationBlockEntity station = (StationBlockEntity)be;
                station.clearLinkedDrone();
            }
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public void method_5647(class_11372 view) {
        super.method_5647(view);
        if (this.linkedStationPos != null) {
            view.method_71465("LinkedX", this.linkedStationPos.method_10263());
            view.method_71465("LinkedY", this.linkedStationPos.method_10264());
            view.method_71465("LinkedZ", this.linkedStationPos.method_10260());
        }
        view.method_71465("color", ((Integer)this.field_6011.method_12789(COLOR)).intValue());
    }

    public void method_5651(class_11368 view) {
        super.method_5651(view);
        if (view.contains("LinkedX")) {
            int x = view.method_71424("LinkedX", 0);
            int y = view.method_71424("LinkedY", 0);
            int z = view.method_71424("LinkedZ", 0);
            this.linkedStationPos = new class_2338(x, y, z);
        }
        this.field_6011.method_12778(COLOR, (Object)view.method_71424("color", 0));
    }

    public void setLinkedStationPos(class_2338 pos) {
        this.linkedStationPos = pos;
    }

    public class_2338 getLinkedStationPos() {
        return this.linkedStationPos;
    }

    public class_1277 getInventory() {
        return this.inventory;
    }

    public void setColor(DRONE_COLOR color) {
        this.field_6011.method_12778(COLOR, (Object)color.getValue());
    }

    public DRONE_COLOR getColor() {
        return DRONE_COLOR.fromValue((Integer)this.field_6011.method_12789(COLOR));
    }

    public void clearForcedReturnFlag() {
        this.forcedReturnToStation = false;
    }

    public boolean isForcedToReturn() {
        return this.forcedReturnToStation;
    }

    public boolean shouldShowBody() {
        return this.bodyVisible;
    }

    public void showBody(boolean b) {
        this.bodyVisible = b;
    }

    public boolean shouldShowAntenna() {
        return this.antennaVisible;
    }

    public void showAntenna(boolean b) {
        this.antennaVisible = b;
    }

    public boolean shouldShowToolSocket() {
        return this.toolSocketVisible;
    }

    public void showToolSocket(boolean b) {
        this.toolSocketVisible = b;
    }

    public boolean shouldShowEye() {
        return this.eyeVisible;
    }

    public void showEye(boolean b) {
        this.eyeVisible = b;
    }

    public boolean shouldShowChargeSocket() {
        return this.chargeSocketVisible;
    }

    public void showChargeSocket(boolean b) {
        this.chargeSocketVisible = b;
    }

    public boolean shouldShowPropeller1() {
        return this.propeller1Visible;
    }

    public void showPropeller1(boolean b) {
        this.propeller1Visible = b;
    }

    public boolean shouldShowPropeller2() {
        return this.propeller2Visible;
    }

    public void showPropeller2(boolean b) {
        this.propeller2Visible = b;
    }
}

