/*
 * Decompiled with CFR 0.152.
 */
package io.github.xen0r_star.droneworks.entity.goal;

import io.github.xen0r_star.droneworks.entity.DroneEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class DroneHarvestCropsGoal
extends class_1352 {
    private final DroneEntity drone;
    private final int searchRadius;
    private final double speed;
    private class_2338 targetCrop;
    private HarvestState state = HarvestState.MOVING;
    private int stateTicks = 0;

    public DroneHarvestCropsGoal(DroneEntity drone, int searchRadius, double speed) {
        this.drone = drone;
        this.searchRadius = searchRadius;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.drone.getLinkedStationPos() == null) {
            return false;
        }
        this.targetCrop = this.findNearestMatureCrop();
        return this.targetCrop != null;
    }

    public void method_6269() {
    }

    public void method_6270() {
        this.state = HarvestState.MOVING;
        this.stateTicks = 0;
        this.targetCrop = null;
        this.drone.method_5942().method_6340();
    }

    public boolean method_6266() {
        return this.targetCrop != null;
    }

    public void method_6268() {
        double targetZ;
        double targetY;
        if (this.targetCrop == null) {
            return;
        }
        double targetX = (double)this.targetCrop.method_10263() + 0.5;
        if (!this.isPathClear(targetX, targetY = (double)this.targetCrop.method_10264() + 1.5, targetZ = (double)this.targetCrop.method_10260() + 0.5)) {
            this.method_6270();
            return;
        }
        double dx = targetX - this.drone.method_23317();
        double dy = targetY - this.drone.method_23318();
        double dz = targetZ - this.drone.method_23321();
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        switch (this.state.ordinal()) {
            case 0: {
                if (dist <= 0.1) {
                    this.state = HarvestState.CHARGING;
                    this.stateTicks = 0;
                    this.drone.method_18799(class_243.field_1353);
                    return;
                }
                double vx = dx / dist * this.speed;
                double vy = dy / dist * this.speed;
                double vz = dz / dist * this.speed;
                this.drone.method_18800(this.drone.method_18798().field_1352 + (vx - this.drone.method_18798().field_1352) * 0.2, this.drone.method_18798().field_1351 + (vy - this.drone.method_18798().field_1351) * 0.2, this.drone.method_18798().field_1350 + (vz - this.drone.method_18798().field_1350) * 0.2);
                this.drone.field_6007 = true;
                break;
            }
            case 1: {
                class_2302 crop;
                ++this.stateTicks;
                if (this.stateTicks < 20) break;
                class_2680 stateBlock = this.drone.method_37908().method_8320(this.targetCrop);
                class_2248 vy = stateBlock.method_26204();
                if (vy instanceof class_2302 && (crop = (class_2302)vy).method_9825(stateBlock)) {
                    class_3218 serverWorld = (class_3218)this.drone.method_37908();
                    List drops = class_2248.method_9609((class_2680)stateBlock, (class_3218)serverWorld, (class_2338)this.targetCrop, (class_2586)serverWorld.method_8321(this.targetCrop), (class_1297)this.drone, (class_1799)class_1799.field_8037);
                    for (class_1799 stack : drops) {
                        this.drone.getInventory().method_5491(stack);
                    }
                    serverWorld.method_8652(this.targetCrop, crop.method_9828(0), 3);
                }
                this.state = HarvestState.ENDING;
                this.stateTicks = 0;
                break;
            }
            case 3: {
                ++this.stateTicks;
                if (this.stateTicks < 10) break;
                this.method_6270();
                break;
            }
        }
    }

    private boolean isPathClear(double targetX, double targetY, double targetZ) {
        class_243 start = this.drone.method_19538();
        class_243 end = new class_243(targetX, targetY, targetZ);
        class_3965 result = this.drone.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.drone));
        return result.method_17783() == class_239.class_240.field_1333;
    }

    private class_2338 findNearestMatureCrop() {
        class_2338 center = this.drone.getLinkedStationPos();
        class_2338 nearest = null;
        double bestDist = Double.MAX_VALUE;
        for (class_2338 pos : class_2338.method_10097((class_2338)center.method_10069(-this.searchRadius, -1, -this.searchRadius), (class_2338)center.method_10069(this.searchRadius, 1, this.searchRadius))) {
            double ds;
            class_2302 crop;
            class_2248 class_22482;
            class_2680 st = this.drone.method_37908().method_8320(pos);
            if (!st.method_26164(class_3481.field_20341) || !((class_22482 = st.method_26204()) instanceof class_2302) || !(crop = (class_2302)class_22482).method_9825(st) || !((ds = this.drone.method_5649((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5)) < bestDist)) continue;
            bestDist = ds;
            nearest = pos.method_10062();
        }
        return nearest;
    }

    private static enum HarvestState {
        MOVING,
        CHARGING,
        BREAKING,
        ENDING;

    }
}

