/*
 * Decompiled with CFR 0.152.
 */
package io.github.xen0r_star.droneworks.entity.goal;

import io.github.xen0r_star.droneworks.entity.DroneEntity;
import java.util.EnumSet;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public class DroneReturnToStationGoal
extends class_1352 {
    private final DroneEntity drone;
    private final double speed;
    private class_2338 station;
    private State state = State.IDLE;
    private int stateTicks = 0;

    public DroneReturnToStationGoal(DroneEntity drone, double speed) {
        this.drone = drone;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        this.station = this.drone.getLinkedStationPos();
        if (this.station == null) {
            return false;
        }
        if (this.drone.isForcedToReturn()) {
            return true;
        }
        return this.drone.areFirstSixSlotsFull();
    }

    public void method_6269() {
        if (this.station != null) {
            this.state = State.MOVING;
            this.stateTicks = 0;
        }
    }

    public void method_6270() {
        this.state = State.IDLE;
        this.drone.method_18799(class_243.field_1353);
        this.drone.field_6007 = true;
        this.drone.clearForcedReturnFlag();
    }

    public void method_6268() {
        if (this.station == null) {
            this.method_6270();
            return;
        }
        double targetX = (double)this.station.method_10263() + 0.5;
        double targetY = (double)this.station.method_10264() + 1.0;
        double targetZ = (double)this.station.method_10260() + 0.5;
        double dx = targetX - this.drone.method_23317();
        double dy = targetY - this.drone.method_23318();
        double dz = targetZ - this.drone.method_23321();
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        switch (this.state.ordinal()) {
            case 1: {
                if (dist <= 0.5) {
                    this.state = State.UNLOADING;
                    this.stateTicks = 0;
                    this.drone.method_18799(class_243.field_1353);
                    this.drone.field_6007 = true;
                    return;
                }
                double vx = dx / dist * this.speed;
                double vy = dy / dist * this.speed;
                double vz = dz / dist * this.speed;
                this.drone.method_18800(this.drone.method_18798().field_1352 + (vx - this.drone.method_18798().field_1352) * 0.2, this.drone.method_18798().field_1351 + (vy - this.drone.method_18798().field_1351) * 0.2, this.drone.method_18798().field_1350 + (vz - this.drone.method_18798().field_1350) * 0.2);
                this.drone.field_6007 = true;
                break;
            }
            case 2: {
                ++this.stateTicks;
                if (this.stateTicks == 5) {
                    this.drone.dumpInventoryToStation();
                }
                if (this.stateTicks < 10) break;
                this.method_6270();
                break;
            }
        }
    }

    public boolean method_6266() {
        return this.state != State.IDLE;
    }

    private static enum State {
        IDLE,
        MOVING,
        UNLOADING;

    }
}

