/*
 * Decompiled with CFR 0.152.
 */
package me.SB;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RegenOre
extends JavaPlugin
implements Listener {
    private final Set<Material> regeneratingOres = new HashSet<Material>();

    public void onEnable() {
        this.saveDefaultConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.loadSupportedOres();
        this.getLogger().info("\u2705 RegenOre plugin enabled!");
    }

    public void onDisable() {
        this.getLogger().info("\u274c RegenOre plugin disabled.");
    }

    private void loadSupportedOres() {
        Collections.addAll(this.regeneratingOres, Material.COAL_ORE, Material.IRON_ORE, Material.GOLD_ORE, Material.REDSTONE_ORE, Material.LAPIS_ORE, Material.DIAMOND_ORE, Material.EMERALD_ORE, Material.NETHER_QUARTZ_ORE, Material.NETHER_GOLD_ORE, Material.COPPER_ORE, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.DEEPSLATE_COPPER_ORE);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        final Block block = event.getBlock();
        final Material type = block.getType();
        Location loc = block.getLocation();
        if (!this.isInMiningArea(loc)) {
            return;
        }
        if (!this.regeneratingOres.contains(type)) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("\u274c You can only mine ores in this area!");
            return;
        }
        Player player = event.getPlayer();
        ItemStack tool = player.getInventory().getItemInMainHand();
        int fortuneLevel = 0;
        if (tool != null && tool.containsEnchantment(Enchantment.getByName((String)"LOOT_BONUS_BLOCKS"))) {
            fortuneLevel = tool.getEnchantmentLevel(Enchantment.getByName((String)"LOOT_BONUS_BLOCKS"));
        }
        event.setDropItems(false);
        List<ItemStack> drops = this.getOreDrop(type, fortuneLevel);
        for (ItemStack drop : drops) {
            block.getWorld().dropItemNaturally(loc, drop);
        }
        int xp = this.getXPDrop(type);
        if (xp > 0) {
            ((ExperienceOrb)block.getWorld().spawn(loc, ExperienceOrb.class)).setExperience(xp);
        }
        block.setType(Material.BEDROCK);
        long regenDelay = this.getConfig().getLong("regenDelay", 120L);
        new BukkitRunnable(this){
            final /* synthetic */ RegenOre this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                block.setType(type);
            }
        }.runTaskLater((Plugin)this, regenDelay);
    }

    private boolean isInMiningArea(Location loc) {
        FileConfiguration config = this.getConfig();
        int x1 = config.getInt("miningarea.x1");
        int y1 = config.getInt("miningarea.y1");
        int z1 = config.getInt("miningarea.z1");
        int x2 = config.getInt("miningarea.x2");
        int y2 = config.getInt("miningarea.y2");
        int z2 = config.getInt("miningarea.z2");
        int minX = Math.min(x1, x2);
        int maxX = Math.max(x1, x2);
        int minY = Math.min(y1, y2);
        int maxY = Math.max(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxZ = Math.max(z1, z2);
        return loc.getBlockX() >= minX && loc.getBlockX() <= maxX && loc.getBlockY() >= minY && loc.getBlockY() <= maxY && loc.getBlockZ() >= minZ && loc.getBlockZ() <= maxZ;
    }

    private List<ItemStack> getOreDrop(Material mat, int fortune) {
        Material dropMat;
        Random random = new Random();
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int baseAmount = 1;
        switch (mat) {
            case COAL_ORE: 
            case DEEPSLATE_COAL_ORE: {
                dropMat = Material.COAL;
                break;
            }
            case IRON_ORE: 
            case DEEPSLATE_IRON_ORE: {
                dropMat = Material.RAW_IRON;
                break;
            }
            case GOLD_ORE: 
            case DEEPSLATE_GOLD_ORE: {
                dropMat = Material.RAW_GOLD;
                break;
            }
            case COPPER_ORE: 
            case DEEPSLATE_COPPER_ORE: {
                dropMat = Material.RAW_COPPER;
                baseAmount = 2;
                break;
            }
            case REDSTONE_ORE: 
            case DEEPSLATE_REDSTONE_ORE: {
                dropMat = Material.REDSTONE;
                baseAmount = 4 + random.nextInt(2);
                break;
            }
            case LAPIS_ORE: 
            case DEEPSLATE_LAPIS_ORE: {
                dropMat = Material.LAPIS_LAZULI;
                baseAmount = 4 + random.nextInt(3);
                break;
            }
            case DIAMOND_ORE: 
            case DEEPSLATE_DIAMOND_ORE: {
                dropMat = Material.DIAMOND;
                break;
            }
            case EMERALD_ORE: 
            case DEEPSLATE_EMERALD_ORE: {
                dropMat = Material.EMERALD;
                break;
            }
            case NETHER_QUARTZ_ORE: {
                dropMat = Material.QUARTZ;
                baseAmount = 1 + random.nextInt(2);
                break;
            }
            case NETHER_GOLD_ORE: {
                dropMat = Material.GOLD_NUGGET;
                baseAmount = 2 + random.nextInt(5);
                break;
            }
            default: {
                return drops;
            }
        }
        int totalAmount = baseAmount;
        if (fortune > 0) {
            int bonus = random.nextInt(fortune + 2) - 1;
            if (bonus < 0) {
                bonus = 0;
            }
            totalAmount *= bonus + 1;
        }
        drops.add(new ItemStack(dropMat, totalAmount));
        return drops;
    }

    private int getXPDrop(Material mat) {
        switch (mat) {
            case COAL_ORE: 
            case DEEPSLATE_COAL_ORE: 
            case NETHER_QUARTZ_ORE: 
            case NETHER_GOLD_ORE: {
                return 2 + new Random().nextInt(3);
            }
            case DIAMOND_ORE: 
            case DEEPSLATE_DIAMOND_ORE: 
            case EMERALD_ORE: 
            case DEEPSLATE_EMERALD_ORE: {
                return 3 + new Random().nextInt(5);
            }
            case REDSTONE_ORE: 
            case DEEPSLATE_REDSTONE_ORE: 
            case LAPIS_ORE: 
            case DEEPSLATE_LAPIS_ORE: {
                return 2 + new Random().nextInt(4);
            }
        }
        return 0;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("setminingarea")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u274c Only players can run this command.");
                return true;
            }
            if (args.length != 6) {
                sender.sendMessage("\u274c Usage: /setminingarea <x1> <y1> <z1> <x2> <y2> <z2>");
                return true;
            }
            try {
                int x1 = Integer.parseInt(args[0]);
                int y1 = Integer.parseInt(args[1]);
                int z1 = Integer.parseInt(args[2]);
                int x2 = Integer.parseInt(args[3]);
                int y2 = Integer.parseInt(args[4]);
                int z2 = Integer.parseInt(args[5]);
                this.getConfig().set("miningarea.x1", (Object)x1);
                this.getConfig().set("miningarea.y1", (Object)y1);
                this.getConfig().set("miningarea.z1", (Object)z1);
                this.getConfig().set("miningarea.x2", (Object)x2);
                this.getConfig().set("miningarea.y2", (Object)y2);
                this.getConfig().set("miningarea.z2", (Object)z2);
                this.saveConfig();
                sender.sendMessage("\u2705 Mining area set successfully.");
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u274c Invalid coordinates.");
            }
            return true;
        }
        return false;
    }
}

