/*
 * Decompiled with CFR 0.152.
 */
package o7410.bundlesbeyond;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.util.StringRepresentable;
import o7410.bundlesbeyond.BundlesBeyond;

public enum ModEnabledState implements StringRepresentable
{
    ON("On, press key to toggle", "on", "On", () -> true),
    OFF("Off, press key to toggle", "off", "Off", () -> false),
    HOLD_KEY("Hold key to enable", "hold_key", "Hold key", () -> InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)BundlesBeyond.getKeyCode(BundlesBeyond.MOD_ENABLED_KEY)));

    public static final Codec<ModEnabledState> CODEC;
    public final String description;
    public final String id;
    public final String shortName;
    private final Supplier<Boolean> isEnabled;

    private ModEnabledState(String description, String id, String shortName, Supplier<Boolean> isEnabled) {
        this.id = id;
        this.description = description;
        this.shortName = shortName;
        this.isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.isEnabled.get();
    }

    public Component getDescriptionText() {
        return Component.literal((String)this.description);
    }

    public Component getShortNameText() {
        return Component.literal((String)this.shortName).withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText(this.getDescriptionText())));
    }

    public String getSerializedName() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    static {
        CODEC = StringRepresentable.fromEnum(ModEnabledState::values);
    }
}

