/*
 * Decompiled with CFR 0.152.
 */
package o7410.bundlesbeyond.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.BundleMouseActions;
import o7410.bundlesbeyond.BundleTooltipAdditions;
import o7410.bundlesbeyond.BundlesBeyond;
import o7410.bundlesbeyond.BundlesBeyondConfig;
import o7410.bundlesbeyond.ScrollMode;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={BundleMouseActions.class})
public abstract class BundleTooltipSubmenuHandlerMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @ModifyExpressionValue(method={"onMouseScrolled(DDILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/ScrollWheelHandler;getNextScrollWheelSelection(DII)I")})
    private int changeScrollBehavior(int original, @Local Vector2i scrollOffset, @Local(ordinal=1) int size, @Local(ordinal=2) int scrollAmount, @Local(ordinal=3) int selectedIndex) {
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();
        if (!BundlesBeyond.isModEnabled() || config.scrollMode == ScrollMode.VANILLA || size <= 4) {
            return original;
        }
        int width = BundleTooltipAdditions.getModifiedBundleTooltipColumns(size);
        int height = BundleTooltipAdditions.getModifiedBundleTooltipRows(size, width);
        boolean keyPressed = InputConstants.isKeyDown((Window)this.minecraft.getWindow(), (int)BundlesBeyond.getKeyCode(BundlesBeyond.SCROLL_AXIS_KEY));
        boolean isVertical = switch (config.scrollMode) {
            case ScrollMode.HOLD_FOR_VERTICAL -> keyPressed;
            case ScrollMode.HOLD_FOR_HORIZONTAL -> {
                if (!keyPressed) {
                    yield true;
                }
                yield false;
            }
            case ScrollMode.VERTICAL -> true;
            case ScrollMode.HORIZONTAL -> false;
            default -> throw new IllegalStateException();
        };
        if (isVertical) {
            return BundleTooltipAdditions.offsetVertical(size, width, height, selectedIndex, -scrollAmount);
        }
        if (scrollOffset.y == 0) {
            return BundleTooltipAdditions.offsetHorizontal(size, width, height, selectedIndex, -scrollAmount);
        }
        return original;
    }
}

