/*
 * Decompiled with CFR 0.152.
 */
package o7410.bundlesbeyond;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSelectBundleItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import o7410.bundlesbeyond.BundlesBeyondCommand;
import o7410.bundlesbeyond.BundlesBeyondConfig;
import o7410.bundlesbeyond.BundlesBeyondConfigScreen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="bundlesbeyond", dist={Dist.CLIENT})
@EventBusSubscriber(modid="bundlesbeyond", value={Dist.CLIENT})
public class BundlesBeyond {
    public static final String MOD_ID = "bundlesbeyond";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"bundlesbeyond");
    public static final String KEY_CATEGORY = Util.makeDescriptionId((String)"category", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bundlesbeyond", (String)"bundles_beyond"));
    public static final KeyMapping SCROLL_AXIS_KEY = new KeyMapping("key.bundlesbeyond.scroll_axis", InputConstants.UNKNOWN.getValue(), KEY_CATEGORY);
    public static final KeyMapping MOD_ENABLED_KEY = new KeyMapping("key.bundlesbeyond.mod_enabled", InputConstants.UNKNOWN.getValue(), KEY_CATEGORY);

    public static boolean isModEnabled() {
        return BundlesBeyondConfig.instance().modEnabledState.isEnabled();
    }

    public BundlesBeyond(ModContainer container) {
        BundlesBeyondConfig.load();
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(modContainer, modListScreen) -> new BundlesBeyondConfigScreen(modListScreen)));
    }

    private static void registerKeybinds(Consumer<KeyMapping> register) {
        register.accept(SCROLL_AXIS_KEY);
        register.accept(MOD_ENABLED_KEY);
    }

    @SubscribeEvent
    private static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        BundlesBeyond.registerKeybinds(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    @SubscribeEvent
    private static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        BundlesBeyondCommand.registerCommand(event.getDispatcher(), event.getBuildContext());
    }

    public static int getKeyCode(KeyMapping keyBinding) {
        return keyBinding.getKey().getValue();
    }

    public static void sendBundleSelectedPacket(int slotId, int selectedIndex) {
        ClientPacketListener clientPlayNetworkHandler = Minecraft.getInstance().getConnection();
        if (clientPlayNetworkHandler == null) {
            return;
        }
        ServerboundSelectBundleItemPacket packet = new ServerboundSelectBundleItemPacket(slotId, selectedIndex);
        clientPlayNetworkHandler.send((Packet)packet);
    }
}

