/*
 * Decompiled with CFR 0.152.
 */
package o7410.bundlesbeyond;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.StringRepresentableArgument;
import net.minecraft.network.chat.Component;
import o7410.bundlesbeyond.BundlesBeyondConfig;
import o7410.bundlesbeyond.BundlesBeyondConfigScreen;
import o7410.bundlesbeyond.ModEnabledState;
import o7410.bundlesbeyond.ScrollMode;

public class BundlesBeyondCommand {
    public static <T extends SharedSuggestionProvider> void registerCommand(CommandDispatcher<T> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"bundlesbeyond").executes(BundlesBeyondCommand::configScreen)).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"mod_enabled_state").executes(BundlesBeyondCommand::executeGetModEnabledState)).then(RequiredArgumentBuilder.argument((String)"state", (ArgumentType)new StringRepresentableArgument<ModEnabledState>(ModEnabledState.CODEC, ModEnabledState::values){}).suggests(BundlesBeyondCommand::getModEnabledStateSuggestions).executes(BundlesBeyondCommand::executeSetModEnabledState)))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"scroll_mode").executes(BundlesBeyondCommand::executeGetScrollMode)).then(RequiredArgumentBuilder.argument((String)"mode", (ArgumentType)new StringRepresentableArgument<ScrollMode>(ScrollMode.CODEC, ScrollMode::values){}).suggests(BundlesBeyondCommand::getScrollModeSuggestions).executes(BundlesBeyondCommand::executeSetScrollMode)))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"slot_size").executes(BundlesBeyondCommand::executeGetSlotSize)).then(RequiredArgumentBuilder.argument((String)"size", (ArgumentType)IntegerArgumentType.integer((int)18)).suggests(BundlesBeyondCommand::getSlotSizeSuggestions).executes(BundlesBeyondCommand::executeSetSlotSize)))).then(LiteralArgumentBuilder.literal((String)"reloadconfig").executes(BundlesBeyondCommand::executeReloadConfig)));
    }

    private static void sendFeedback(CommandContext<? extends SharedSuggestionProvider> context, Component text) {
        SharedSuggestionProvider source = (SharedSuggestionProvider)context.getSource();
        if (source instanceof CommandSourceStack) {
            CommandSourceStack serverSource = (CommandSourceStack)source;
            serverSource.sendSuccess(() -> text, false);
        }
    }

    private static void sendError(CommandContext<? extends SharedSuggestionProvider> context, Component text) {
        SharedSuggestionProvider source = (SharedSuggestionProvider)context.getSource();
        if (source instanceof CommandSourceStack) {
            CommandSourceStack serverSource = (CommandSourceStack)source;
            serverSource.sendFailure(text);
        }
    }

    private static int configScreen(CommandContext<? extends SharedSuggestionProvider> context) {
        Minecraft client = Minecraft.getInstance();
        client.setLastInputType(InputType.NONE);
        client.setScreen((Screen)new BundlesBeyondConfigScreen(null));
        return 0;
    }

    private static int executeGetModEnabledState(CommandContext<? extends SharedSuggestionProvider> context) {
        ModEnabledState state = BundlesBeyondConfig.instance().modEnabledState;
        BundlesBeyondCommand.sendFeedback(context, (Component)Component.literal((String)"Bundles Beyond enabled state is currently: ").append(state.getShortNameText()));
        return 0;
    }

    private static CompletableFuture<Suggestions> getModEnabledStateSuggestions(CommandContext<? extends SharedSuggestionProvider> context, SuggestionsBuilder builder) {
        for (ModEnabledState state : ModEnabledState.values()) {
            builder.suggest(state.id, (Message)state.getDescriptionText());
        }
        return builder.buildFuture();
    }

    private static int executeSetModEnabledState(CommandContext<? extends SharedSuggestionProvider> context) {
        ModEnabledState newModEnabledState = (ModEnabledState)((Object)context.getArgument("state", ModEnabledState.class));
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();
        BundlesBeyondCommand.sendFeedback(context, (Component)Component.literal((String)"Bundles Beyond enabled state is now: ").append(newModEnabledState.getShortNameText()));
        if (config.modEnabledState != newModEnabledState) {
            config.modEnabledState = newModEnabledState;
            if (!BundlesBeyondConfig.save()) {
                BundlesBeyondCommand.sendError(context, (Component)Component.literal((String)"Failed to save Bundles Beyond config"));
            }
        }
        return 0;
    }

    private static int executeGetScrollMode(CommandContext<? extends SharedSuggestionProvider> context) {
        BundlesBeyondCommand.sendFeedback(context, (Component)Component.literal((String)"Scroll mode is currently: ").append(BundlesBeyondConfig.instance().scrollMode.getShortNameText()));
        return 0;
    }

    private static CompletableFuture<Suggestions> getScrollModeSuggestions(CommandContext<? extends SharedSuggestionProvider> context, SuggestionsBuilder builder) {
        for (ScrollMode scrollMode : ScrollMode.values()) {
            builder.suggest(scrollMode.id, (Message)scrollMode.getDescriptionText());
        }
        return builder.buildFuture();
    }

    private static int executeSetScrollMode(CommandContext<? extends SharedSuggestionProvider> context) {
        ScrollMode newMode = (ScrollMode)((Object)context.getArgument("mode", ScrollMode.class));
        BundlesBeyondCommand.sendFeedback(context, (Component)Component.literal((String)"Scroll mode is now: ").append(newMode.getShortNameText()));
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();
        if (config.scrollMode != newMode) {
            config.scrollMode = newMode;
            if (!BundlesBeyondConfig.save()) {
                BundlesBeyondCommand.sendError(context, (Component)Component.literal((String)"Failed to save Bundles Beyond config"));
            }
        }
        return 0;
    }

    private static int executeGetSlotSize(CommandContext<? extends SharedSuggestionProvider> context) {
        int slotSize;
        BundlesBeyondCommand.sendFeedback(context, (Component)Component.literal((String)("Slot size is currently: " + slotSize + ((slotSize = BundlesBeyondConfig.instance().slotSize) == 24 ? " (Vanilla)" : ""))));
        return 0;
    }

    private static CompletableFuture<Suggestions> getSlotSizeSuggestions(CommandContext<? extends SharedSuggestionProvider> context, SuggestionsBuilder builder) {
        builder.suggest(24);
        return builder.buildFuture();
    }

    private static int executeSetSlotSize(CommandContext<? extends SharedSuggestionProvider> context) {
        int slotSize;
        BundlesBeyondCommand.sendFeedback(context, (Component)Component.literal((String)("Slot size is now: " + slotSize + ((slotSize = IntegerArgumentType.getInteger(context, (String)"size")) == 24 ? " (Vanilla)" : ""))));
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();
        if (config.slotSize != slotSize) {
            config.slotSize = slotSize;
            if (!BundlesBeyondConfig.save()) {
                BundlesBeyondCommand.sendError(context, (Component)Component.literal((String)"Failed to save Bundles Beyond config"));
            }
        }
        return 0;
    }

    private static int executeReloadConfig(CommandContext<? extends SharedSuggestionProvider> context) {
        if (BundlesBeyondConfig.load()) {
            BundlesBeyondCommand.sendFeedback(context, (Component)Component.literal((String)"Reloaded Bundles Beyond config"));
        } else {
            BundlesBeyondCommand.sendError(context, (Component)Component.literal((String)"Failed to reload Bundles Beyond config"));
        }
        return 0;
    }
}

