/*
 * Decompiled with CFR 0.152.
 */
package o7410.bundlesbeyond;

import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import o7410.bundlesbeyond.BundlesBeyond;
import o7410.bundlesbeyond.BundlesBeyondConfig;
import o7410.bundlesbeyond.ModEnabledState;
import o7410.bundlesbeyond.ScrollMode;
import o7410.bundlesbeyond.mixin.AbstractContainerScreenAccessor;

public class BundleTooltipAdditions {
    public static boolean handleKeybindsInBundleGui(Slot slot, int keyCode) {
        ItemStack stack = slot.getItem();
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null) {
            return false;
        }
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();
        if (config.modEnabledState != ModEnabledState.HOLD_KEY && keyCode == BundlesBeyond.getKeyCode(BundlesBeyond.MOD_ENABLED_KEY)) {
            config.modEnabledState = config.modEnabledState == ModEnabledState.ON ? ModEnabledState.OFF : ModEnabledState.ON;
            BundlesBeyondConfig.save();
            player.displayClientMessage((Component)Component.literal((String)("Bundles Beyond " + (config.modEnabledState == ModEnabledState.ON ? "enabled" : "disabled"))), true);
            int selectedIndex = BundleItem.getSelectedItem((ItemStack)stack);
            if (config.modEnabledState == ModEnabledState.ON) {
                return true;
            }
            int shownStacksWhenDisabled = BundleItem.getNumberOfItemsToShow((ItemStack)stack);
            if (selectedIndex >= shownStacksWhenDisabled) {
                selectedIndex = -1;
                BundleItem.toggleSelectedItem((ItemStack)stack, (int)selectedIndex);
                BundlesBeyond.sendBundleSelectedPacket(slot.index, selectedIndex);
            }
            return true;
        }
        if (!BundlesBeyond.isModEnabled()) {
            return false;
        }
        if ((config.scrollMode == ScrollMode.HORIZONTAL || config.scrollMode == ScrollMode.VERTICAL) && keyCode == BundlesBeyond.getKeyCode(BundlesBeyond.SCROLL_AXIS_KEY)) {
            config.scrollMode = config.scrollMode == ScrollMode.HORIZONTAL ? ScrollMode.VERTICAL : ScrollMode.HORIZONTAL;
            BundlesBeyondConfig.save();
            player.displayClientMessage((Component)Component.literal((String)("Now scrolling " + (config.scrollMode == ScrollMode.HORIZONTAL ? "horizontally" : "vertically"))), true);
            return true;
        }
        if (keyCode == 32) {
            Screen shownStacksWhenDisabled = client.screen;
            if (shownStacksWhenDisabled instanceof AbstractContainerScreen) {
                AbstractContainerScreen handledScreen = (AbstractContainerScreen)shownStacksWhenDisabled;
                AbstractContainerMenu currentScreenHandler = player.containerMenu;
                int button = currentScreenHandler.getCarried().isEmpty() ? 1 : 0;
                ((AbstractContainerScreenAccessor)handledScreen).callSlotClicked(slot, slot.index, button, ClickType.PICKUP);
            }
            return true;
        }
        switch (keyCode) {
            case 61: 
            case 334: {
                if (config.slotSize >= 24) break;
                String message = "Slot size is now: " + ++config.slotSize + (config.slotSize == 24 ? " (Vanilla)" : "");
                player.displayClientMessage((Component)Component.literal((String)message), true);
                BundlesBeyondConfig.save();
                break;
            }
            case 45: 
            case 333: {
                if (config.slotSize <= 18) break;
                String message = "Slot size is now: " + --config.slotSize + (config.slotSize == 24 ? " (Vanilla)" : "");
                player.displayClientMessage((Component)Component.literal((String)message), true);
                BundlesBeyondConfig.save();
            }
        }
        int selectedIndex = BundleItem.getSelectedItem((ItemStack)stack);
        int size = BundleItem.getNumberOfItemsToShow((ItemStack)stack);
        if (size == 0) {
            return false;
        }
        int width = BundleTooltipAdditions.getModifiedBundleTooltipColumns(size);
        int height = BundleTooltipAdditions.getModifiedBundleTooltipRows(size, width);
        Options gameOptions = client.options;
        int forwardCode = BundlesBeyond.getKeyCode(gameOptions.keyUp);
        int leftCode = BundlesBeyond.getKeyCode(gameOptions.keyLeft);
        int backCode = BundlesBeyond.getKeyCode(gameOptions.keyDown);
        int rightCode = BundlesBeyond.getKeyCode(gameOptions.keyRight);
        if (keyCode == forwardCode || keyCode == 265) {
            selectedIndex = BundleTooltipAdditions.offsetVertical(size, width, height, selectedIndex, -1);
        } else if (keyCode == leftCode || keyCode == 263) {
            selectedIndex = BundleTooltipAdditions.offsetHorizontal(size, width, height, selectedIndex, -1);
        } else if (keyCode == backCode || keyCode == 264) {
            selectedIndex = BundleTooltipAdditions.offsetVertical(size, width, height, selectedIndex, 1);
        } else if (keyCode == rightCode || keyCode == 262) {
            selectedIndex = BundleTooltipAdditions.offsetHorizontal(size, width, height, selectedIndex, 1);
        } else {
            return false;
        }
        if (selectedIndex == -1) {
            return false;
        }
        BundleItem.toggleSelectedItem((ItemStack)stack, (int)selectedIndex);
        BundlesBeyond.sendBundleSelectedPacket(slot.index, selectedIndex);
        return true;
    }

    public static int offsetVertical(int size, int width, int height, int selectedIndex, int offset) {
        if (height == 1) {
            return selectedIndex == -1 ? 0 : -1;
        }
        if (selectedIndex == -1) {
            selectedIndex = 0;
        }
        int emptySlotsAtTheStart = width * height - size;
        int gridIndex = selectedIndex + emptySlotsAtTheStart;
        int gridX = gridIndex % width;
        int gridY = gridIndex / width;
        if ((gridY += offset) < 0) {
            gridY += height;
        }
        if (gridY >= height) {
            gridY -= height;
        }
        if (gridY == 0 && gridX < emptySlotsAtTheStart) {
            if (height == 2) {
                return -1;
            }
            if ((gridY += offset) < 0) {
                gridY += height;
            }
        }
        gridIndex = gridY * width + gridX;
        selectedIndex = gridIndex - emptySlotsAtTheStart;
        return selectedIndex;
    }

    public static int offsetHorizontal(int size, int width, int height, int selectedIndex, int offset) {
        int indexInRow;
        int thisRowWidth;
        if (size == 1) {
            return selectedIndex == 0 ? -1 : 0;
        }
        int emptySlotsAtTheStart = width * height - size;
        int gridIndex = selectedIndex + emptySlotsAtTheStart;
        int gridX = gridIndex % width;
        boolean isFirstRow = selectedIndex < width - emptySlotsAtTheStart;
        int n = thisRowWidth = isFirstRow ? width - emptySlotsAtTheStart : width;
        if (thisRowWidth == 1) {
            return selectedIndex == 0 ? -1 : 0;
        }
        int n2 = indexInRow = isFirstRow ? selectedIndex : gridX;
        if ((indexInRow += offset) < 0) {
            indexInRow = thisRowWidth - 1;
        }
        if (indexInRow >= thisRowWidth) {
            indexInRow = 0;
        }
        gridX = isFirstRow ? indexInRow + emptySlotsAtTheStart : indexInRow;
        gridIndex = gridIndex / width * width + gridX;
        selectedIndex = gridIndex - emptySlotsAtTheStart;
        return selectedIndex;
    }

    public static int getModifiedBundleTooltipColumns(int size) {
        return Math.max(4, Mth.ceil((double)Math.sqrt(size)));
    }

    public static int getModifiedBundleTooltipColumnsPixels(int size) {
        return BundleTooltipAdditions.getModifiedBundleTooltipColumns(size) * BundlesBeyondConfig.instance().slotSize;
    }

    public static int getModifiedBundleTooltipRows(int size, int columns) {
        return Mth.positiveCeilDiv((int)size, (int)columns);
    }
}

