/*
 * Decompiled with CFR 0.152.
 */
package o7410.bundlesbeyond;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import o7410.bundlesbeyond.BundlesBeyondConfig;
import o7410.bundlesbeyond.ModEnabledState;
import o7410.bundlesbeyond.ScrollMode;
import o7410.bundlesbeyond.mixin.SliderWidgetAccessor;
import org.jetbrains.annotations.Nullable;

public class BundlesBeyondConfigScreen
extends Screen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"bundlesbeyond", (String)"textures/gui/config.png");
    private static final int BACKGROUND_WIDTH = 222;
    private static final int BACKGROUND_HEIGHT = 148;
    private static final Component FAILED_TO_RELOAD_TEXT = Component.literal((String)"Failed to reload").withStyle(ChatFormatting.RED);
    private static final Component FAILED_TO_SAVE_TEXT = Component.literal((String)"Failed to save").withStyle(ChatFormatting.RED);
    @Nullable
    private final Screen parentScreen;
    private ModEnabledStateButton[] modEnabledStateButtons;
    private ScrollModeButton[] scrollModeButtons;
    private StringWidget failedToReload;
    private StringWidget failedToSave;

    public BundlesBeyondConfigScreen(@Nullable Screen parentScreen) {
        super((Component)Component.literal((String)"Bundles Beyond config"));
        this.parentScreen = parentScreen;
    }

    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderBackground(context, mouseX, mouseY, delta);
        context.blit(RenderType::guiTextured, TEXTURE, (this.width - 222) / 2, (this.height - 148) / 2, 0.0f, 0.0f, 222, 148, 256, 256);
        context.drawString(this.font, "Mod Enabled State", (this.width - 222) / 2 + 9, (this.height + 148) / 2 - 40, -1);
        context.drawCenteredString(this.font, "Scroll Mode", this.width / 2, (this.height - 148) / 2 + 5, -1);
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Reload"), this::reloadConfig).bounds((this.width + 222) / 2 - 49, (this.height + 148) / 2 - 30, 40, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Reload config"))).build());
        this.addModEnabledStateButtons();
        this.addScrollModeButtons();
        this.addFailedTextWidgets();
        this.addRenderableWidget((GuiEventListener)new SlotSizeSlider((this.width - 222) / 2 + 9, (this.height - 148) / 2 + 85, 204, 20, BundlesBeyondConfig.instance().slotSize));
        this.updateButtons();
    }

    private void addFailedTextWidgets() {
        this.failedToReload = new StringWidget((this.width + 222) / 2 - this.font.width((FormattedText)FAILED_TO_RELOAD_TEXT) - 10, (this.height + 148) / 2 - 40, this.font.width((FormattedText)FAILED_TO_RELOAD_TEXT), 9, FAILED_TO_RELOAD_TEXT, this.font);
        this.failedToReload.setTooltip(Tooltip.create((Component)Component.literal((String)"See log for details")));
        this.failedToReload.visible = false;
        this.addRenderableWidget((GuiEventListener)this.failedToReload);
        this.failedToSave = new StringWidget((this.width + 222) / 2 - this.font.width((FormattedText)FAILED_TO_SAVE_TEXT) - 10, (this.height + 148) / 2 - 40, this.font.width((FormattedText)FAILED_TO_SAVE_TEXT), 9, FAILED_TO_SAVE_TEXT, this.font);
        this.failedToSave.setTooltip(Tooltip.create((Component)Component.literal((String)"See log for details")));
        this.failedToSave.visible = false;
        this.addRenderableWidget((GuiEventListener)this.failedToSave);
    }

    private void addScrollModeButtons() {
        int topY = (this.height - 148) / 2;
        int centerX = this.width / 2;
        ScrollModeButton scrollModeVanillaButton = (ScrollModeButton)this.addRenderableWidget((GuiEventListener)new ScrollModeButton(this, ScrollMode.VANILLA, centerX - 100 - 2, topY + 15, 204, 20));
        ScrollModeButton scrollModeHorizontalButton = (ScrollModeButton)this.addRenderableWidget((GuiEventListener)new ScrollModeButton(this, ScrollMode.HORIZONTAL, centerX - 100 - 2, topY + 38, 100, 20));
        ScrollModeButton scrollModeVerticalButton = (ScrollModeButton)this.addRenderableWidget((GuiEventListener)new ScrollModeButton(this, ScrollMode.VERTICAL, centerX + 2, topY + 38, 100, 20));
        ScrollModeButton scrollModeHoldForHorizontalButton = (ScrollModeButton)this.addRenderableWidget((GuiEventListener)new ScrollModeButton(this, ScrollMode.HOLD_FOR_HORIZONTAL, centerX + 2, topY + 61, 100, 20));
        ScrollModeButton scrollModeHoldForVerticalButton = (ScrollModeButton)this.addRenderableWidget((GuiEventListener)new ScrollModeButton(this, ScrollMode.HOLD_FOR_VERTICAL, centerX - 100 - 2, topY + 61, 100, 20));
        this.scrollModeButtons = new ScrollModeButton[]{scrollModeVanillaButton, scrollModeHorizontalButton, scrollModeVerticalButton, scrollModeHoldForHorizontalButton, scrollModeHoldForVerticalButton};
    }

    private void addModEnabledStateButtons() {
        int bottomY = (this.height + 148) / 2;
        int leftX = (this.width - 222) / 2;
        ModEnabledStateButton modEnabledStateOnButton = (ModEnabledStateButton)this.addRenderableWidget((GuiEventListener)new ModEnabledStateButton(this, ModEnabledState.ON, leftX + 9, bottomY - 30, 34, 20));
        ModEnabledStateButton modEnabledStateOffButton = (ModEnabledStateButton)this.addRenderableWidget((GuiEventListener)new ModEnabledStateButton(this, ModEnabledState.OFF, leftX + 46, bottomY - 30, 34, 20));
        ModEnabledStateButton modEnabledStateHoldKeyButton = (ModEnabledStateButton)this.addRenderableWidget((GuiEventListener)new ModEnabledStateButton(this, ModEnabledState.HOLD_KEY, leftX + 83, bottomY - 30, 71, 20));
        this.modEnabledStateButtons = new ModEnabledStateButton[]{modEnabledStateOnButton, modEnabledStateOffButton, modEnabledStateHoldKeyButton};
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }

    private void reloadConfig(Button button) {
        boolean bl = this.failedToReload.visible = !BundlesBeyondConfig.load();
        if (this.failedToReload.visible) {
            this.failedToSave.visible = false;
        }
        this.updateButtons();
    }

    private void save() {
        boolean bl = this.failedToSave.visible = !BundlesBeyondConfig.save();
        if (this.failedToSave.visible) {
            this.failedToReload.visible = false;
        }
    }

    private void updateButtons() {
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();
        for (ModEnabledStateButton modEnabledStateButton : this.modEnabledStateButtons) {
            modEnabledStateButton.active = config.modEnabledState != modEnabledStateButton.modEnabledState;
        }
        for (Button button : this.scrollModeButtons) {
            button.active = config.scrollMode != button.scrollMode;
        }
    }

    private class SlotSizeSlider
    extends AbstractSliderButton {
        private static final int MIN_VALUE = 18;
        private static final int MAX_VALUE = 24;

        public SlotSizeSlider(int x, int y, int width, int height, int slotSize) {
            super(x, y, width, height, null, SlotSizeSlider.calculateValue(slotSize));
            this.updateMessage();
        }

        private int calculateSlotSize() {
            return (int)Math.round(this.value * 6.0 + 18.0);
        }

        private static double calculateValue(int slotSize) {
            return (double)(slotSize - 18) / 6.0;
        }

        protected void updateMessage() {
            int slotSize;
            this.setMessage((Component)Component.literal((String)("Bundle Slot Size: " + slotSize + ((slotSize = this.calculateSlotSize()) == 24 ? " (Vanilla)" : ""))));
        }

        protected void applyValue() {
            int slotSize = this.calculateSlotSize();
            BundlesBeyondConfig config = BundlesBeyondConfig.instance();
            if (config.slotSize != slotSize) {
                config.slotSize = slotSize;
                BundlesBeyondConfigScreen.this.save();
            }
            this.value = SlotSizeSlider.calculateValue(slotSize);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            SliderWidgetAccessor self = (SliderWidgetAccessor)((Object)this);
            if (CommonInputs.selected((int)keyCode)) {
                self.setSliderFocused(!self.getSliderFocused());
                return true;
            }
            if (self.getSliderFocused()) {
                boolean pressedLeft;
                boolean bl = pressedLeft = keyCode == 263;
                if (pressedLeft || keyCode == 262) {
                    int offset = pressedLeft ? -1 : 1;
                    this.value = SlotSizeSlider.calculateValue(Mth.clamp((int)(this.calculateSlotSize() + offset), (int)18, (int)24));
                    this.applyValue();
                    this.updateMessage();
                    return true;
                }
            }
            return false;
        }
    }

    private class ScrollModeButton
    extends Button {
        public final ScrollMode scrollMode;

        public ScrollModeButton(BundlesBeyondConfigScreen bundlesBeyondConfigScreen, ScrollMode scrollMode, int x, int y, int width, int height) {
            super(x, y, width, height, scrollMode.getShortNameText(), button -> {
                BundlesBeyondConfig.instance().scrollMode = scrollMode;
                bundlesBeyondConfigScreen.save();
                bundlesBeyondConfigScreen.updateButtons();
            }, DEFAULT_NARRATION);
            this.setTooltip(Tooltip.create((Component)scrollMode.getDescriptionText()));
            this.scrollMode = scrollMode;
        }
    }

    private class ModEnabledStateButton
    extends Button {
        public final ModEnabledState modEnabledState;

        public ModEnabledStateButton(BundlesBeyondConfigScreen bundlesBeyondConfigScreen, ModEnabledState modEnabledState, int x, int y, int width, int height) {
            super(x, y, width, height, modEnabledState.getShortNameText(), button -> {
                BundlesBeyondConfig.instance().modEnabledState = modEnabledState;
                bundlesBeyondConfigScreen.save();
                bundlesBeyondConfigScreen.updateButtons();
            }, DEFAULT_NARRATION);
            this.setTooltip(Tooltip.create((Component)modEnabledState.getDescriptionText()));
            this.modEnabledState = modEnabledState;
        }
    }
}

