/*
 * Decompiled with CFR 0.152.
 */
package o7410.bundlesbeyond;

import com.mojang.serialization.Codec;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.util.StringRepresentable;

public enum ScrollMode implements StringRepresentable
{
    HOLD_FOR_VERTICAL("Hold key to scroll vertically", "hold_for_vertical", "Hold for vertical"),
    HOLD_FOR_HORIZONTAL("Hold key to scroll horizontally", "hold_for_horizontal", "Hold for horizontal"),
    HORIZONTAL("Horizontal, press key for vertical", "horizontal", "Horizontal"),
    VERTICAL("Vertical, press key for horizontal", "vertical", "Vertical"),
    VANILLA("Vanilla scrolling", "vanilla", "Vanilla");

    public static final Codec<ScrollMode> CODEC;
    public final String description;
    public final String id;
    public final String shortName;

    private ScrollMode(String description, String id, String shortName) {
        this.id = id;
        this.description = description;
        this.shortName = shortName;
    }

    public Component getDescriptionText() {
        return Component.literal((String)this.description);
    }

    public Component getShortNameText() {
        return Component.literal((String)this.shortName).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)this.getDescriptionText())));
    }

    public String getSerializedName() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    static {
        CODEC = StringRepresentable.fromEnum(ScrollMode::values);
    }
}

