/*
 * Decompiled with CFR 0.152.
 */
package o7410.bundlesbeyond.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientBundleTooltip;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.BundleContents;
import o7410.bundlesbeyond.BundleTooltipAdditions;
import o7410.bundlesbeyond.BundlesBeyond;
import o7410.bundlesbeyond.BundlesBeyondConfig;
import org.apache.commons.lang3.math.Fraction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientBundleTooltip.class})
public abstract class BundleTooltipComponentMixin {
    @Shadow
    @Final
    private BundleContents contents;

    @Inject(method={"slotCount()I"}, at={@At(value="HEAD")}, cancellable=true)
    private void changeNumberOfVisibleSlots(CallbackInfoReturnable<Integer> cir) {
        if (!BundlesBeyond.isModEnabled()) {
            return;
        }
        cir.setReturnValue((Object)this.contents.size());
    }

    @ModifyVariable(method={"renderBundleWithItemsTooltip(Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/client/gui/GuiGraphics;)V"}, at=@At(value="STORE"))
    private boolean changeIfToDrawExtraItemsCount(boolean original) {
        if (!BundlesBeyond.isModEnabled()) {
            return original;
        }
        return false;
    }

    @ModifyConstant(method={"renderBundleWithItemsTooltip(Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/client/gui/GuiGraphics;)V"}, constant={@Constant(intValue=4)}, slice={@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/tooltip/ClientBundleTooltip;drawSelectedItemTooltip(Lnet/minecraft/client/gui/Font;Lnet/minecraft/client/gui/GuiGraphics;III)V"))})
    private int modifyDrawnColumnsCount(int constant) {
        if (!BundlesBeyond.isModEnabled()) {
            return constant;
        }
        return BundleTooltipAdditions.getModifiedBundleTooltipColumns(this.contents.size());
    }

    @ModifyConstant(method={"renderBundleWithItemsTooltip(Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/client/gui/GuiGraphics;)V"}, constant={@Constant(intValue=96)})
    private int modifyRightAlignmentForItems(int constant) {
        if (!BundlesBeyond.isModEnabled()) {
            return constant;
        }
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.contents.size());
    }

    @ModifyConstant(method={"renderBundleWithItemsTooltip(Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/client/gui/GuiGraphics;)V"}, constant={@Constant(intValue=24)})
    private int modifySlotSize(int constant) {
        if (!BundlesBeyond.isModEnabled()) {
            return constant;
        }
        return BundlesBeyondConfig.instance().slotSize;
    }

    @ModifyConstant(method={"getContentXOffset(I)I"}, constant={@Constant(intValue=96)})
    private int modfiyXMargin(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.contents.isEmpty()) {
            return constant;
        }
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.contents.size());
    }

    @ModifyConstant(method={"getWidth(Lnet/minecraft/client/gui/Font;)I"}, constant={@Constant(intValue=96)})
    private int changeTooltipWidth(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.contents.isEmpty()) {
            return constant;
        }
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.contents.size());
    }

    @ModifyConstant(method={"getProgressBarFill()I"}, constant={@Constant(intValue=94)})
    private int changeProgressBarFill(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.contents.isEmpty()) {
            return constant;
        }
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.contents.size()) - 2;
    }

    @ModifyConstant(method={"gridSizeY()I"}, constant={@Constant(intValue=4)})
    private int modifyItemsPerRow(int constant) {
        if (!BundlesBeyond.isModEnabled()) {
            return constant;
        }
        return BundleTooltipAdditions.getModifiedBundleTooltipColumns(this.contents.size());
    }

    @ModifyConstant(method={"drawProgressbar(IILnet/minecraft/client/gui/Font;Lnet/minecraft/client/gui/GuiGraphics;)V"}, constant={@Constant(intValue=96)})
    private int changeProgressBorderWidth(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.contents.isEmpty()) {
            return constant;
        }
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.contents.size());
    }

    @ModifyConstant(method={"drawProgressbar(IILnet/minecraft/client/gui/Font;Lnet/minecraft/client/gui/GuiGraphics;)V"}, constant={@Constant(intValue=48)})
    private int removeVanillaProgressBarTextOffset(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.contents.isEmpty()) {
            return constant;
        }
        return 0;
    }

    @WrapOperation(method={"drawProgressbar(IILnet/minecraft/client/gui/Font;Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawCenteredString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;III)V")})
    private void fractionalOffsetProgressBarText(GuiGraphics instance, Font textRenderer, Component text, int centerX, int y, int color, Operation<Void> original) {
        if (!BundlesBeyond.isModEnabled() || this.contents.isEmpty()) {
            original.call(new Object[]{instance, textRenderer, text, centerX, y, color});
            return;
        }
        instance.pose().pushPose();
        float offset = (float)BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.contents.size()) / 2.0f;
        instance.pose().translate(offset, 0.0f, 0.0f);
        original.call(new Object[]{instance, textRenderer, text, centerX, y, color});
        instance.pose().popPose();
    }

    @ModifyReturnValue(method={"getProgressBarFillText()Lnet/minecraft/network/chat/Component;"}, at={@At(value="TAIL")})
    private Component modifyProgressBarLabel(Component original) {
        if (!BundlesBeyond.isModEnabled()) {
            return original;
        }
        return Component.literal((String)(this.contents.weight().multiplyBy(Fraction.getFraction((int)64, (int)1)).getNumerator() + "/64"));
    }

    @ModifyConstant(method={"itemGridHeight()I"}, constant={@Constant(intValue=24)})
    private int changeRowHeight(int constant) {
        if (!BundlesBeyond.isModEnabled()) {
            return constant;
        }
        return BundlesBeyondConfig.instance().slotSize;
    }

    @WrapOperation(method={"renderSlot(IIILjava/util/List;ILnet/minecraft/client/gui/Font;Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIII)V")})
    private void fractionalSlotOffset(GuiGraphics instance, Function<ResourceLocation, RenderType> renderLayers, ResourceLocation sprite, int x, int y, int width, int height, Operation<Void> original) {
        if (!BundlesBeyond.isModEnabled()) {
            original.call(new Object[]{instance, renderLayers, sprite, x, y, width, height});
            return;
        }
        instance.pose().pushPose();
        float offset = (float)(BundlesBeyondConfig.instance().slotSize - 24) / 2.0f;
        instance.pose().translate(offset, offset, 0.0f);
        original.call(new Object[]{instance, renderLayers, sprite, x, y, width, height});
        instance.pose().popPose();
    }

    @Inject(method={"renderSlot(IIILjava/util/List;ILnet/minecraft/client/gui/Font;Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderItem(Lnet/minecraft/world/item/ItemStack;III)V")})
    private void fractionalItemOffset(CallbackInfo ci, @Local(argsOnly=true) GuiGraphics drawContext) {
        if (!BundlesBeyond.isModEnabled()) {
            return;
        }
        drawContext.pose().pushPose();
        float offset = (float)(BundlesBeyondConfig.instance().slotSize - 16) / 2.0f;
        drawContext.pose().translate(offset, offset, 0.0f);
    }

    @ModifyConstant(method={"renderSlot(IIILjava/util/List;ILnet/minecraft/client/gui/Font;Lnet/minecraft/client/gui/GuiGraphics;)V"}, constant={@Constant(intValue=4)})
    private int removeVanillaItemOffset(int constant) {
        if (!BundlesBeyond.isModEnabled()) {
            return constant;
        }
        return 0;
    }

    @Inject(method={"renderSlot(IIILjava/util/List;ILnet/minecraft/client/gui/Font;Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)V", shift=At.Shift.AFTER)})
    private void resetItemOffset(CallbackInfo ci, @Local(argsOnly=true) GuiGraphics drawContext) {
        if (!BundlesBeyond.isModEnabled()) {
            return;
        }
        drawContext.pose().popPose();
    }
}

