package o7410.bundlesbeyond.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
//? if >=1.21.8
/*import com.mojang.blaze3d.pipeline.RenderPipeline;*/
//? if =1.21.4 {
/*import net.minecraft.client.render.RenderLayer;
import java.util.function.Function;
*///?}
//? if >=1.21.4
/*import net.minecraft.util.Identifier;*/
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientBundleTooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.component.BundleContents;
import o7410.bundlesbeyond.BundleTooltipAdditions;
import o7410.bundlesbeyond.BundlesBeyond;
import o7410.bundlesbeyond.BundlesBeyondConfig;
import org.apache.commons.lang3.math.Fraction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(ClientBundleTooltip.class)
public abstract class BundleTooltipComponentMixin {
    @Shadow @Final private BundleContents bundleContents;

    @Inject(method = "getNumVisibleSlots", at = @At("HEAD"), cancellable = true)
    private void changeNumberOfVisibleSlots(CallbackInfoReturnable<Integer> cir) {
        if (!BundlesBeyond.isModEnabled()) return;
        cir.setReturnValue(this.bundleContents.size());
    }

    @ModifyVariable(method = "drawNonEmptyTooltip", at = @At("STORE"))
    private boolean changeIfToDrawExtraItemsCount(boolean original) {
        if (!BundlesBeyond.isModEnabled()) return original;
        return false;
    }

    @ModifyConstant(
            method = "drawNonEmptyTooltip",
            constant = @Constant(intValue = 4),
            slice = @Slice(
                    to = @At(
                            value = "INVOKE",
                            target = "Lnet/minecraft/client/gui/tooltip/BundleTooltipComponent;drawSelectedItemTooltip(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/client/gui/DrawContext;III)V"
                    )
            )
    )
    private int modifyDrawnColumnsCount(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumns(this.bundleContents.size());
    }

    @ModifyConstant(method = "drawNonEmptyTooltip", constant = @Constant(intValue = 96))
    private int modifyRightAlignmentForItems(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.bundleContents.size());
    }

    @ModifyConstant(method = "drawNonEmptyTooltip", constant = @Constant(intValue = 24))
    private int modifySlotSize(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return BundlesBeyondConfig.instance().slotSize;
    }

    @ModifyConstant(method = "getXMargin", constant = @Constant(intValue = 96))
    private int modfiyXMargin(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.bundleContents.isEmpty()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.bundleContents.size());
    }

    @ModifyConstant(method = "getWidth", constant = @Constant(intValue = 96))
    private int changeTooltipWidth(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.bundleContents.isEmpty()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.bundleContents.size());
    }

    @ModifyConstant(method = "getProgressBarFill", constant = @Constant(intValue = 94))
    private int changeProgressBarFill(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.bundleContents.isEmpty()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.bundleContents.size()) - 2;
    }

    @ModifyConstant(method = "getRows", constant = @Constant(intValue = 4))
    private int modifyItemsPerRow(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumns(this.bundleContents.size());
    }

    @ModifyConstant(method = "drawProgressBar", constant = @Constant(intValue = 96))
    private int changeProgressBorderWidth(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.bundleContents.isEmpty()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.bundleContents.size());
    }

    @ModifyConstant(method = "drawProgressBar", constant = @Constant(intValue = 48))
    private int removeVanillaProgressBarTextOffset(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.bundleContents.isEmpty()) return constant;
        return 0;
    }

    @WrapOperation(method = "drawProgressBar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawCenteredTextWithShadow(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;III)V"))
    private void fractionalOffsetProgressBarText(GuiGraphics instance, Font textRenderer, Component text, int centerX, int y, int color, Operation<Void> original) {
        if (!BundlesBeyond.isModEnabled() || this.bundleContents.isEmpty()) {
            original.call(instance, textRenderer, text, centerX, y, color);
            return;
        }
        instance.pose()
                //? if >=1.21.8 {
                /*.pushMatrix();
                *///?} else {
                .pushPose();
                //?}
        float offset = BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.bundleContents.size()) / 2f;
        instance.pose().translate(offset, 0/*? if <1.21.8 {*/, 0/*?}*/);
        original.call(instance, textRenderer, text, centerX, y, color);
        instance.pose()
                //? if >=1.21.8 {
                /*.popMatrix();
                *///?} else {
                .popPose();
                //?}
    }

    @ModifyReturnValue(method = "getProgressBarLabel", at = @At("TAIL"))
    private Component modifyProgressBarLabel(Component original) {
        if (!BundlesBeyond.isModEnabled()) return original;
        return Component.literal(bundleContents.weight().multiplyBy(Fraction.getFraction(64, 1)).getNumerator() + "/64");
    }

    @ModifyConstant(method = "getRowsHeight", constant = @Constant(intValue = 24))
    private int changeRowHeight(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return BundlesBeyondConfig.instance().slotSize;
    }
    //? if =1.21.3 {
    @ModifyConstant(method = "drawItem", constant = @Constant(intValue = 24))
    private int modifySlotTextureSize(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return BundlesBeyondConfig.instance().slotSize;
    }
    //?}

    //? if >=1.21.8 {
    /*@WrapOperation(method = "drawItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIII)V"))
    *///?}
    //? if =1.21.4 {
    /*@WrapOperation(method = "drawItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Ljava/util/function/Function;Lnet/minecraft/util/Identifier;IIII)V"))
    *///?}
    //? if >=1.21.4 {
    /*private void fractionalSlotOffset(DrawContext instance,
                                      /^? if >=1.21.8 {^//^RenderPipeline pipeline,
                                      ^//^?} else {^/Function<Identifier, RenderLayer> renderLayers,/^?}^/
                                      Identifier sprite, int x, int y, int width, int height, Operation<Void> original) {
        if (!BundlesBeyond.isModEnabled()) {
            original.call(instance, /^? if =1.21.4 {^//^renderLayers^//^?} else {^/pipeline/^?}^/, sprite, x, y, width, height);
            return;
        }
        instance.getMatrices()
                //? if >=1.21.8 {
                /^.pushMatrix();
                ^///?} else {
                .push();
                 //?}
        float offset = (BundlesBeyondConfig.instance().slotSize - 24) / 2f;
        instance.getMatrices().translate(offset, offset/^? if <1.21.8 {^/, 0/^?}^/);
        original.call(instance, /^? if =1.21.4 {^//^renderLayers^//^?} else {^/pipeline/^?}^/, sprite, x, y, width, height);
        instance.getMatrices()
                //? if >=1.21.8 {
                /^.popMatrix();
                ^///?} else {
                .pop();
                //?}
    }
    *///?}

    @Inject(method = "drawItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawItem(Lnet/minecraft/item/ItemStack;III)V"))
    private void fractionalItemOffset(CallbackInfo ci, @Local(argsOnly = true) GuiGraphics drawContext) {
        if (!BundlesBeyond.isModEnabled()) return;
        drawContext.pose()
                //? if >=1.21.8 {
                /*.pushMatrix();
                *///?} else {
                .pushPose();
                //?}
        float offset = (BundlesBeyondConfig.instance().slotSize - 16) / 2f;
        drawContext.pose().translate(offset, offset/*? if <1.21.8 {*/, 0/*?}*/);
    }

    @ModifyConstant(method = "drawItem", constant = @Constant(intValue = 4))
    private int removeVanillaItemOffset(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return 0;
    }

    @Inject(method = "drawItem", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/DrawContext;drawStackOverlay(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;II)V",
            shift = At.Shift.AFTER))
    private void resetItemOffset(CallbackInfo ci, @Local(argsOnly = true) GuiGraphics drawContext) {
        if (!BundlesBeyond.isModEnabled()) return;
        drawContext.pose()
                //? if >=1.21.8 {
                /*.popMatrix();
                *///?} else {
                .popPose();
                //?}
    }
}
