package o7410.bundlesbeyond.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
//? if >=1.21.8
import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5682;
import net.minecraft.class_9276;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import o7410.bundlesbeyond.BundleTooltipAdditions;
import o7410.bundlesbeyond.BundlesBeyond;
import o7410.bundlesbeyond.BundlesBeyondConfig;
import org.apache.commons.lang3.math.Fraction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_5682.class)
public abstract class BundleTooltipComponentMixin {
    @Shadow @Final private class_9276 bundleContents;

    @Inject(method = "getNumVisibleSlots", at = @At("HEAD"), cancellable = true)
    private void changeNumberOfVisibleSlots(CallbackInfoReturnable<Integer> cir) {
        if (!BundlesBeyond.isModEnabled()) return;
        cir.setReturnValue(this.bundleContents.method_57426());
    }

    @ModifyVariable(method = "drawNonEmptyTooltip", at = @At("STORE"))
    private boolean changeIfToDrawExtraItemsCount(boolean original) {
        if (!BundlesBeyond.isModEnabled()) return original;
        return false;
    }

    @ModifyConstant(
            method = "drawNonEmptyTooltip",
            constant = @Constant(intValue = 4),
            slice = @Slice(
                    to = @At(
                            value = "INVOKE",
                            target = "Lnet/minecraft/client/gui/tooltip/BundleTooltipComponent;drawSelectedItemTooltip(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/client/gui/DrawContext;III)V"
                    )
            )
    )
    private int modifyDrawnColumnsCount(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumns(this.bundleContents.method_57426());
    }

    @ModifyConstant(method = "drawNonEmptyTooltip", constant = @Constant(intValue = 96))
    private int modifyRightAlignmentForItems(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.bundleContents.method_57426());
    }

    @ModifyConstant(method = "drawNonEmptyTooltip", constant = @Constant(intValue = 24))
    private int modifySlotSize(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return BundlesBeyondConfig.instance().slotSize;
    }

    @ModifyConstant(method = "getXMargin", constant = @Constant(intValue = 96))
    private int modfiyXMargin(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.bundleContents.method_57429()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.bundleContents.method_57426());
    }

    @ModifyConstant(method = "getWidth", constant = @Constant(intValue = 96))
    private int changeTooltipWidth(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.bundleContents.method_57429()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.bundleContents.method_57426());
    }

    @ModifyConstant(method = "getProgressBarFill", constant = @Constant(intValue = 94))
    private int changeProgressBarFill(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.bundleContents.method_57429()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.bundleContents.method_57426()) - 2;
    }

    @ModifyConstant(method = "getRows", constant = @Constant(intValue = 4))
    private int modifyItemsPerRow(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumns(this.bundleContents.method_57426());
    }

    @ModifyConstant(method = "drawProgressBar", constant = @Constant(intValue = 96))
    private int changeProgressBorderWidth(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.bundleContents.method_57429()) return constant;
        return BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.bundleContents.method_57426());
    }

    @ModifyConstant(method = "drawProgressBar", constant = @Constant(intValue = 48))
    private int removeVanillaProgressBarTextOffset(int constant) {
        if (!BundlesBeyond.isModEnabled() || this.bundleContents.method_57429()) return constant;
        return 0;
    }

    @WrapOperation(method = "drawProgressBar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawCenteredTextWithShadow(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;III)V"))
    private void fractionalOffsetProgressBarText(class_332 instance, class_327 textRenderer, class_2561 text, int centerX, int y, int color, Operation<Void> original) {
        if (!BundlesBeyond.isModEnabled() || this.bundleContents.method_57429()) {
            original.call(instance, textRenderer, text, centerX, y, color);
            return;
        }
        instance.method_51448()
                //? if >=1.21.8 {
                .pushMatrix();
                //?} else {
                /*.push();
                *///?}
        float offset = BundleTooltipAdditions.getModifiedBundleTooltipColumnsPixels(this.bundleContents.method_57426()) / 2f;
        instance.method_51448().translate(offset, 0/*? if <1.21.8 {*//*, 0*//*?}*/);
        original.call(instance, textRenderer, text, centerX, y, color);
        instance.method_51448()
                //? if >=1.21.8 {
                .popMatrix();
                //?} else {
                /*.pop();
                *///?}
    }

    @ModifyReturnValue(method = "getProgressBarLabel", at = @At("TAIL"))
    private class_2561 modifyProgressBarLabel(class_2561 original) {
        if (!BundlesBeyond.isModEnabled()) return original;
        return class_2561.method_43470(bundleContents.method_57428().multiplyBy(Fraction.getFraction(64, 1)).getNumerator() + "/64");
    }

    @ModifyConstant(method = "getRowsHeight", constant = @Constant(intValue = 24))
    private int changeRowHeight(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return BundlesBeyondConfig.instance().slotSize;
    }
    //? if =1.21.3 {
    /*@ModifyConstant(method = "drawItem", constant = @Constant(intValue = 24))
    private int modifySlotTextureSize(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return BundlesBeyondConfig.instance().slotSize;
    }
    *///?}

    //? if >=1.21.8 {
    @WrapOperation(method = "drawItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIII)V"))
    //?}
    //? if =1.21.4 {
    /*@WrapOperation(method = "drawItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Ljava/util/function/Function;Lnet/minecraft/util/Identifier;IIII)V"))
    *///?}
    //? if >=1.21.4 {
    private void fractionalSlotOffset(class_332 instance,
                                      /*? if >=1.21.8 {*/RenderPipeline pipeline,
                                      /*?} else {*//*Function<Identifier, RenderLayer> renderLayers,*//*?}*/
                                      class_2960 sprite, int x, int y, int width, int height, Operation<Void> original) {
        if (!BundlesBeyond.isModEnabled()) {
            original.call(instance, /*? if =1.21.4 {*//*renderLayers*//*?} else {*/pipeline/*?}*/, sprite, x, y, width, height);
            return;
        }
        instance.method_51448()
                //? if >=1.21.8 {
                .pushMatrix();
                //?} else {
                /*.push();
                 *///?}
        float offset = (BundlesBeyondConfig.instance().slotSize - 24) / 2f;
        instance.method_51448().translate(offset, offset/*? if <1.21.8 {*//*, 0*//*?}*/);
        original.call(instance, /*? if =1.21.4 {*//*renderLayers*//*?} else {*/pipeline/*?}*/, sprite, x, y, width, height);
        instance.method_51448()
                //? if >=1.21.8 {
                .popMatrix();
                //?} else {
                /*.pop();
                *///?}
    }
    //?}

    @Inject(method = "drawItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawItem(Lnet/minecraft/item/ItemStack;III)V"))
    private void fractionalItemOffset(CallbackInfo ci, @Local(argsOnly = true) class_332 drawContext) {
        if (!BundlesBeyond.isModEnabled()) return;
        drawContext.method_51448()
                //? if >=1.21.8 {
                .pushMatrix();
                //?} else {
                /*.push();
                *///?}
        float offset = (BundlesBeyondConfig.instance().slotSize - 16) / 2f;
        drawContext.method_51448().translate(offset, offset/*? if <1.21.8 {*//*, 0*//*?}*/);
    }

    @ModifyConstant(method = "drawItem", constant = @Constant(intValue = 4))
    private int removeVanillaItemOffset(int constant) {
        if (!BundlesBeyond.isModEnabled()) return constant;
        return 0;
    }

    @Inject(method = "drawItem", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/DrawContext;drawStackOverlay(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;II)V",
            shift = At.Shift.AFTER))
    private void resetItemOffset(CallbackInfo ci, @Local(argsOnly = true) class_332 drawContext) {
        if (!BundlesBeyond.isModEnabled()) return;
        drawContext.method_51448()
                //? if >=1.21.8 {
                .popMatrix();
                //?} else {
                /*.pop();
                *///?}
    }
}
