package o7410.bundlesbeyond;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;

//? if fabric
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7157;
import net.minecraft.class_7485;
import net.minecraft.class_8015;

public class BundlesBeyondCommand {
    public static <T extends class_2172> void registerCommand(CommandDispatcher<T> dispatcher, class_7157 registryAccess) {
        dispatcher.register(LiteralArgumentBuilder.<T>literal("bundlesbeyond")
                .executes(BundlesBeyondCommand::configScreen)
                .then(LiteralArgumentBuilder.<T>literal("mod_enabled_state")
                        .executes(BundlesBeyondCommand::executeGetModEnabledState)
                        .then(RequiredArgumentBuilder.<T, ModEnabledState>argument("state", new class_7485<>(ModEnabledState.CODEC, ModEnabledState::values) {})
                                .suggests(BundlesBeyondCommand::getModEnabledStateSuggestions)
                                .executes(BundlesBeyondCommand::executeSetModEnabledState)))
                .then(LiteralArgumentBuilder.<T>literal("scroll_mode")
                        .executes(BundlesBeyondCommand::executeGetScrollMode)
                        .then(RequiredArgumentBuilder.<T, ScrollMode>argument("mode", new class_7485<>(ScrollMode.CODEC, ScrollMode::values) {})
                                .suggests(BundlesBeyondCommand::getScrollModeSuggestions)
                                .executes(BundlesBeyondCommand::executeSetScrollMode)
                        )
                )
                .then(LiteralArgumentBuilder.<T>literal("slot_size")
                        .executes(BundlesBeyondCommand::executeGetSlotSize)
                        .then(RequiredArgumentBuilder.<T, Integer>argument("size", IntegerArgumentType.integer(18))
                                .suggests(BundlesBeyondCommand::getSlotSizeSuggestions)
                                .executes(BundlesBeyondCommand::executeSetSlotSize)))
                .then(LiteralArgumentBuilder.<T>literal("reloadconfig")
                        .executes(BundlesBeyondCommand::executeReloadConfig))
        );
    }

    private static void sendFeedback(CommandContext<? extends class_2172> context, class_2561 text) {
        class_2172 source = context.getSource();

        //? if fabric {
        if (source instanceof FabricClientCommandSource fabricSource) {
            fabricSource.sendFeedback(text);
        }
        //?}
        if (source instanceof class_2168 serverSource) {
            serverSource.method_9226(() -> text, false);
        }
    }

    private static void sendError(CommandContext<? extends class_2172> context, class_2561 text) {
        class_2172 source = context.getSource();
        //? if fabric {
        if (source instanceof FabricClientCommandSource fabricSource) {
            fabricSource.sendError(text);
        }
        //?}
        if (source instanceof class_2168 serverSource) {
            serverSource.method_9213(text);
        }
    }

    private static int configScreen(CommandContext<? extends class_2172> context) {
        class_310 client = class_310.method_1551();
        //? if >=1.21.10 {
        /*if (client.currentScreen instanceof ChatScreen chatScreen) {
            chatScreen.insertText("", true);
        }
        *///?}
        client.method_48185(class_8015.field_41777);
        client.method_1507(new BundlesBeyondConfigScreen(null));
        return 0;
    }

    private static int executeGetModEnabledState(CommandContext<? extends class_2172> context) {
        ModEnabledState state = BundlesBeyondConfig.instance().modEnabledState;
        sendFeedback(context, class_2561.method_43470("Bundles Beyond enabled state is currently: ").method_10852(state.getShortNameText()));
        return 0;
    }

    private static CompletableFuture<Suggestions> getModEnabledStateSuggestions(CommandContext<? extends class_2172> context, SuggestionsBuilder builder) {
        for (ModEnabledState state : ModEnabledState.values()) {
            builder.suggest(state.id, state.getDescriptionText());
        }
        return builder.buildFuture();
    }

    private static int executeSetModEnabledState(CommandContext<? extends class_2172> context) {
        ModEnabledState newModEnabledState = context.getArgument("state", ModEnabledState.class);
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();
        sendFeedback(context, class_2561.method_43470("Bundles Beyond enabled state is now: ").method_10852(newModEnabledState.getShortNameText()));
        if (config.modEnabledState != newModEnabledState) {
            config.modEnabledState = newModEnabledState;
            if (!BundlesBeyondConfig.save()) {
                sendError(context, class_2561.method_43470("Failed to save Bundles Beyond config"));
            }
        }
        return 0;
    }

    private static int executeGetScrollMode(CommandContext<? extends class_2172> context) {
        sendFeedback(context, class_2561.method_43470("Scroll mode is currently: ").method_10852(BundlesBeyondConfig.instance().scrollMode.getShortNameText()));
        return 0;
    }

    private static CompletableFuture<Suggestions> getScrollModeSuggestions(CommandContext<? extends class_2172> context, SuggestionsBuilder builder) {
        for (ScrollMode scrollMode : ScrollMode.values()) {
            builder.suggest(scrollMode.id, scrollMode.getDescriptionText());
        }
        return builder.buildFuture();
    }

    private static int executeSetScrollMode(CommandContext<? extends class_2172> context) {
        ScrollMode newMode = context.getArgument("mode", ScrollMode.class);
        sendFeedback(context, class_2561.method_43470("Scroll mode is now: ").method_10852(newMode.getShortNameText()));
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();
        if (config.scrollMode != newMode) {
            config.scrollMode = newMode;
            if (!BundlesBeyondConfig.save()) {
                sendError(context, class_2561.method_43470("Failed to save Bundles Beyond config"));
            }
        }
        return 0;
    }

    private static int executeGetSlotSize(CommandContext<? extends class_2172> context) {
        int slotSize = BundlesBeyondConfig.instance().slotSize;
        sendFeedback(context, class_2561.method_43470("Slot size is currently: " + slotSize + (slotSize == 24 ? " (Vanilla)" : "")));
        return 0;
    }

    private static CompletableFuture<Suggestions> getSlotSizeSuggestions(CommandContext<? extends class_2172> context, SuggestionsBuilder builder) {
        builder.suggest(24);
        return builder.buildFuture();
    }

    private static int executeSetSlotSize(CommandContext<? extends class_2172> context) {
        int slotSize = IntegerArgumentType.getInteger(context, "size");
        sendFeedback(context, class_2561.method_43470("Slot size is now: " + slotSize + (slotSize == 24 ? " (Vanilla)" : "")));
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();
        if (config.slotSize != slotSize) {
            config.slotSize = slotSize;
            if (!BundlesBeyondConfig.save()) {
                sendError(context, class_2561.method_43470("Failed to save Bundles Beyond config"));
            }
        }
        return 0;
    }

    private static int executeReloadConfig(CommandContext<? extends class_2172> context) {
        if (BundlesBeyondConfig.load()) {
            sendFeedback(context, class_2561.method_43470("Reloaded Bundles Beyond config"));
        } else {
            sendError(context, class_2561.method_43470("Failed to reload Bundles Beyond config"));
        }
        return 0;
    }
}
