package o7410.bundlesbeyond;

import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8494;
import o7410.bundlesbeyond.mixin.SliderWidgetAccessor;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class BundlesBeyondConfigScreen extends class_437 {
    private static final class_2960 TEXTURE = class_2960.method_60655(BundlesBeyond.MOD_ID, "textures/gui/config.png");
    private static final int BACKGROUND_WIDTH = 222;
    private static final int BACKGROUND_HEIGHT = 148;
    private static final class_2561 FAILED_TO_RELOAD_TEXT = class_2561.method_43470("Failed to reload").method_27692(class_124.field_1061);
    private static final class_2561 FAILED_TO_SAVE_TEXT = class_2561.method_43470("Failed to save").method_27692(class_124.field_1061);

    @Nullable private final class_437 parentScreen;
    private ModEnabledStateButton[] modEnabledStateButtons;
    private ScrollModeButton[] scrollModeButtons;
    private class_7842 failedToReload;
    private class_7842 failedToSave;

    public BundlesBeyondConfigScreen(@Nullable class_437 parentScreen) {
        super(class_2561.method_43470("Bundles Beyond config"));
        this.parentScreen = parentScreen;
    }

    @Override
    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);

        context.method_25290(
                //? if >=1.21.8 {
                /*RenderPipelines.GUI_TEXTURED,
                *///?} else {
                class_1921::method_62277,
                //?}
                TEXTURE,
                (this.field_22789 - BACKGROUND_WIDTH) / 2,
                (this.field_22790 - BACKGROUND_HEIGHT) / 2,
                0.0F, 0.0F,
                BACKGROUND_WIDTH, BACKGROUND_HEIGHT,
                256, 256
        );
        context.method_25303(
                this.field_22793,
                "Mod Enabled State",
                (this.field_22789 - BACKGROUND_WIDTH) / 2 + 9,
                (this.field_22790 + BACKGROUND_HEIGHT) / 2 - 40,
                0xFFFFFFFF
        );
        context.method_25300(
                this.field_22793,
                "Scroll Mode",
                this.field_22789 / 2,
                (this.field_22790 - BACKGROUND_HEIGHT) / 2 + 5,
                0xFFFFFFFF
        );
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        this.method_37063(
                class_4185.method_46430(class_2561.method_43470("Reload"), this::reloadConfig)
                        .method_46434((this.field_22789 + BACKGROUND_WIDTH) / 2 - 49, (this.field_22790 + BACKGROUND_HEIGHT) / 2 - 30, 40, 20)
                        .method_46436(class_7919.method_47407(class_2561.method_43470("Reload config")))
                        .method_46431());

        addModEnabledStateButtons();
        addScrollModeButtons();
        addFailedTextWidgets();

        this.method_37063(
                new SlotSizeSlider((this.field_22789 - BACKGROUND_WIDTH) / 2 + 9, (this.field_22790 - BACKGROUND_HEIGHT) / 2 + 85,
                        204, 20, BundlesBeyondConfig.instance().slotSize));

        updateButtons();
    }

    private void addFailedTextWidgets() {
        this.failedToReload = new class_7842(
                (this.field_22789 + BACKGROUND_WIDTH) / 2 - this.field_22793.method_27525(FAILED_TO_RELOAD_TEXT) - 10,
                (this.field_22790 + BACKGROUND_HEIGHT) / 2 - 40,
                this.field_22793.method_27525(FAILED_TO_RELOAD_TEXT),
                9,
                FAILED_TO_RELOAD_TEXT,
                this.field_22793
        );
        this.failedToReload.method_47400(class_7919.method_47407(class_2561.method_43470("See log for details")));
        this.failedToReload.field_22764 = false;
        this.method_37063(this.failedToReload);

        this.failedToSave = new class_7842(
                (this.field_22789 + BACKGROUND_WIDTH) / 2 - this.field_22793.method_27525(FAILED_TO_SAVE_TEXT) - 10,
                (this.field_22790 + BACKGROUND_HEIGHT) / 2 - 40,
                this.field_22793.method_27525(FAILED_TO_SAVE_TEXT),
                9,
                FAILED_TO_SAVE_TEXT,
                this.field_22793
        );
        this.failedToSave.method_47400(class_7919.method_47407(class_2561.method_43470("See log for details")));
        this.failedToSave.field_22764 = false;
        this.method_37063(this.failedToSave);
    }

    private void addScrollModeButtons() {
        int topY = (this.field_22790 - BACKGROUND_HEIGHT) / 2;
        int centerX = this.field_22789 / 2;
        ScrollModeButton scrollModeVanillaButton = this.method_37063(
                new ScrollModeButton(ScrollMode.VANILLA,
                        centerX - 100 - 2, topY + 15, 204, 20));

        ScrollModeButton scrollModeHorizontalButton = this.method_37063(
                new ScrollModeButton(ScrollMode.HORIZONTAL,
                        centerX - 100 - 2, topY + 38, 100, 20));

        ScrollModeButton scrollModeVerticalButton = this.method_37063(
                new ScrollModeButton(ScrollMode.VERTICAL,
                        centerX + 2, topY + 38, 100, 20));

        ScrollModeButton scrollModeHoldForHorizontalButton = this.method_37063(
                new ScrollModeButton(ScrollMode.HOLD_FOR_HORIZONTAL,
                        centerX + 2, topY + 61, 100, 20));

        ScrollModeButton scrollModeHoldForVerticalButton = this.method_37063(
                new ScrollModeButton(ScrollMode.HOLD_FOR_VERTICAL,
                        centerX - 100 - 2, topY + 61, 100, 20));

        this.scrollModeButtons = new ScrollModeButton[] {
                scrollModeVanillaButton,
                scrollModeHorizontalButton,
                scrollModeVerticalButton,
                scrollModeHoldForHorizontalButton,
                scrollModeHoldForVerticalButton
        };
    }

    private void addModEnabledStateButtons() {
        int bottomY = (this.field_22790 + BACKGROUND_HEIGHT) / 2;
        int leftX = (this.field_22789 - BACKGROUND_WIDTH) / 2;
        ModEnabledStateButton modEnabledStateOnButton = this.method_37063(
                new ModEnabledStateButton(ModEnabledState.ON,
                        leftX + 9, bottomY - 30, 34, 20));

        ModEnabledStateButton modEnabledStateOffButton = this.method_37063(
                new ModEnabledStateButton(ModEnabledState.OFF,
                        leftX + 46, bottomY - 30, 34, 20));

        ModEnabledStateButton modEnabledStateHoldKeyButton = this.method_37063(
                new ModEnabledStateButton(ModEnabledState.HOLD_KEY,
                        leftX + 83, bottomY - 30, 71, 20));

        this.modEnabledStateButtons = new ModEnabledStateButton[] {
                modEnabledStateOnButton,
                modEnabledStateOffButton,
                modEnabledStateHoldKeyButton
        };
    }

    @Override
    public void method_25419() {
        this.field_22787.method_1507(this.parentScreen);
    }

    private void reloadConfig(class_4185 button) {
        this.failedToReload.field_22764 = !BundlesBeyondConfig.load();
        if (this.failedToReload.field_22764) {
            this.failedToSave.field_22764 = false;
        }
        this.updateButtons();
    }

    private void save() {
        failedToSave.field_22764 = !BundlesBeyondConfig.save();
        if (failedToSave.field_22764) {
            failedToReload.field_22764 = false;
        }
    }

    private void updateButtons() {
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();

        for (ModEnabledStateButton modEnabledStateButton : modEnabledStateButtons) {
            modEnabledStateButton.field_22763 = config.modEnabledState != modEnabledStateButton.modEnabledState;
        }

        for (ScrollModeButton scrollModeButton : scrollModeButtons) {
            scrollModeButton.field_22763 = config.scrollMode != scrollModeButton.scrollMode;
        }
    }

    private class ScrollModeButton extends class_4185 {
        public final ScrollMode scrollMode;

        public ScrollModeButton(ScrollMode scrollMode, int x, int y, int width, int height) {
            super(x, y, width, height, scrollMode.getShortNameText(), button -> {
                BundlesBeyondConfig.instance().scrollMode = scrollMode;
                save();
                updateButtons();
            }, field_40754);
            this.method_47400(class_7919.method_47407(scrollMode.getDescriptionText()));
            this.scrollMode = scrollMode;
        }
    }

    private class ModEnabledStateButton extends class_4185 {
        public final ModEnabledState modEnabledState;

        public ModEnabledStateButton(ModEnabledState modEnabledState, int x, int y, int width, int height) {
            super(x, y, width, height, modEnabledState.getShortNameText(), button -> {
                BundlesBeyondConfig.instance().modEnabledState = modEnabledState;
                save();
                updateButtons();
            }, field_40754);
            this.method_47400(class_7919.method_47407(modEnabledState.getDescriptionText()));
            this.modEnabledState = modEnabledState;
        }
    }

    private class SlotSizeSlider extends class_357 {
        private static final int MIN_VALUE = 18;
        private static final int MAX_VALUE = 24;

        public SlotSizeSlider(int x, int y, int width, int height, int slotSize) {
            super(x, y, width, height, null, calculateValue(slotSize));
            method_25346();
        }

        private int calculateSlotSize() {
            return (int) Math.round((this.field_22753 * (MAX_VALUE - MIN_VALUE) + MIN_VALUE));
        }

        private static double calculateValue(int slotSize) {
            return (double) (slotSize - MIN_VALUE) / (MAX_VALUE - MIN_VALUE);
        }

        @Override
        protected void method_25346() {
            int slotSize = calculateSlotSize();
            this.method_25355(class_2561.method_43470("Bundle Slot Size: " + slotSize + (slotSize == 24 ? " (Vanilla)" : "")));
        }

        @Override
        protected void method_25344() {
            int slotSize = calculateSlotSize();
            BundlesBeyondConfig config = BundlesBeyondConfig.instance();
            if (config.slotSize != slotSize) {
                config.slotSize = slotSize;
                save();
            }

            this.field_22753 = calculateValue(slotSize);
        }

        @Override
        //? if <1.21.10 {
        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        //?} else {
        /*public boolean keyPressed(KeyInput input) {
            int keyCode = input.key();
        *///?}
            SliderWidgetAccessor self = (SliderWidgetAccessor) this;
            //? if <1.21.10 {
            if (class_8494.method_51255(keyCode)) {
            //?} else {
            /*if (input.isEnterOrSpace()) {
            *///?}
                self.setSliderFocused(!self.getSliderFocused());
                return true;
            }
            if (self.getSliderFocused()) {
                boolean pressedLeft = keyCode == GLFW.GLFW_KEY_LEFT;
                if (pressedLeft || keyCode == GLFW.GLFW_KEY_RIGHT) {
                    int offset = pressedLeft ? -1 : 1;

                    this.field_22753 = calculateValue(class_3532.method_15340(calculateSlotSize() + offset, MIN_VALUE, MAX_VALUE));
                    this.method_25344();
                    this.method_25346();

                    return true;
                }
            }

            return false;
        }
    }
}
