package o7410.bundlesbeyond.mixin;

import o7410.bundlesbeyond.BundleTooltipAdditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import net.minecraft.class_1735;
import net.minecraft.class_465;
import net.minecraft.class_9929;
import net.minecraft.class_9930;

@Mixin(class_465.class)
public abstract class HandledScreenMixin {
    @Shadow @Nullable protected class_1735 focusedSlot;

    @Shadow @Final private List<class_9930> tooltipSubmenuHandlers;

    //? if <1.21.10 {
    @Inject(method = "keyPressed", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;handleHotbarKeyPressed(II)Z"), cancellable = true)
    private void bundleSubmenuKeyHandling(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
    //?} else {
    /*@Inject(method = "keyPressed", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;handleHotbarKeyPressed(Lnet/minecraft/client/input/KeyInput;)Z"), cancellable = true)
    private void bundleSubmenuKeyHandling(KeyInput input, CallbackInfoReturnable<Boolean> cir) {
        int keyCode = input.key();
    *///?}
        if (this.focusedSlot == null || !this.focusedSlot.method_7681()) {
            return;
        }
        for (class_9930 tooltipSubmenuHandler : this.tooltipSubmenuHandlers) {
            if (
                    tooltipSubmenuHandler instanceof class_9929 &&
                    tooltipSubmenuHandler.method_61974(this.focusedSlot) &&
                    BundleTooltipAdditions.handleKeybindsInBundleGui(this.focusedSlot, keyCode)
            ) {
                cir.setReturnValue(true);
            }
        }
    }

    @Unique
    protected List<class_9930> bundlesBeyond$getTooltipSubmenuHandlers() {
        return tooltipSubmenuHandlers;
    }
}
