/*
 * Decompiled with CFR 0.152.
 */
package ninja.tokumei.signsearcher;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.cottonmc.clientcommands.ArgumentBuilders;
import io.github.cottonmc.clientcommands.ClientCommandPlugin;
import io.github.cottonmc.clientcommands.CottonClientCommandSource;
import java.util.HashSet;
import java.util.Optional;
import java.util.PrimitiveIterator;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientBlockEntityEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2625;
import ninja.tokumei.signsearcher.event.SignUpdateCallback;
import ninja.tokumei.signsearcher.ext.BlockEntityExt;
import ninja.tokumei.signsearcher.ext.SignBlockEntityExt;

public class SignSearcher
implements ClientModInitializer,
ClientCommandPlugin {
    private static final HashSet<class_2625> signs = new HashSet();
    private static String searchText = "";

    public void onInitializeClient() {
        System.out.println("Client init");
        SignUpdateCallback.EVENT.register(SignSearcher::addSign);
        ClientBlockEntityEvents.BLOCK_ENTITY_UNLOAD.register((blockEntity, world) -> {
            if (blockEntity instanceof class_2625) {
                SignSearcher.removeSign((class_2625)blockEntity);
            }
        });
    }

    public void registerCommands(CommandDispatcher<CottonClientCommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentBuilders.literal((String)"signsearch").then(ArgumentBuilders.argument((String)"query", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String searchText = StringArgumentType.getString((CommandContext)context, (String)"query");
            SignSearcher.setSearchText(searchText);
            ((CottonClientCommandSource)context.getSource()).sendFeedback((class_2561)new class_2585(String.format("Searching for `%s`...", searchText)));
            return 1;
        }))).executes(context -> {
            SignSearcher.setSearchText("");
            ((CottonClientCommandSource)context.getSource()).sendFeedback((class_2561)new class_2585("Cleared search"));
            return 1;
        }));
    }

    public static void updateSign(class_2625 sign) {
        ((BlockEntityExt)sign).setGlowing(SignSearcher.matchesSign(sign));
    }

    public static boolean matchesSign(class_2625 sign) {
        if (searchText.equals("")) {
            return false;
        }
        StringBuilder signText = new StringBuilder();
        for (class_2561 line : ((SignBlockEntityExt)sign).getText()) {
            line.method_27657(part -> {
                signText.append(part);
                return Optional.empty();
            });
            signText.append(" ");
        }
        return SignSearcher.fuzzyContains(signText.toString(), searchText);
    }

    public static void addSign(class_2625 sign) {
        signs.add(sign);
        SignSearcher.updateSign(sign);
    }

    public static void removeSign(class_2625 sign) {
        signs.remove(sign);
    }

    public static void setSearchText(String searchText) {
        if (!SignSearcher.searchText.equals(searchText)) {
            SignSearcher.searchText = searchText;
            for (class_2625 sign : signs) {
                SignSearcher.updateSign(sign);
            }
        }
    }

    private static boolean fuzzyContains(String a, String b) {
        for (int i = 0; i < a.length(); ++i) {
            if (!SignSearcher.fuzzyStartsWith(a.substring(i), b)) continue;
            return true;
        }
        return false;
    }

    private static boolean fuzzyStartsWith(String a, String b) {
        PrimitiveIterator.OfInt aChars = a.trim().chars().iterator();
        PrimitiveIterator.OfInt bChars = b.trim().chars().iterator();
        while (aChars.hasNext() && bChars.hasNext()) {
            int aChar = aChars.nextInt();
            int bChar = bChars.nextInt();
            while (Character.isWhitespace(aChar) && Character.isWhitespace(bChar) && aChars.hasNext() && bChars.hasNext()) {
                aChar = aChars.nextInt();
                bChar = bChars.nextInt();
            }
            if (Character.toLowerCase(aChar) == Character.toLowerCase(bChar)) continue;
            return false;
        }
        return !bChars.hasNext();
    }
}

