/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.debug;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.nenio.composter.ComposterUsageState;
import com.nenio.data.ModDataComponents;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_7157;

public final class ComposterDebugCommand {
    public static void register() {
        CommandRegistrationCallback.EVENT.register(ComposterDebugCommand::registerImpl);
    }

    private static void registerImpl(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 env) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"composter").requires(src -> src.method_9259(0))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"check").then(class_2170.method_9247((String)"block").executes(ComposterDebugCommand::checkBlock))).then(class_2170.method_9247((String)"item").executes(ComposterDebugCommand::checkItem))));
    }

    private static int checkBlock(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 player = src.method_44023();
        if (player == null) {
            return 0;
        }
        double reach = 5.0;
        class_239 hr = player.method_5745(reach, 0.0f, false);
        if (hr.method_17783() != class_239.class_240.field_1332) {
            src.method_9226(() -> class_2561.method_43470((String)"Not looking at any block."), false);
            return 0;
        }
        class_3965 bhr = (class_3965)hr;
        class_2338 pos = bhr.method_17777();
        class_3218 serverWorld = src.method_9225();
        if (!serverWorld.method_8320(pos).method_27852(class_2246.field_17563)) {
            src.method_9226(() -> class_2561.method_43470((String)"Block under crosshair is not a composter."), false);
            return 0;
        }
        int value = ComposterUsageState.get(serverWorld).get(pos);
        src.method_9226(() -> class_2561.method_43470((String)("Composter at " + pos.method_23854() + " cashouts = " + value)), false);
        return 1;
    }

    private static int checkItem(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        class_3222 player = src.method_44023();
        if (player == null) {
            return 0;
        }
        class_1799 stack = player.method_6047();
        if (!stack.method_31574(class_2246.field_17563.method_8389())) {
            src.method_9226(() -> class_2561.method_43470((String)"Held item is not a composter."), false);
            return 0;
        }
        Integer value = (Integer)stack.method_58694(ModDataComponents.COMPOSTER_CASHOUTS);
        int count = value == null ? 0 : value;
        src.method_9226(() -> class_2561.method_43470((String)("Composter item cashouts = " + count)), false);
        return 1;
    }

    private ComposterDebugCommand() {
    }
}

