/*
 * Decompiled with CFR 0.152.
 */
package com.nenio;

import com.nenio.blockenchants.BlockEnchantParticles;
import com.nenio.config.ConfigManager;
import com.nenio.data.ModDataComponents;
import com.nenio.debug.ComposterDebugCommand;
import com.nenio.debug.ExtraHoneyDebugCommand;
import com.nenio.enchant.AutosowEffectHandler;
import com.nenio.enchant.CollectorEffectHandler;
import com.nenio.enchant.FertilityEffectHandler;
import com.nenio.enchant.GridEffectHandler;
import com.nenio.enchant.OasisEffectHandler;
import com.nenio.trade.FarmerTrades;
import com.nenio.trade.FishermanTrades;
import com.nenio.trade.LibrarianTrades;
import com.nenio.trade.ServerHolder;
import com.nenio.trade.SheperdTrades;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FarmerEnchants
implements ModInitializer {
    public static final String MOD_ID = "farmerenchants";
    public static final Logger LOG = LoggerFactory.getLogger((String)"farmerenchants");

    public void onInitialize() {
        BlockEnchantParticles.init();
        ServerHolder.init();
        ModDataComponents.register();
        ConfigManager.load();
        if (ConfigManager.get().autosow.enable) {
            AutosowEffectHandler.register();
        }
        if (ConfigManager.get().collector.enable) {
            CollectorEffectHandler.register();
        }
        if (ConfigManager.get().fertility.enable) {
            FertilityEffectHandler.register();
        }
        if (ConfigManager.get().oasis.enable) {
            OasisEffectHandler.register();
        }
        if (ConfigManager.get().grid.enable) {
            GridEffectHandler.register();
        }
        if (ConfigManager.get().fertility.enable || ConfigManager.get().autosow.enable || ConfigManager.get().grid.enable || ConfigManager.get().big_house.enable || ConfigManager.get().honey_overflow.enable) {
            try {
                FarmerTrades.register();
            }
            catch (Throwable t) {
                LOG.warn("[{}] FarmerTrades register() threw: {}", (Object)MOD_ID, (Object)t.toString());
            }
        }
        if (ConfigManager.get().collector.enable) {
            try {
                LibrarianTrades.register();
            }
            catch (Throwable t) {
                LOG.warn("[{}] LibrarianTrades register() threw: {}", (Object)MOD_ID, (Object)t.toString());
            }
        }
        if (ConfigManager.get().oasis.enable) {
            try {
                FishermanTrades.register();
            }
            catch (Throwable t) {
                LOG.warn("[{}] FishermanTrades register() threw: {}", (Object)MOD_ID, (Object)t.toString());
            }
        }
        if (ConfigManager.get().big_house.enable || ConfigManager.get().honey_overflow.enable) {
            try {
                SheperdTrades.register();
            }
            catch (Throwable t) {
                LOG.warn("{} SheperdTrades register() threw: {}", (Object)MOD_ID, (Object)t.toString());
            }
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            CommandRegistrationCallback.EVENT.register(ExtraHoneyDebugCommand::register);
            ComposterDebugCommand.register();
        }
        LOG.info("[{}] Initialization complete.", (Object)MOD_ID);
    }
}

