/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.enchant;

import com.nenio.config.ConfigManager;
import com.nenio.enchant.OasisEffectHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public final class GridEffectHandler {
    private static final class_5321<class_1887> GRID_KEY = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)class_2960.method_60655((String)"farmerenchants", (String)"grid"));
    private static final class_6862<class_2248> TAG_REPLACEABLE_PLANTS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"minecraft", (String)"replaceable_plants"));
    private static final class_6862<class_2248> TAG_TALL_FLOWERS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"minecraft", (String)"tall_flowers"));

    private GridEffectHandler() {
    }

    public static void register() {
        UseBlockCallback.EVENT.register(GridEffectHandler::onUseBlockTillOrPlant);
    }

    private static class_1269 onUseBlockTillOrPlant(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
        if (world.method_8608()) {
            return class_1269.field_5811;
        }
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        if (!ConfigManager.get().grid.enable) {
            return class_1269.field_5811;
        }
        class_1799 tool = player.method_6047();
        if (!(tool.method_7909() instanceof class_1794)) {
            return class_1269.field_5811;
        }
        int gridLevel = GridEffectHandler.getGridLevel(world, tool);
        if (gridLevel <= 0) {
            return class_1269.field_5811;
        }
        class_1799 off = player.method_6079();
        class_1792 seedItem = off.method_7960() ? null : off.method_7909();
        boolean plantableInOffhand = GridEffectHandler.isPlantableSeed(seedItem);
        class_2338 clickPos = hit.method_17777();
        class_2680 clicked = world.method_8320(clickPos);
        boolean clickedFarmland = clicked.method_27852(class_2246.field_10362);
        boolean clickedTillBase = GridEffectHandler.isTillBaseBlock(clicked);
        if (clickedFarmland && plantableInOffhand) {
            AtomicBoolean planted = new AtomicBoolean(false);
            GridEffectHandler.forEach(world, clickPos, tool, pos -> {
                if (GridEffectHandler.tryPlantOnFarmland(world, pos, player, off)) {
                    planted.set(true);
                }
            });
            return planted.get() ? class_1269.field_5812 : class_1269.field_5811;
        }
        if (clickedTillBase) {
            AtomicBoolean didAny = new AtomicBoolean(false);
            AtomicInteger newlyOasis = new AtomicInteger(0);
            int radius = GridEffectHandler.radiusFromLevel(gridLevel);
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    boolean isOrigin;
                    class_2338 pos2 = clickPos.method_10069(dx, 0, dz);
                    boolean bl = isOrigin = dx == 0 && dz == 0;
                    if (!GridEffectHandler.tillOne(pos2, world, player, tool, isOrigin)) continue;
                    didAny.set(true);
                    if (!ConfigManager.get().oasis.autoApplyOnTilling || !OasisEffectHandler.hasOasis(world, tool)) continue;
                    newlyOasis.addAndGet(OasisEffectHandler.tryApplyOasisOn(world, pos2));
                }
            }
            if (plantableInOffhand) {
                GridEffectHandler.forEach(world, clickPos, tool, pos -> {
                    if (GridEffectHandler.tryPlantOnFarmland(world, pos, player, off)) {
                        didAny.set(true);
                    }
                });
            }
            if (newlyOasis.get() > 0 && !player.method_31549().field_7477 && tool.method_7963()) {
                tool.method_7970(3 * newlyOasis.get(), (class_1309)player, class_1304.field_6173);
            }
            return didAny.get() ? class_1269.field_5812 : class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    private static boolean isTillBaseBlock(class_2680 state) {
        return state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_10253);
    }

    public static int getGridLevel(class_1937 world, class_1799 tool) {
        if (!ConfigManager.get().grid.enable) {
            return 0;
        }
        class_2378 enchReg = world.method_30349().method_30530(class_7924.field_41265);
        class_6880 grid = enchReg.method_46746(GRID_KEY).orElse(null);
        if (grid == null) {
            return 0;
        }
        class_9304 comp = (class_9304)tool.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        return comp.method_57536(grid);
    }

    public static int radiusFromLevel(int level) {
        return level <= 0 ? 0 : (level == 1 ? 1 : 2);
    }

    public static void forEach(class_1937 world, class_2338 center, class_1799 tool, Consumer<class_2338> action) {
        int r = GridEffectHandler.radiusFromLevel(GridEffectHandler.getGridLevel(world, tool));
        if (r == 0) {
            action.accept(center);
            return;
        }
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                action.accept(center.method_10069(dx, 0, dz));
            }
        }
    }

    private static boolean tillOne(class_2338 pos, class_1937 world, class_1657 player, class_1799 tool, boolean isOrigin) {
        class_2680 state = world.method_8320(pos);
        if (state.method_27852(class_2246.field_10362)) {
            return false;
        }
        class_2338 abovePos = pos.method_10084();
        class_2680 above = world.method_8320(abovePos);
        if (!(isOrigin || above.method_26215() || GridEffectHandler.isSoftVegetation(above))) {
            return false;
        }
        if (!above.method_26215() && GridEffectHandler.isSoftVegetation(above) && !world.method_8608()) {
            world.method_8651(abovePos, true, (class_1297)player);
        }
        if (state.method_27852(class_2246.field_10253)) {
            world.method_8652(pos, class_2246.field_10566.method_9564(), 11);
            GridEffectHandler.playTillFeedback(world, pos, player, tool);
            return true;
        }
        if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10194)) {
            world.method_8652(pos, class_2246.field_10362.method_9564(), 11);
            GridEffectHandler.playTillFeedback(world, pos, player, tool);
            return true;
        }
        return false;
    }

    private static boolean tryPlantOnFarmland(class_1937 world, class_2338 farmlandPos, class_1657 player, class_1799 offhand) {
        if (offhand.method_7960()) {
            return false;
        }
        if (!world.method_8320(farmlandPos).method_27852(class_2246.field_10362)) {
            return false;
        }
        class_2338 plantPos = farmlandPos.method_10084();
        if (!world.method_8320(plantPos).method_26215()) {
            return false;
        }
        class_2680 plant = GridEffectHandler.plantStateFor(offhand.method_7909());
        if (plant == null) {
            return false;
        }
        world.method_8652(plantPos, plant, 11);
        world.method_8396(null, plantPos, class_3417.field_17611, class_3419.field_15245, 1.0f, 1.0f);
        if (!player.method_31549().field_7477) {
            offhand.method_7934(1);
        }
        return true;
    }

    private static boolean isPlantableSeed(class_1792 item) {
        if (item == null) {
            return false;
        }
        return item == class_1802.field_8317 || item == class_1802.field_8309 || item == class_1802.field_8179 || item == class_1802.field_8567 || item == class_1802.field_42711 || item == class_1802.field_43195;
    }

    private static class_2680 plantStateFor(class_1792 item) {
        if (item == class_1802.field_8317) {
            return GridEffectHandler.age0(class_2246.field_10293);
        }
        if (item == class_1802.field_8309) {
            return GridEffectHandler.age0(class_2246.field_10341);
        }
        if (item == class_1802.field_8179) {
            return GridEffectHandler.age0(class_2246.field_10609);
        }
        if (item == class_1802.field_8567) {
            return GridEffectHandler.age0(class_2246.field_10247);
        }
        if (item == class_1802.field_42711) {
            return GridEffectHandler.age0(class_2246.field_42749);
        }
        if (item == class_1802.field_43195) {
            return GridEffectHandler.age0(class_2246.field_43228);
        }
        return null;
    }

    private static class_2680 age0(class_2248 block) {
        class_2680 class_26802;
        if (block instanceof class_2302) {
            class_2302 c = (class_2302)block;
            class_26802 = c.method_9828(0);
        } else {
            class_26802 = block.method_9564();
        }
        return class_26802;
    }

    private static void playTillFeedback(class_1937 world, class_2338 pos, class_1657 player, class_1799 tool) {
        world.method_8396(null, pos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
        if (!player.method_31549().field_7477 && tool.method_7963()) {
            tool.method_7970(1, (class_1309)player, class_1304.field_6173);
        }
    }

    private static boolean isSoftVegetation(class_2680 s) {
        if (s.method_26204() instanceof class_2261 || s.method_26204() instanceof class_2320) {
            return true;
        }
        if (s.method_26164(class_3481.field_15480)) {
            return true;
        }
        if (s.method_26164(TAG_TALL_FLOWERS)) {
            return true;
        }
        if (s.method_26164(TAG_REPLACEABLE_PLANTS)) {
            return true;
        }
        return s.method_27852(class_2246.field_10477);
    }
}

