/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;

public final class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "farmerenchants.json";
    private static ModConfig CONFIG = new ModConfig();

    private ConfigManager() {
    }

    public static ModConfig get() {
        return CONFIG;
    }

    private static Path path() {
        return FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
    }

    public static void load() {
        Path p = ConfigManager.path();
        if (Files.notExists(p, new LinkOption[0])) {
            ConfigManager.save();
            return;
        }
        try (BufferedReader br = Files.newBufferedReader(p);){
            String raw = br.lines().collect(Collectors.joining("\n"));
            String clean = ConfigManager.stripJsonComments(raw);
            ModConfig read = (ModConfig)GSON.fromJson(clean, ModConfig.class);
            if (read != null) {
                CONFIG = read;
            }
        }
        catch (IOException e) {
            ConfigManager.save();
        }
    }

    public static void save() {
        Path p = ConfigManager.path();
        try {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            try (BufferedWriter bw = Files.newBufferedWriter(p, new OpenOption[0]);){
                ConfigManager.writeConfigWithComments(bw, CONFIG);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeConfigWithComments(BufferedWriter bw, ModConfig c) throws IOException {
        bw.write("{\n");
        bw.write("  \"autosow\": {\n");
        bw.write("    // enable: master switch for Autosow Enchant\n");
        bw.write("    \"enable\": " + c.autosow.enable + ",\n");
        bw.write("    // requireSeeds: seeds must be in inventory to replant\n");
        bw.write("    \"requireSeeds\": " + c.autosow.requireSeeds + ",\n");
        bw.write("    // enableFortuneMultiplier: extra drops scale with Fortune\n");
        bw.write("    \"enableFortuneMultiplier\": " + c.autosow.enableFortuneMultiplier + "\n");
        bw.write("  },\n");
        bw.write("  \"collector\": {\n");
        bw.write("    // enable: master switch for Collector Enchant\n");
        bw.write("    \"enable\": " + c.collector.enable + "\n");
        bw.write("  },\n");
        bw.write("  \"fertility\": {\n");
        bw.write("    // enable: master switch for Fertility Enchant\n");
        bw.write("    \"enable\": " + c.fertility.enable + "\n");
        bw.write("  },\n");
        bw.write("  \"grid\": {\n");
        bw.write("    // enable: master switch for Grid Enchant\n");
        bw.write("    \"enable\": " + c.grid.enable + "\n");
        bw.write("  },\n");
        bw.write("  \"oasis\": {\n");
        bw.write("    // enable: master switch for Oasis Enchant\n");
        bw.write("    \"enable\": " + c.oasis.enable + ",\n");
        bw.write("    // autoApplyOnTilling: auto-apply Oasis on freshly tilled farmland (incl. Grid)\n");
        bw.write("    \"autoApplyOnTilling\": " + c.oasis.autoApplyOnTilling + "\n");
        bw.write("  },\n");
        bw.write("  \"big_house\": {\n");
        bw.write("    // enable: master switch for Big House Enchant\n");
        bw.write("    \"enable\": " + c.big_house.enable + "\n");
        bw.write("  },\n");
        bw.write("  \"honey_overflow\": {\n");
        bw.write("    // enable: master switch for Honey Overflow Enchant\n");
        bw.write("    \"enable\": " + c.honey_overflow.enable + "\n");
        bw.write("  },\n");
        bw.write("  \"farmland\": {\n");
        bw.write("    // feather_falling_protects_crops: if true, Feather Falling boots prevent trampling crops\n");
        bw.write("    \"feather_falling_protects_crops\": " + c.farmland.feather_falling_protects_crops + "\n");
        bw.write("  },\n");
        bw.write("  \"composter\": {\n");
        bw.write("    // fortune_1: cashouts needed for Fortune I on the composter\n");
        bw.write("    \"fortune_1\": " + c.composter.fortune_1 + ",\n");
        bw.write("    // bio_boost: cashouts needed to unlock Bio Boost\n");
        bw.write("    \"bio_boost\": " + c.composter.bio_boost + ",\n");
        bw.write("    // fortune_2: cashouts needed for Fortune II\n");
        bw.write("    \"fortune_2\": " + c.composter.fortune_2 + ",\n");
        bw.write("    // magic_pot: cashouts needed to unlock Magic Pot\n");
        bw.write("    \"magic_pot\": " + c.composter.magic_pot + ",\n");
        bw.write("    // fortune_3: cashouts needed for Fortune III (also used as default max cap)\n");
        bw.write("    \"fortune_3\": " + c.composter.fortune_3 + "\n");
        bw.write("  }\n");
        bw.write("}\n");
    }

    private static String stripJsonComments(String src) {
        StringBuilder out = new StringBuilder(src.length());
        boolean inString = false;
        boolean esc = false;
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (inString) {
                out.append(c);
                if (esc) {
                    esc = false;
                    continue;
                }
                if (c == '\\') {
                    esc = true;
                    continue;
                }
                if (c != '\"') continue;
                inString = false;
                continue;
            }
            if (c == '\"') {
                inString = true;
                out.append(c);
                continue;
            }
            if (c == '/' && i + 1 < src.length() && src.charAt(i + 1) == '/') {
                i += 2;
                while (i < src.length() && src.charAt(i) != '\n') {
                    ++i;
                }
                out.append('\n');
                continue;
            }
            if (c == '/' && i + 1 < src.length() && src.charAt(i + 1) == '*') {
                i += 2;
                while (i + 1 < src.length() && (src.charAt(i) != '*' || src.charAt(i + 1) != '/')) {
                    ++i;
                }
                ++i;
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static final class ModConfig {
        public Autosow autosow = new Autosow();
        public Collector collector = new Collector();
        public Fertility fertility = new Fertility();
        public Grid grid = new Grid();
        public Oasis oasis = new Oasis();
        public BigHouse big_house = new BigHouse();
        public Storage honey_overflow = new Storage();
        public Farmland farmland = new Farmland();
        public Composter composter = new Composter();

        public static final class Autosow {
            public boolean enable = true;
            public boolean requireSeeds = true;
            public boolean enableFortuneMultiplier = true;
        }

        public static final class Collector {
            public boolean enable = true;
        }

        public static final class Fertility {
            public boolean enable = true;
        }

        public static final class Grid {
            public boolean enable = true;
        }

        public static final class Oasis {
            public boolean enable = true;
            public boolean autoApplyOnTilling = false;
        }

        public static final class BigHouse {
            public boolean enable = true;
        }

        public static final class Storage {
            public boolean enable = true;
        }

        public static final class Farmland {
            public boolean feather_falling_protects_crops = true;
        }

        public static final class Composter {
            public int fortune_1 = 20;
            public int bio_boost = 50;
            public int fortune_2 = 100;
            public int magic_pot = 180;
            public int fortune_3 = 250;
        }
    }
}

