/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.composter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.ArrayList;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_26;
import net.minecraft.class_3218;

public final class ComposterUsageState
extends class_18 {
    private static final int MAX_COUNT = 250;
    private final Long2IntOpenHashMap map = new Long2IntOpenHashMap();
    public static final Codec<Entry> ENTRY_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.LONG.fieldOf("pos").forGetter(Entry::pos), (App)Codec.INT.fieldOf("count").forGetter(Entry::count)).apply((Applicative)i, Entry::new));
    public static final Codec<ComposterUsageState> CODEC = RecordCodecBuilder.create(i -> i.group((App)ENTRY_CODEC.listOf().fieldOf("entries").forGetter(state -> {
        ArrayList<Entry> out = new ArrayList<Entry>(state.map.size());
        for (Long2IntMap.Entry e : state.map.long2IntEntrySet()) {
            out.add(new Entry(e.getLongKey(), e.getIntValue()));
        }
        return out;
    })).apply((Applicative)i, entries -> {
        ComposterUsageState s = new ComposterUsageState();
        for (Entry e : entries) {
            int v = e.count();
            if (v <= 0) continue;
            if (v > 250) {
                v = 250;
            }
            s.map.put(e.pos(), v);
        }
        return s;
    }));
    public static final class_10741<ComposterUsageState> TYPE = new class_10741("composter_usage_state", ctx -> new ComposterUsageState(), ctx -> CODEC, null);

    public int get(class_2338 pos) {
        return this.map.get(pos.method_10063());
    }

    public void set(class_2338 pos, int value) {
        long key = pos.method_10063();
        if (value <= 0) {
            if (this.map.remove(key) != 0) {
                this.method_80();
            }
        } else {
            if (value > 250) {
                value = 250;
            }
            this.map.put(key, value);
            this.method_80();
        }
    }

    public int incrementAndGet(class_2338 pos) {
        long key = pos.method_10063();
        int current = this.map.get(key);
        if (current >= 250) {
            return current;
        }
        int next = current + 1;
        if (next > 250) {
            next = 250;
        }
        this.map.put(key, next);
        this.method_80();
        return next;
    }

    public void clear(class_2338 pos) {
        long key = pos.method_10063();
        if (this.map.remove(key) != 0) {
            this.method_80();
        }
    }

    public static ComposterUsageState get(class_3218 world) {
        class_26 mgr = world.method_17983();
        return (ComposterUsageState)mgr.method_17924(TYPE);
    }

    public String toString() {
        return "ComposterUsageState[" + this.map.size() + " entries]";
    }

    public record Entry(long pos, int count) {
    }
}

