/*
 * Decompiled with CFR 0.152.
 */
package com.example.rtp999;

import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class EconomyIntegration {
    private final JavaPlugin plugin;
    private Economy economy = null;
    private boolean enabled = false;

    public EconomyIntegration(JavaPlugin plugin) {
        this.plugin = plugin;
        if (plugin.getServer().getPluginManager().getPlugin("Vault") != null) {
            this.setupEconomy();
            if (this.economy != null) {
                this.enabled = true;
                plugin.getLogger().info("Vault found and economy support is enabled.");
            } else {
                plugin.getLogger().warning("Vault found, but no economy plugin was detected. Economy features disabled.");
            }
        } else {
            plugin.getLogger().info("Vault not found. Economy features are disabled.");
        }
    }

    private void setupEconomy() {
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return;
        }
        this.economy = (Economy)rsp.getProvider();
    }

    public boolean isEnabled() {
        return this.enabled && this.economy != null;
    }

    public boolean hasEnough(Player player, double amount) {
        if (!this.isEnabled()) {
            return true;
        }
        return this.economy.has((OfflinePlayer)player, amount);
    }

    public boolean charge(Player player, double amount) {
        if (!this.isEnabled() || amount <= 0.0) {
            return true;
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)player, amount);
        return response.transactionSuccess();
    }

    public String format(double amount) {
        if (!this.isEnabled()) {
            return String.valueOf(amount);
        }
        return this.economy.format(amount);
    }

    public double getBalance(Player player) {
        if (!this.isEnabled()) {
            return 0.0;
        }
        return this.economy.getBalance((OfflinePlayer)player);
    }
}

