/*
 * Decompiled with CFR 0.152.
 */
package com.example.rtp999;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class Messages {
    private final Map<String, String> messageMap = new HashMap<String, String>();
    private String prefix;

    public void load(ConfigurationSection section) {
        this.messageMap.clear();
        this.prefix = this.format(section.getString("prefix", "&7[&6RTP999&7] "));
        for (String key : section.getKeys(false)) {
            if (key.equals("prefix")) continue;
            this.messageMap.put(key, section.getString(key));
        }
    }

    public void send(CommandSender sender, String key, String ... replacements) {
        String message = this.messageMap.get(key);
        if (message == null || message.isEmpty()) {
            return;
        }
        for (int i = 0; i < replacements.length; i += 2) {
            message = message.replace("{" + replacements[i] + "}", replacements[i + 1]);
        }
        sender.sendMessage(this.prefix + this.format(message));
    }

    public void sendNoPrefix(CommandSender sender, String key, String ... replacements) {
        String message = this.messageMap.get(key);
        if (message == null || message.isEmpty()) {
            return;
        }
        for (int i = 0; i < replacements.length; i += 2) {
            message = message.replace("{" + replacements[i] + "}", replacements[i + 1]);
        }
        sender.sendMessage(this.format(message));
    }

    private String format(String message) {
        if (message == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

