/*
 * Decompiled with CFR 0.152.
 */
package com.example.rtp999;

import com.example.rtp999.EconomyIntegration;
import com.example.rtp999.Messages;
import com.example.rtp999.WorldGuardIntegration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class RTP999
extends JavaPlugin
implements CommandExecutor,
Listener {
    private ConfigData globalDefaults;
    private final Map<String, ConfigData> worldConfigs = new HashMap<String, ConfigData>();
    private Set<String> defaultDisabledWorlds;
    private final Set<Material> unsafeBlocks = new HashSet<Material>();
    private final Set<Material> solidBlocks = new HashSet<Material>();
    private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Location> lastTeleportLocations = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, BukkitTask> warmupTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    private final Map<UUID, Location> warmupLocations = new ConcurrentHashMap<UUID, Location>();
    private WorldGuardIntegration worldGuardIntegration;
    private EconomyIntegration economyIntegration;
    private final Messages messages = new Messages();
    private final String worldSelectionGuiTitle = String.valueOf(ChatColor.DARK_BLUE) + "Select a World to RTP";

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.initializeBlockSets();
        this.worldGuardIntegration = new WorldGuardIntegration();
        this.economyIntegration = new EconomyIntegration(this);
        this.getCommand("rtp").setExecutor((CommandExecutor)this);
        this.getCommand("rtp999").setExecutor((CommandExecutor)this);
        this.getCommand("rtpworlds").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("RTP999 enabled successfully.");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        config.options().copyDefaults(true);
        this.saveConfig();
        this.messages.load(config.getConfigurationSection("messages"));
        this.globalDefaults = this.loadConfigData(config, null);
        this.defaultDisabledWorlds = new HashSet<String>(config.getStringList("disabled-worlds"));
        this.worldConfigs.clear();
        ConfigurationSection worldsSection = config.getConfigurationSection("worlds");
        if (worldsSection != null) {
            for (String worldName : worldsSection.getKeys(false)) {
                ConfigurationSection wSec = worldsSection.getConfigurationSection(worldName);
                if (wSec == null) continue;
                this.worldConfigs.put(worldName, this.loadConfigData(config, worldName));
            }
        }
    }

    private ConfigData loadConfigData(FileConfiguration config, String worldName) {
        FileConfiguration section;
        Object object = section = worldName == null ? config : config.getConfigurationSection("worlds." + worldName);
        if (section == null) {
            return this.globalDefaults;
        }
        ConfigData data = new ConfigData();
        data.enabled = section.getBoolean("enabled", true);
        data.range = section.getInt("range", this.globalDefaults.range);
        data.maxAttempts = section.getInt("max-attempts", this.globalDefaults.maxAttempts);
        data.cooldownSeconds = section.getInt("cooldown-seconds", this.globalDefaults.cooldownSeconds);
        data.minYLevel = section.getInt("min-y-level", this.globalDefaults.minYLevel);
        data.checkCaves = section.getBoolean("check-caves", this.globalDefaults.checkCaves);
        data.allowNether = section.getBoolean("allow-nether", this.globalDefaults.allowNether);
        data.allowEnd = section.getBoolean("allow-end", this.globalDefaults.allowEnd);
        data.warmupSeconds = section.getInt("warm-up-seconds", this.globalDefaults.warmupSeconds);
        data.shape = section.getString("shape", this.globalDefaults.shape);
        data.minTeleportDistance = section.getInt("min-teleport-distance", this.globalDefaults.minTeleportDistance);
        data.economyEnabled = section.getBoolean("economy.enabled", config.getBoolean("economy.enabled", false));
        data.economyCost = section.getDouble("economy.cost", config.getDouble("economy.cost", 100.0));
        data.worldGuardEnabled = section.getBoolean("worldguard.enabled", config.getBoolean("worldguard.enabled", false));
        data.worldGuardMode = section.getString("worldguard.mode", config.getString("worldguard.mode", "allow"));
        data.worldGuardRegions = section.getStringList("worldguard.regions");
        if (data.worldGuardRegions.isEmpty()) {
            data.worldGuardRegions = config.getStringList("worldguard.regions");
        }
        data.biomeMode = section.getString("biomes.mode", config.getString("biomes.mode", "blacklist"));
        data.biomeList = new HashSet<String>(section.getStringList("biomes.list"));
        if (data.biomeList.isEmpty()) {
            data.biomeList.addAll(config.getStringList("biomes.list"));
        }
        return data;
    }

    private void initializeBlockSets() {
        Collections.addAll(this.unsafeBlocks, Material.LAVA, Material.WATER, Material.CACTUS, Material.FIRE, Material.SOUL_FIRE, Material.MAGMA_BLOCK, Material.POWDER_SNOW, Material.SWEET_BERRY_BUSH, Material.COBWEB, Material.VINE, Material.TRIPWIRE, Material.TRIPWIRE_HOOK, Material.SCAFFOLDING, Material.WITHER_ROSE, Material.POINTED_DRIPSTONE);
        Collections.addAll(this.solidBlocks, Material.GRASS_BLOCK, Material.DIRT, Material.STONE, Material.SAND, Material.GRAVEL, Material.COBBLESTONE, Material.OAK_PLANKS, Material.BEDROCK, Material.NETHERRACK, Material.END_STONE, Material.TERRACOTTA, Material.CLAY, Material.SANDSTONE, Material.MYCELIUM, Material.PODZOL, Material.DEEPSLATE, Material.BLACKSTONE, Material.BASALT, Material.SOUL_SAND, Material.SOUL_SOIL, Material.CRIMSON_NYLIUM, Material.WARPED_NYLIUM, Material.OBSIDIAN);
    }

    private ConfigData getConfigForWorld(String worldName) {
        return this.worldConfigs.getOrDefault(worldName, this.globalDefaults);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("rtp999")) {
            this.handleAdminCommand(sender, args);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("rtpworlds")) {
            this.handleRtpWorldsCommand(sender);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("rtp")) {
            this.handleRtpCommand(sender, args);
            return true;
        }
        return false;
    }

    private void handleAdminCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("rtp.admin")) {
            this.messages.send(sender, "no_permission", new String[0]);
            return;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            this.reloadConfig();
            this.loadConfig();
            this.messages.send(sender, "config_reloaded", new String[0]);
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand. Use /rtp999 reload");
        }
    }

    private void handleRtpWorldsCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.messages.send(sender, "only_players", new String[0]);
            return;
        }
        if (!sender.hasPermission("rtp.worlds")) {
            this.messages.send(sender, "no_permission", new String[0]);
            return;
        }
        this.openWorldSelectionGUI((Player)sender);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleRtpCommand(CommandSender sender, String[] args) {
        Player targetPlayer = null;
        World targetWorld = null;
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                this.messages.send(sender, "only_players", new String[0]);
                return;
            }
            targetPlayer = (Player)sender;
            targetWorld = targetPlayer.getWorld();
        } else if (args.length == 1) {
            if (!(sender instanceof Player)) {
                this.messages.send(sender, "only_players", new String[0]);
                return;
            }
            World world = Bukkit.getWorld((String)args[0]);
            if (world != null && sender.hasPermission("rtp.world")) {
                targetPlayer = (Player)sender;
                targetWorld = world;
            } else {
                if (!sender.hasPermission("rtp.teleport.other")) {
                    this.messages.send(sender, "no_permission_other", new String[0]);
                    return;
                }
                Player player = Bukkit.getPlayer((String)args[0]);
                if (player == null) {
                    this.messages.send(sender, "player_not_found", "player", args[0]);
                    return;
                }
                targetPlayer = player;
                targetWorld = player.getWorld();
            }
        } else if (args.length >= 2) {
            if (!sender.hasPermission("rtp.teleport.other")) {
                this.messages.send(sender, "no_permission_other", new String[0]);
                return;
            }
            targetPlayer = Bukkit.getPlayer((String)args[0]);
            targetWorld = Bukkit.getWorld((String)args[1]);
            if (targetPlayer == null) {
                this.messages.send(sender, "player_not_found", "player", args[0]);
                return;
            }
            if (targetWorld == null) {
                this.messages.send(sender, "world_not_found", "world", args[1]);
                return;
            }
        }
        if (targetPlayer == null || targetWorld == null) {
            this.messages.send(sender, "teleport_fail", new String[0]);
            return;
        }
        if (targetPlayer.equals((Object)sender) && !sender.hasPermission("rtp.use")) {
            this.messages.send(sender, "no_permission", new String[0]);
            return;
        }
        this.requestTeleport(targetPlayer, targetWorld, sender);
    }

    public void requestTeleport(final Player player, final World world, CommandSender requester) {
        if (this.warmupTasks.containsKey(player.getUniqueId())) {
            this.messages.send(requester, "warmup", new String[0]);
            return;
        }
        String worldName = world.getName();
        final ConfigData config = this.getConfigForWorld(worldName);
        if (!config.enabled || this.defaultDisabledWorlds.contains(worldName)) {
            this.messages.send(requester, "rtp_disabled_world", new String[0]);
            return;
        }
        World.Environment env = world.getEnvironment();
        if (env == World.Environment.NETHER && !config.allowNether) {
            this.messages.send(requester, "nether_disabled", new String[0]);
            return;
        }
        if (env == World.Environment.THE_END && !config.allowEnd) {
            this.messages.send(requester, "end_disabled", new String[0]);
            return;
        }
        final UUID uuid = player.getUniqueId();
        if (this.cooldowns.containsKey(uuid)) {
            long cooldownMs;
            long lastTeleport = this.cooldowns.get(uuid);
            long elapsed = System.currentTimeMillis() - lastTeleport;
            if (elapsed < (cooldownMs = (long)config.cooldownSeconds * 1000L)) {
                long remaining = (cooldownMs - elapsed) / 1000L;
                this.messages.send(requester, "cooldown", "time", String.valueOf(remaining));
                return;
            }
        }
        if (config.economyEnabled && this.economyIntegration.isEnabled() && config.economyCost > 0.0 && !this.economyIntegration.hasEnough(player, config.economyCost)) {
            this.messages.send((CommandSender)player, "not_enough_money", "cost", this.economyIntegration.format(config.economyCost), "balance", this.economyIntegration.format(this.economyIntegration.getBalance(player)));
            return;
        }
        if (config.warmupSeconds > 0) {
            this.messages.send((CommandSender)player, "warmup", "time", String.valueOf(config.warmupSeconds));
            this.warmupLocations.put(uuid, player.getLocation());
            BukkitTask task = new BukkitRunnable(){

                public void run() {
                    RTP999.this.warmupTasks.remove(uuid);
                    RTP999.this.warmupLocations.remove(uuid);
                    RTP999.this.initiateTeleport(player, world, config);
                }
            }.runTaskLater((Plugin)this, (long)config.warmupSeconds * 20L);
            this.warmupTasks.put(uuid, task);
        } else {
            this.initiateTeleport(player, world, config);
        }
    }

    private void initiateTeleport(final Player player, final World world, final ConfigData config) {
        if (config.economyEnabled && this.economyIntegration.isEnabled() && config.economyCost > 0.0) {
            if (this.economyIntegration.charge(player, config.economyCost)) {
                this.messages.send((CommandSender)player, "payment_success", "cost", this.economyIntegration.format(config.economyCost));
            } else {
                this.messages.send((CommandSender)player, "not_enough_money", "cost", this.economyIntegration.format(config.economyCost), "balance", this.economyIntegration.format(this.economyIntegration.getBalance(player)));
                return;
            }
        }
        this.messages.send((CommandSender)player, "teleport_success", new String[0]);
        final Location searchOrigin = player.getWorld().equals((Object)world) ? player.getLocation() : world.getSpawnLocation();
        final Location lastLoc = this.lastTeleportLocations.get(player.getUniqueId());
        new BukkitRunnable(){

            public void run() {
                final Location safeLoc = RTP999.this.findSafeLocation(searchOrigin, world, config, lastLoc);
                new BukkitRunnable(){

                    public void run() {
                        if (safeLoc != null) {
                            RTP999.this.completeTeleport(player, safeLoc);
                        } else {
                            RTP999.this.messages.send((CommandSender)player, "teleport_fail", new String[0]);
                        }
                    }
                }.runTask((Plugin)RTP999.this);
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private Location findSafeLocation(Location origin, World world, ConfigData config, Location lastLoc) {
        int attempts = 0;
        while (attempts < config.maxAttempts) {
            int y;
            double distanceSq;
            int z;
            int x;
            ++attempts;
            if (config.shape.equalsIgnoreCase("square")) {
                int halfRange = config.range / 2;
                x = origin.getBlockX() + ThreadLocalRandom.current().nextInt(-halfRange, halfRange + 1);
                z = origin.getBlockZ() + ThreadLocalRandom.current().nextInt(-halfRange, halfRange + 1);
            } else {
                double angle = ThreadLocalRandom.current().nextDouble(0.0, Math.PI * 2);
                int radius = ThreadLocalRandom.current().nextInt(config.range + 1);
                x = origin.getBlockX() + (int)(Math.cos(angle) * (double)radius);
                z = origin.getBlockZ() + (int)(Math.sin(angle) * (double)radius);
            }
            if (lastLoc != null && config.minTeleportDistance > 0 && lastLoc.getWorld().equals((Object)world) && (distanceSq = lastLoc.distanceSquared(new Location(world, (double)x, lastLoc.getY(), (double)z))) < (double)(config.minTeleportDistance * config.minTeleportDistance)) continue;
            Biome biome = world.getBiome(x, z);
            String biomeName = biome.name();
            if (config.biomeMode.equalsIgnoreCase("whitelist") && !config.biomeList.contains(biomeName) || config.biomeMode.equalsIgnoreCase("blacklist") && config.biomeList.contains(biomeName) || (world.getEnvironment() != World.Environment.NETHER ? (y = world.getHighestBlockYAt(x, z)) < config.minYLevel : (y = this.findSafeYInNether(world, x, z, config.minYLevel)) == -1)) continue;
            Location loc = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
            if (!this.isLocationSafe(loc) || config.checkCaves && this.isCave(loc) || this.worldGuardIntegration.isEnabled() && config.worldGuardEnabled && !this.worldGuardIntegration.isLocationValid(loc, config.worldGuardMode, config.worldGuardRegions)) continue;
            return loc;
        }
        return null;
    }

    private int findSafeYInNether(World world, int x, int z, int minY) {
        for (int y = 120; y >= minY; --y) {
            Block ground = world.getBlockAt(x, y - 1, z);
            if (!this.isSolidSafeGround(ground)) continue;
            Block feet = world.getBlockAt(x, y, z);
            Block head = world.getBlockAt(x, y + 1, z);
            if (!this.isSafeAir(feet) || !this.isSafeAir(head)) continue;
            return y;
        }
        return -1;
    }

    private boolean isLocationSafe(Location loc) {
        Block feet = loc.getBlock();
        Block head = feet.getRelative(0, 1, 0);
        Block ground = feet.getRelative(0, -1, 0);
        return this.isSolidSafeGround(ground) && this.isSafeAir(feet) && this.isSafeAir(head);
    }

    private boolean isSafeAir(Block block) {
        return !block.getType().isSolid() && !this.unsafeBlocks.contains(block.getType());
    }

    private boolean isSolidSafeGround(Block block) {
        Material mat = block.getType();
        return this.solidBlocks.contains(mat) || mat.isSolid() && !this.unsafeBlocks.contains(mat);
    }

    private boolean isCave(Location loc) {
        for (int i = 2; i < 10; ++i) {
            if (!loc.clone().add(0.0, (double)i, 0.0).getBlock().getType().isSolid()) continue;
            return true;
        }
        return false;
    }

    private void completeTeleport(Player player, Location loc) {
        UUID uuid = player.getUniqueId();
        this.cooldowns.put(uuid, System.currentTimeMillis());
        this.lastTeleportLocations.put(uuid, loc);
        player.teleport(loc);
        player.setFallDistance(0.0f);
        this.messages.send((CommandSender)player, "teleport_success", new String[0]);
        player.playSound(loc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        player.spawnParticle(Particle.PORTAL, loc, 30);
    }

    private void openWorldSelectionGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)this.worldSelectionGuiTitle);
        for (World world : Bukkit.getWorlds()) {
            String worldName = world.getName();
            ConfigData config = this.getConfigForWorld(worldName);
            if (!config.enabled || this.defaultDisabledWorlds.contains(worldName)) continue;
            ItemStack item = new ItemStack(switch (world.getEnvironment()) {
                case World.Environment.NETHER -> Material.NETHERRACK;
                case World.Environment.THE_END -> Material.END_STONE;
                default -> Material.GRASS_BLOCK;
            });
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.GREEN) + worldName);
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add(String.valueOf(ChatColor.GRAY) + "Click to randomly teleport in this world.");
                lore.add("");
                lore.add(String.valueOf(ChatColor.YELLOW) + "Cooldown: " + String.valueOf(ChatColor.WHITE) + config.cooldownSeconds + "s");
                lore.add(String.valueOf(ChatColor.YELLOW) + "Range: " + String.valueOf(ChatColor.WHITE) + config.range + " blocks");
                if (config.economyEnabled && config.economyCost > 0.0) {
                    lore.add(String.valueOf(ChatColor.YELLOW) + "Cost: " + String.valueOf(ChatColor.WHITE) + this.economyIntegration.format(config.economyCost));
                }
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            gui.addItem(new ItemStack[]{item});
        }
        player.openInventory(gui);
    }

    public void onDisable() {
        this.warmupTasks.values().forEach(BukkitTask::cancel);
        this.warmupTasks.clear();
        this.warmupLocations.clear();
        this.cooldowns.clear();
        this.lastTeleportLocations.clear();
        this.getLogger().info("RTP999 disabled.");
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(this.worldSelectionGuiTitle)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            String worldName = ChatColor.stripColor((String)meta.getDisplayName());
            World world = Bukkit.getWorld((String)worldName);
            if (world != null) {
                player.closeInventory();
                this.requestTeleport(player, world, (CommandSender)player);
            } else {
                this.messages.send((CommandSender)player, "world_not_found", "world", worldName);
            }
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.warmupTasks.containsKey(event.getPlayer().getUniqueId())) {
            Location from = this.warmupLocations.get(event.getPlayer().getUniqueId());
            Location to = event.getTo();
            if (to != null && (from.getBlockX() != to.getBlockX() || from.getBlockY() != to.getBlockY() || from.getBlockZ() != to.getBlockZ())) {
                this.cancelWarmup(event.getPlayer());
            }
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && this.warmupTasks.containsKey((player = (Player)event.getEntity()).getUniqueId())) {
            this.cancelWarmup(player);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.cancelWarmup(event.getPlayer());
        this.cooldowns.remove(event.getPlayer().getUniqueId());
        this.lastTeleportLocations.remove(event.getPlayer().getUniqueId());
    }

    private void cancelWarmup(Player player) {
        UUID uuid = player.getUniqueId();
        BukkitTask task = this.warmupTasks.remove(uuid);
        if (task != null) {
            task.cancel();
            this.warmupLocations.remove(uuid);
            this.messages.send((CommandSender)player, "warmup_cancel", new String[0]);
        }
    }

    private static class ConfigData {
        boolean enabled;
        int range;
        int maxAttempts;
        int cooldownSeconds;
        int minYLevel;
        boolean checkCaves;
        boolean allowNether;
        boolean allowEnd;
        int warmupSeconds;
        String shape;
        int minTeleportDistance;
        boolean economyEnabled;
        double economyCost;
        boolean worldGuardEnabled;
        String worldGuardMode;
        List<String> worldGuardRegions;
        String biomeMode;
        Set<String> biomeList;

        private ConfigData() {
        }
    }
}

