/*
 * Decompiled with CFR 0.152.
 */
package com.example.rtp999;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class WorldGuardIntegration {
    private final boolean enabled = Bukkit.getPluginManager().getPlugin("WorldGuard") != null;

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLocationValid(Location loc, String mode, List<String> regionNames) {
        if (!this.enabled || regionNames == null || regionNames.isEmpty()) {
            return true;
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regions = container.get(BukkitAdapter.adapt((World)loc.getWorld()));
        if (regions == null) {
            return true;
        }
        com.sk89q.worldedit.util.Location wgLoc = BukkitAdapter.adapt((Location)loc);
        BlockVector3 blockVector = BlockVector3.at((int)wgLoc.getBlockX(), (int)wgLoc.getBlockY(), (int)wgLoc.getBlockZ());
        List applicableRegions = regions.getApplicableRegionsIDs(blockVector);
        boolean inRegion = false;
        for (String regionName : regionNames) {
            if (!applicableRegions.contains(regionName)) continue;
            inRegion = true;
            break;
        }
        if (mode.equalsIgnoreCase("allow")) {
            return inRegion;
        }
        if (mode.equalsIgnoreCase("deny")) {
            return !inRegion;
        }
        return true;
    }
}

