/*
 * Decompiled with CFR 0.152.
 */
package skinexpansion_dtn;

import doggytalents.api.events.RegisterCustomDogModelsEvent;
import doggytalents.api.events.RegisterDogSkinJsonPathEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import skinexpansion_dtn.Constants;
import skinexpansion_dtn.ModelLayerLocations;
import skinexpansion_dtn.models.Beowolf;
import skinexpansion_dtn.models.EeveelutionEevee;
import skinexpansion_dtn.models.EeveelutionEspeon;
import skinexpansion_dtn.models.EeveelutionFlareon;
import skinexpansion_dtn.models.EeveelutionGlaceon;
import skinexpansion_dtn.models.EeveelutionJolteon;
import skinexpansion_dtn.models.EeveelutionLeafeon;
import skinexpansion_dtn.models.EeveelutionSylveon;
import skinexpansion_dtn.models.EeveelutionUmbreon;
import skinexpansion_dtn.models.EeveelutionVaporeon;
import skinexpansion_dtn.models.Moonless;
import skinexpansion_dtn.models.Ninetales;
import skinexpansion_dtn.models.Oslo;

@Mod(value="skinexpansion_dtn")
public class DTNCommunitySkinExpansion {
    public DTNCommunitySkinExpansion() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(DTNCommunitySkinExpansion::registeringSkin);
            modEventBus.addListener(DTNCommunitySkinExpansion::registeringSkinJson);
            modEventBus.addListener(DTNCommunitySkinExpansion::registerLayerDefinition);
        });
    }

    public static void registeringSkin(RegisterCustomDogModelsEvent event) {
        event.register(new RegisterCustomDogModelsEvent.DogModelProps.Builder(DTNCommunitySkinExpansion.getRes("beowolf"), ModelLayerLocations.BEOWOLF).withGlowingEyes().withAccessory());
        event.register(new RegisterCustomDogModelsEvent.DogModelProps.Builder(DTNCommunitySkinExpansion.getRes("ninetales"), ModelLayerLocations.NINETALES).withAccessory());
        event.register(new RegisterCustomDogModelsEvent.DogModelProps.Builder(DTNCommunitySkinExpansion.getRes("eeveelution_eevee"), ModelLayerLocations.EEVEELUTION_EEVEE).withAccessory());
        event.register(new RegisterCustomDogModelsEvent.DogModelProps.Builder(DTNCommunitySkinExpansion.getRes("eeveelution_flareon"), ModelLayerLocations.EEVEELUTION_FLAREON).withAccessory());
        event.register(new RegisterCustomDogModelsEvent.DogModelProps.Builder(DTNCommunitySkinExpansion.getRes("eeveelution_vaporeon"), ModelLayerLocations.EEVEELUTION_VAPOREON).withAccessory());
        event.register(new RegisterCustomDogModelsEvent.DogModelProps.Builder(DTNCommunitySkinExpansion.getRes("eeveelution_jolteon"), ModelLayerLocations.EEVEELUTION_JOLTEON).withAccessory());
        event.register(new RegisterCustomDogModelsEvent.DogModelProps.Builder(DTNCommunitySkinExpansion.getRes("eeveelution_espeon"), ModelLayerLocations.EEVEELUTION_ESPEON).withAccessory());
        event.register(new RegisterCustomDogModelsEvent.DogModelProps.Builder(DTNCommunitySkinExpansion.getRes("eeveelution_umbreon"), ModelLayerLocations.EEVEELUTION_UMBREON).withAccessory());
        event.register(new RegisterCustomDogModelsEvent.DogModelProps.Builder(DTNCommunitySkinExpansion.getRes("eeveelution_leafeon"), ModelLayerLocations.EEVEELUTION_LEAFEON).withAccessory());
        event.register(new RegisterCustomDogModelsEvent.DogModelProps.Builder(DTNCommunitySkinExpansion.getRes("eeveelution_glaceon"), ModelLayerLocations.EEVEELUTION_GLACEON).withAccessory());
        event.register(new RegisterCustomDogModelsEvent.DogModelProps.Builder(DTNCommunitySkinExpansion.getRes("eeveelution_sylveon"), ModelLayerLocations.EEVEELUTION_SYLVEON).withAccessory());
        event.register(new RegisterCustomDogModelsEvent.DogModelProps.Builder(DTNCommunitySkinExpansion.getRes("moonless"), ModelLayerLocations.MOONLESS).withGlowingEyes().withAccessory());
        event.register(new RegisterCustomDogModelsEvent.DogModelProps.Builder(DTNCommunitySkinExpansion.getRes("oslo_nanatsu"), ModelLayerLocations.OSLO).withAccessory());
    }

    public static void registeringSkinJson(RegisterDogSkinJsonPathEvent event) {
        event.register(Constants.SKIN_JSON_PATH);
    }

    public static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModelLayerLocations.BEOWOLF, Beowolf::createBodyLayer);
        event.registerLayerDefinition(ModelLayerLocations.NINETALES, Ninetales::createBodyLayer);
        event.registerLayerDefinition(ModelLayerLocations.EEVEELUTION_EEVEE, EeveelutionEevee::createBodyLayer);
        event.registerLayerDefinition(ModelLayerLocations.EEVEELUTION_FLAREON, EeveelutionFlareon::createBodyLayer);
        event.registerLayerDefinition(ModelLayerLocations.EEVEELUTION_VAPOREON, EeveelutionVaporeon::createBodyLayer);
        event.registerLayerDefinition(ModelLayerLocations.EEVEELUTION_JOLTEON, EeveelutionJolteon::createBodyLayer);
        event.registerLayerDefinition(ModelLayerLocations.EEVEELUTION_ESPEON, EeveelutionEspeon::createBodyLayer);
        event.registerLayerDefinition(ModelLayerLocations.EEVEELUTION_UMBREON, EeveelutionUmbreon::createBodyLayer);
        event.registerLayerDefinition(ModelLayerLocations.EEVEELUTION_LEAFEON, EeveelutionLeafeon::createBodyLayer);
        event.registerLayerDefinition(ModelLayerLocations.EEVEELUTION_GLACEON, EeveelutionGlaceon::createBodyLayer);
        event.registerLayerDefinition(ModelLayerLocations.EEVEELUTION_SYLVEON, EeveelutionSylveon::createBodyLayer);
        event.registerLayerDefinition(ModelLayerLocations.MOONLESS, Moonless::createBodyLayer);
        event.registerLayerDefinition(ModelLayerLocations.OSLO, Oslo::createBodyLayer);
    }

    public static ResourceLocation getRes(String name) {
        return new ResourceLocation("skinexpansion_dtn", name);
    }
}

