/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.shaded.fastutil.floats;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import org.oryxel.gfp.shaded.fastutil.doubles.DoubleIterator;
import org.oryxel.gfp.shaded.fastutil.doubles.DoubleIterators;
import org.oryxel.gfp.shaded.fastutil.doubles.DoubleSpliterator;
import org.oryxel.gfp.shaded.fastutil.doubles.DoubleSpliterators;
import org.oryxel.gfp.shaded.fastutil.floats.FloatConsumer;
import org.oryxel.gfp.shaded.fastutil.floats.FloatIterator;
import org.oryxel.gfp.shaded.fastutil.floats.FloatSpliterator;
import org.oryxel.gfp.shaded.fastutil.floats.FloatSpliterators;

public interface FloatIterable
extends Iterable<Float> {
    public FloatIterator iterator();

    default public DoubleIterator doubleIterator() {
        return DoubleIterators.wrap(this.iterator());
    }

    default public FloatSpliterator spliterator() {
        return FloatSpliterators.asSpliteratorUnknownSize(this.iterator(), 0);
    }

    default public DoubleSpliterator doubleSpliterator() {
        return DoubleSpliterators.wrap(this.spliterator());
    }

    default public void forEach(FloatConsumer action) {
        Objects.requireNonNull(action);
        this.iterator().forEachRemaining(action);
    }

    default public void forEach(DoubleConsumer action) {
        Objects.requireNonNull(action);
        this.forEach(action instanceof FloatConsumer ? (FloatConsumer)action : action::accept);
    }

    @Override
    @Deprecated
    default public void forEach(Consumer<? super Float> action) {
        Objects.requireNonNull(action);
        this.forEach(action instanceof FloatConsumer ? (FloatConsumer)action : action::accept);
    }
}

