/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.geyser;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.api.command.CommandSource;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.api.event.bedrock.SessionDisconnectEvent;
import org.geysermc.geyser.api.event.bedrock.SessionLoginEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCommandsEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPostInitializeEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserShutdownEvent;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.DataPalette;
import org.oryxel.gfp.GeyserFloatingPoints;
import org.oryxel.gfp.config.Config;
import org.oryxel.gfp.config.ConfigLoader;
import org.oryxel.gfp.session.CachedSession;

public class GFPExtension
implements Extension {
    public static Config config;
    public static final List<GeyserSession> showPositions;

    @Subscribe
    public void onSessionJoin(SessionLoginEvent event) {
        new CachedSession((GeyserSession)event.connection());
        if (config.showPositionByDefault()) {
            showPositions.add((GeyserSession)event.connection());
        }
    }

    @Subscribe
    public void onSessionLeave(SessionDisconnectEvent event) {
        showPositions.remove((GeyserSession)event.connection());
    }

    @Subscribe
    public void onGeyserPostInitializeEvent(GeyserPostInitializeEvent event) {
        try {
            DataPalette.class.getMethod("createForBlockState", Integer.TYPE, Integer.TYPE);
        }
        catch (Exception exception) {
            GeyserImpl.getInstance().getExtensionManager().disable((Extension)this);
            throw new RuntimeException("Outdated Geyser build!!!!! Please update to at least 9f8bc9db and above!");
        }
        config = ConfigLoader.load(this, GFPExtension.class, Config.class);
        GeyserFloatingPoints.getInstance().init();
    }

    @Subscribe
    public void onGeyserShutdown(GeyserShutdownEvent event) {
        GeyserFloatingPoints.getInstance().terminate();
    }

    @Subscribe
    public void onDefineCommands(GeyserDefineCommandsEvent event) {
        event.register(Command.builder((Extension)this).source(CommandSource.class).name("position").playerOnly(true).bedrockOnly(true).description("Toggle off/on title to show your real position, won't show anything if your current position is in fact real.").executor((source, cmd, args) -> {
            GeyserConnection patt2764$temp = source.connection();
            if (patt2764$temp instanceof GeyserSession) {
                GeyserSession session = (GeyserSession)patt2764$temp;
                if (showPositions.contains(session)) {
                    showPositions.remove(session);
                    source.sendMessage("Stop showing your position!");
                } else {
                    showPositions.add(session);
                    source.sendMessage("Now showing your position!");
                }
            }
        }).build());
    }

    static {
        showPositions = new CopyOnWriteArrayList<GeyserSession>();
    }
}

