/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.protocol.mitm;

import lombok.NonNull;
import org.cloudburstmc.protocol.bedrock.BedrockServerSession;
import org.cloudburstmc.protocol.bedrock.data.AuthoritativeMovementMode;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.StartGamePacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateClientInputLocksPacket;
import org.geysermc.geyser.session.UpstreamSession;
import org.oryxel.gfp.geyser.util.GeyserUtil;
import org.oryxel.gfp.protocol.PacketEvents;
import org.oryxel.gfp.protocol.event.CloudburstPacketEvent;
import org.oryxel.gfp.protocol.listener.BedrockPacketListener;
import org.oryxel.gfp.session.CachedSession;

public final class CloudburstSendListener
extends UpstreamSession {
    private final CachedSession player;
    private final UpstreamSession oldSession;

    public CloudburstSendListener(CachedSession player, BedrockServerSession session, UpstreamSession oldSession) {
        super(session);
        this.player = player;
        this.oldSession = oldSession;
    }

    public void disconnect(String reason) {
        this.oldSession.disconnect(reason);
    }

    public void sendPacket(@NonNull BedrockPacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (packet instanceof UpdateClientInputLocksPacket) {
            return;
        }
        CloudburstPacketEvent event = new CloudburstPacketEvent(this.player, packet);
        for (BedrockPacketListener listener : PacketEvents.getApi().getBedrockListeners()) {
            listener.onPacketSend(event, false);
        }
        if (event.isCancelled()) {
            return;
        }
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof StartGamePacket) {
            StartGamePacket start = (StartGamePacket)bedrockPacket;
            GeyserUtil.hookIntoMCPL(this.player);
            start.setAuthoritativeMovementMode(AuthoritativeMovementMode.SERVER_WITH_REWIND);
            start.setRewindHistorySize(20);
            this.player.runtimeId = start.getRuntimeEntityId();
        }
        this.oldSession.sendPacket(event.getPacket());
        event.getPostTasks().forEach(Runnable::run);
        event.getPostTasks().clear();
    }

    public void sendPacketImmediately(@NonNull BedrockPacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        CloudburstPacketEvent event = new CloudburstPacketEvent(this.player, packet);
        for (BedrockPacketListener listener : PacketEvents.getApi().getBedrockListeners()) {
            listener.onPacketSend(event, true);
        }
        if (event.isCancelled()) {
            return;
        }
        this.oldSession.sendPacketImmediately(event.getPacket());
        event.getPostTasks().forEach(Runnable::run);
        event.getPostTasks().clear();
    }
}

