/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.protocol.mitm;

import java.util.List;
import lombok.Generated;
import org.geysermc.mcprotocollib.network.Session;
import org.geysermc.mcprotocollib.network.event.session.ConnectedEvent;
import org.geysermc.mcprotocollib.network.event.session.DisconnectedEvent;
import org.geysermc.mcprotocollib.network.event.session.PacketErrorEvent;
import org.geysermc.mcprotocollib.network.event.session.PacketSendingEvent;
import org.geysermc.mcprotocollib.network.event.session.SessionAdapter;
import org.geysermc.mcprotocollib.network.event.session.SessionListener;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.oryxel.gfp.protocol.PacketEvents;
import org.oryxel.gfp.protocol.event.MCPLPacketEvent;
import org.oryxel.gfp.protocol.listener.JavaPacketListener;
import org.oryxel.gfp.session.CachedSession;

public class MCPLMiddleListener
extends SessionAdapter {
    private final CachedSession player;
    private final List<SessionListener> listeners;

    public void packetReceived(Session session, Packet packet) {
        MCPLPacketEvent event = new MCPLPacketEvent(this.player, packet);
        for (JavaPacketListener listener : PacketEvents.getApi().getJavaListeners()) {
            listener.packetReceived(event);
        }
        if (!event.isCancelled()) {
            this.listeners.forEach(l -> l.packetReceived(session, event.getPacket()));
        }
        event.getPostTasks().forEach(Runnable::run);
        event.getPostTasks().clear();
    }

    public void packetSending(PacketSendingEvent event) {
        MCPLPacketEvent mcplEvent = new MCPLPacketEvent(this.player, event.getPacket());
        for (JavaPacketListener listener : PacketEvents.getApi().getJavaListeners()) {
            listener.packetSending(mcplEvent);
            event.setPacket(mcplEvent.getPacket());
        }
        event.setCancelled(mcplEvent.isCancelled());
        if (!event.isCancelled()) {
            this.listeners.forEach(l -> l.packetSending(event));
        }
        mcplEvent.getPostTasks().forEach(Runnable::run);
        mcplEvent.getPostTasks().clear();
    }

    public void packetSent(Session session, Packet packet) {
        this.listeners.forEach(l -> l.packetSent(session, packet));
    }

    public void connected(ConnectedEvent event) {
        this.listeners.forEach(l -> l.connected(event));
    }

    public void disconnected(DisconnectedEvent event) {
        this.listeners.forEach(l -> l.disconnected(event));
    }

    public void packetError(PacketErrorEvent event) {
        this.listeners.forEach(l -> l.packetError(event));
    }

    @Generated
    public MCPLMiddleListener(CachedSession player, List<SessionListener> listeners) {
        this.player = player;
        this.listeners = listeners;
    }
}

