/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.shaded.fastutil.chars;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.oryxel.gfp.shaded.fastutil.Size64;
import org.oryxel.gfp.shaded.fastutil.chars.AbstractChar2CharFunction;
import org.oryxel.gfp.shaded.fastutil.chars.AbstractCharCollection;
import org.oryxel.gfp.shaded.fastutil.chars.AbstractCharSet;
import org.oryxel.gfp.shaded.fastutil.chars.Char2CharMap;
import org.oryxel.gfp.shaded.fastutil.chars.Char2CharMaps;
import org.oryxel.gfp.shaded.fastutil.chars.CharCollection;
import org.oryxel.gfp.shaded.fastutil.chars.CharConsumer;
import org.oryxel.gfp.shaded.fastutil.chars.CharIterator;
import org.oryxel.gfp.shaded.fastutil.chars.CharSet;
import org.oryxel.gfp.shaded.fastutil.chars.CharSpliterator;
import org.oryxel.gfp.shaded.fastutil.chars.CharSpliterators;
import org.oryxel.gfp.shaded.fastutil.objects.AbstractObjectSet;
import org.oryxel.gfp.shaded.fastutil.objects.ObjectIterator;
import org.oryxel.gfp.shaded.fastutil.objects.ObjectSpliterator;
import org.oryxel.gfp.shaded.fastutil.objects.ObjectSpliterators;

public abstract class AbstractChar2CharMap
extends AbstractChar2CharFunction
implements Char2CharMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractChar2CharMap() {
    }

    @Override
    public boolean containsKey(char k) {
        Iterator i = this.char2CharEntrySet().iterator();
        while (i.hasNext()) {
            if (((Char2CharMap.Entry)i.next()).getCharKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(char v) {
        Iterator i = this.char2CharEntrySet().iterator();
        while (i.hasNext()) {
            if (((Char2CharMap.Entry)i.next()).getCharValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharSet keySet() {
        return new AbstractCharSet(){

            @Override
            public boolean contains(char k) {
                return AbstractChar2CharMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractChar2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2CharMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Char2CharMap.Entry> i;
                    {
                        this.i = Char2CharMaps.fastIterator(AbstractChar2CharMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Char2CharMap.Entry)this.i.next()).getCharKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(CharConsumer action) {
                        this.i.forEachRemaining((? super E entry) -> action.accept(entry.getCharKey()));
                    }
                };
            }

            @Override
            public CharSpliterator spliterator() {
                return CharSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractChar2CharMap.this), 321);
            }
        };
    }

    @Override
    public CharCollection values() {
        return new AbstractCharCollection(){

            @Override
            public boolean contains(char k) {
                return AbstractChar2CharMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractChar2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2CharMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Char2CharMap.Entry> i;
                    {
                        this.i = Char2CharMaps.fastIterator(AbstractChar2CharMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Char2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(CharConsumer action) {
                        this.i.forEachRemaining((? super E entry) -> action.accept(entry.getCharValue()));
                    }
                };
            }

            @Override
            public CharSpliterator spliterator() {
                return CharSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractChar2CharMap.this), 320);
            }
        };
    }

    @Override
    public void putAll(Map<? extends Character, ? extends Character> m) {
        if (m instanceof Char2CharMap) {
            ObjectIterator<Char2CharMap.Entry> i = Char2CharMaps.fastIterator((Char2CharMap)m);
            while (i.hasNext()) {
                Char2CharMap.Entry e = (Char2CharMap.Entry)i.next();
                this.put(e.getCharKey(), e.getCharValue());
            }
        } else {
            int n = m.size();
            Iterator<Map.Entry<? extends Character, ? extends Character>> i = m.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<? extends Character, ? extends Character> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Char2CharMap.Entry> i = Char2CharMaps.fastIterator(this);
        while (n-- != 0) {
            h += ((Char2CharMap.Entry)i.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.char2CharEntrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Char2CharMap.Entry> i = Char2CharMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Char2CharMap.Entry e = (Char2CharMap.Entry)i.next();
            s.append(String.valueOf(e.getCharKey()));
            s.append("=>");
            s.append(String.valueOf(e.getCharValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Char2CharMap.Entry> {
        protected final Char2CharMap map;

        public BasicEntrySet(Char2CharMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Char2CharMap.Entry) {
                Char2CharMap.Entry e = (Char2CharMap.Entry)o;
                char k = e.getCharKey();
                return this.map.containsKey(k) && this.map.get(k) == e.getCharValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k = ((Character)key).charValue();
            Object value = e.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            return this.map.containsKey(k) && this.map.get(k) == ((Character)value).charValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Char2CharMap.Entry) {
                Char2CharMap.Entry e = (Char2CharMap.Entry)o;
                return this.map.remove(e.getCharKey(), e.getCharValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k = ((Character)key).charValue();
            Object value = e.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            char v = ((Character)value).charValue();
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public ObjectSpliterator<Char2CharMap.Entry> spliterator() {
            return ObjectSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this.map), 65);
        }
    }

    public static class BasicEntry
    implements Char2CharMap.Entry {
        protected char key;
        protected char value;

        public BasicEntry() {
        }

        public BasicEntry(Character key, Character value) {
            this.key = key.charValue();
            this.value = value.charValue();
        }

        public BasicEntry(char key, char value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char getCharKey() {
            return this.key;
        }

        @Override
        public char getCharValue() {
            return this.value;
        }

        @Override
        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Char2CharMap.Entry) {
                Char2CharMap.Entry e = (Char2CharMap.Entry)o;
                return this.key == e.getCharKey() && this.value == e.getCharValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            Object value = e.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            return this.key == ((Character)key).charValue() && this.value == ((Character)value).charValue();
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

