/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.shaded.fastutil.floats;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.oryxel.gfp.shaded.fastutil.HashCommon;
import org.oryxel.gfp.shaded.fastutil.Size64;
import org.oryxel.gfp.shaded.fastutil.chars.AbstractCharCollection;
import org.oryxel.gfp.shaded.fastutil.chars.CharCollection;
import org.oryxel.gfp.shaded.fastutil.chars.CharConsumer;
import org.oryxel.gfp.shaded.fastutil.chars.CharIterator;
import org.oryxel.gfp.shaded.fastutil.chars.CharSpliterator;
import org.oryxel.gfp.shaded.fastutil.chars.CharSpliterators;
import org.oryxel.gfp.shaded.fastutil.floats.AbstractFloat2CharFunction;
import org.oryxel.gfp.shaded.fastutil.floats.AbstractFloatSet;
import org.oryxel.gfp.shaded.fastutil.floats.Float2CharMap;
import org.oryxel.gfp.shaded.fastutil.floats.Float2CharMaps;
import org.oryxel.gfp.shaded.fastutil.floats.FloatConsumer;
import org.oryxel.gfp.shaded.fastutil.floats.FloatIterator;
import org.oryxel.gfp.shaded.fastutil.floats.FloatSet;
import org.oryxel.gfp.shaded.fastutil.floats.FloatSpliterator;
import org.oryxel.gfp.shaded.fastutil.floats.FloatSpliterators;
import org.oryxel.gfp.shaded.fastutil.objects.AbstractObjectSet;
import org.oryxel.gfp.shaded.fastutil.objects.ObjectIterator;
import org.oryxel.gfp.shaded.fastutil.objects.ObjectSpliterator;
import org.oryxel.gfp.shaded.fastutil.objects.ObjectSpliterators;

public abstract class AbstractFloat2CharMap
extends AbstractFloat2CharFunction
implements Float2CharMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractFloat2CharMap() {
    }

    @Override
    public boolean containsKey(float k) {
        Iterator i = this.float2CharEntrySet().iterator();
        while (i.hasNext()) {
            if (((Float2CharMap.Entry)i.next()).getFloatKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(char v) {
        Iterator i = this.float2CharEntrySet().iterator();
        while (i.hasNext()) {
            if (((Float2CharMap.Entry)i.next()).getCharValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet keySet() {
        return new AbstractFloatSet(){

            @Override
            public boolean contains(float k) {
                return AbstractFloat2CharMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractFloat2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2CharMap.this.clear();
            }

            @Override
            public FloatIterator iterator() {
                return new FloatIterator(){
                    private final ObjectIterator<Float2CharMap.Entry> i;
                    {
                        this.i = Float2CharMaps.fastIterator(AbstractFloat2CharMap.this);
                    }

                    @Override
                    public float nextFloat() {
                        return ((Float2CharMap.Entry)this.i.next()).getFloatKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(FloatConsumer action) {
                        this.i.forEachRemaining((? super E entry) -> action.accept(entry.getFloatKey()));
                    }
                };
            }

            @Override
            public FloatSpliterator spliterator() {
                return FloatSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractFloat2CharMap.this), 321);
            }
        };
    }

    @Override
    public CharCollection values() {
        return new AbstractCharCollection(){

            @Override
            public boolean contains(char k) {
                return AbstractFloat2CharMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractFloat2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2CharMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Float2CharMap.Entry> i;
                    {
                        this.i = Float2CharMaps.fastIterator(AbstractFloat2CharMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Float2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(CharConsumer action) {
                        this.i.forEachRemaining((? super E entry) -> action.accept(entry.getCharValue()));
                    }
                };
            }

            @Override
            public CharSpliterator spliterator() {
                return CharSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractFloat2CharMap.this), 320);
            }
        };
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Character> m) {
        if (m instanceof Float2CharMap) {
            ObjectIterator<Float2CharMap.Entry> i = Float2CharMaps.fastIterator((Float2CharMap)m);
            while (i.hasNext()) {
                Float2CharMap.Entry e = (Float2CharMap.Entry)i.next();
                this.put(e.getFloatKey(), e.getCharValue());
            }
        } else {
            int n = m.size();
            Iterator<Map.Entry<? extends Float, ? extends Character>> i = m.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<? extends Float, ? extends Character> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Float2CharMap.Entry> i = Float2CharMaps.fastIterator(this);
        while (n-- != 0) {
            h += ((Float2CharMap.Entry)i.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.float2CharEntrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Float2CharMap.Entry> i = Float2CharMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Float2CharMap.Entry e = (Float2CharMap.Entry)i.next();
            s.append(String.valueOf(e.getFloatKey()));
            s.append("=>");
            s.append(String.valueOf(e.getCharValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Float2CharMap.Entry> {
        protected final Float2CharMap map;

        public BasicEntrySet(Float2CharMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Float2CharMap.Entry) {
                Float2CharMap.Entry e = (Float2CharMap.Entry)o;
                float k = e.getFloatKey();
                return this.map.containsKey(k) && this.map.get(k) == e.getCharValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            float k = ((Float)key).floatValue();
            Object value = e.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            return this.map.containsKey(k) && this.map.get(k) == ((Character)value).charValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Float2CharMap.Entry) {
                Float2CharMap.Entry e = (Float2CharMap.Entry)o;
                return this.map.remove(e.getFloatKey(), e.getCharValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            float k = ((Float)key).floatValue();
            Object value = e.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            char v = ((Character)value).charValue();
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public ObjectSpliterator<Float2CharMap.Entry> spliterator() {
            return ObjectSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this.map), 65);
        }
    }

    public static class BasicEntry
    implements Float2CharMap.Entry {
        protected float key;
        protected char value;

        public BasicEntry() {
        }

        public BasicEntry(Float key, Character value) {
            this.key = key.floatValue();
            this.value = value.charValue();
        }

        public BasicEntry(float key, char value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public float getFloatKey() {
            return this.key;
        }

        @Override
        public char getCharValue() {
            return this.value;
        }

        @Override
        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Float2CharMap.Entry) {
                Float2CharMap.Entry e = (Float2CharMap.Entry)o;
                return Float.floatToIntBits(this.key) == Float.floatToIntBits(e.getFloatKey()) && this.value == e.getCharValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            Object value = e.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            return Float.floatToIntBits(this.key) == Float.floatToIntBits(((Float)key).floatValue()) && this.value == ((Character)value).charValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

