/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.packets.client;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.ServerboundLoadingScreenPacketType;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.cloudburstmc.protocol.bedrock.packet.ServerboundLoadingScreenPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityMotionPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetTitlePacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PositionElement;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.player.ClientboundPlayerPositionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundMoveVehiclePacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosRotPacket;
import org.oryxel.gfp.geyser.GFPExtension;
import org.oryxel.gfp.protocol.event.CloudburstPacketEvent;
import org.oryxel.gfp.protocol.event.MCPLPacketEvent;
import org.oryxel.gfp.protocol.listener.BedrockPacketListener;
import org.oryxel.gfp.protocol.listener.JavaPacketListener;
import org.oryxel.gfp.session.CachedSession;
import org.oryxel.gfp.util.MathUtil;

public class ClientPositionPacket
implements BedrockPacketListener,
JavaPacketListener {
    @Override
    public void onPacketReceived(CloudburstPacketEvent event) {
        BedrockPacket motion;
        ServerboundLoadingScreenPacket packet;
        CachedSession session = event.getSession();
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof ServerboundLoadingScreenPacket && (packet = (ServerboundLoadingScreenPacket)bedrockPacket).getType() == ServerboundLoadingScreenPacketType.END_LOADING_SCREEN && Objects.equals(123456987, packet.getLoadingScreenId()) && session.silentDimensionSwitch) {
            session.getSession().setSpawned(true);
            session.silentDimensionSwitch = false;
            motion = new SetEntityMotionPacket();
            motion.setMotion(session.cachedVelocity);
            motion.setRuntimeEntityId(session.runtimeId);
            session.getSession().sendUpstreamPacketImmediately(motion);
        }
        if ((motion = event.getPacket()) instanceof PlayerAuthInputPacket) {
            packet = (PlayerAuthInputPacket)motion;
            session.rotation = packet.getRotation();
            if (!session.getSession().isSpawned() || session.getSession().getUnconfirmedTeleport() != null) {
                return;
            }
            if (session.silentDimensionSwitch) {
                event.setCancelled(true);
                return;
            }
            if (!ClientPositionPacket.isValidMove(packet.getPosition())) {
                return;
            }
            session.cachedVelocity = packet.getDelta();
            if ((session.getOffset().getX() != 0 || session.getOffset().getZ() != 0) && session.getSession().getWorldBorder().isPassingIntoBorderBoundaries(packet.getPosition().add(session.getOffset().toFloat()), true)) {
                event.setCancelled(true);
                return;
            }
            boolean offsetNotZero = session.getOffset().getX() != 0 || session.getOffset().getZ() != 0;
            Vector3i realIntPos = packet.getPosition().down(EntityDefinitions.PLAYER.offset()).toInt().add(session.getOffset());
            if (realIntPos.distance(session.lastRealPosInt) > 0.0f && GFPExtension.showPositions.contains(session.getSession()) && offsetNotZero) {
                SetTitlePacket titlePacket = new SetTitlePacket();
                titlePacket.setType(SetTitlePacket.Type.ACTIONBAR);
                titlePacket.setText("XYZ: " + String.valueOf(realIntPos));
                titlePacket.setXuid("");
                titlePacket.setPlatformOnlineId("");
                session.getSession().sendUpstreamPacket((BedrockPacket)titlePacket);
            }
            session.lastRealPosInt = realIntPos;
            if (Vector3f.from((float)packet.getPosition().getX(), (float)0.0f, (float)packet.getPosition().getZ()).length() < (float)GFPExtension.config.maxPosition()) {
                return;
            }
            double oldPosX = Double.parseDouble(Float.toString(packet.getPosition().getX())) + (double)session.getOffset().getX();
            double oldPosZ = Double.parseDouble(Float.toString(packet.getPosition().getZ())) + (double)session.getOffset().getZ();
            double newPosX = MathUtil.findNewPosition(oldPosX);
            double newPosZ = MathUtil.findNewPosition(oldPosZ);
            event.setCancelled(true);
            Vector3i offset = MathUtil.makeOffsetChunkSafe(Vector3d.from((double)(oldPosX - newPosX), (double)0.0, (double)(oldPosZ - newPosZ)));
            newPosX = oldPosX - (double)offset.getX();
            newPosZ = oldPosZ - (double)offset.getZ();
            session.reOffsetPlayer(newPosX, newPosZ, offset);
        }
    }

    @Override
    public void packetSending(MCPLPacketEvent event) {
        ServerboundMovePlayerPosPacket packet;
        CachedSession session = event.getSession();
        Packet packet2 = event.getPacket();
        if (packet2 instanceof ServerboundMovePlayerPosPacket) {
            packet = (ServerboundMovePlayerPosPacket)packet2;
            event.setPacket((Packet)new ServerboundMovePlayerPosPacket(packet.isOnGround(), packet.isHorizontalCollision(), packet.getX() + (double)session.getOffset().getX(), packet.getY() + (double)session.getOffset().getY(), packet.getZ() + (double)session.getOffset().getZ()));
        }
        if ((packet2 = event.getPacket()) instanceof ServerboundMovePlayerPosRotPacket) {
            packet = (ServerboundMovePlayerPosRotPacket)packet2;
            event.setPacket((Packet)new ServerboundMovePlayerPosRotPacket(packet.isOnGround(), packet.isHorizontalCollision(), packet.getX() + (double)session.getOffset().getX(), packet.getY() + (double)session.getOffset().getY(), packet.getZ() + (double)session.getOffset().getZ(), packet.getYaw(), packet.getPitch()));
        }
        if ((packet2 = event.getPacket()) instanceof ServerboundMoveVehiclePacket) {
            packet = (ServerboundMoveVehiclePacket)packet2;
            event.setPacket((Packet)new ServerboundMoveVehiclePacket(packet.getPosition().add(session.getOffset().toDouble()), packet.getYRot(), packet.getXRot(), packet.isOnGround()));
        }
    }

    @Override
    public void packetReceived(MCPLPacketEvent event) {
        CachedSession session = event.getSession();
        SessionPlayerEntity entity = session.getSession().getPlayerEntity();
        Packet packet = event.getPacket();
        if (packet instanceof ClientboundPlayerPositionPacket) {
            ClientboundPlayerPositionPacket packet2 = (ClientboundPlayerPositionPacket)packet;
            Vector3d pos = packet2.getPosition();
            Vector3f realPlayerPosition = entity.getPosition().add(session.getOffset().toFloat());
            double realX = pos.getX() + (double)(packet2.getRelatives().contains(PositionElement.X) ? realPlayerPosition.getX() : 0.0f);
            double realZ = pos.getZ() + (double)(packet2.getRelatives().contains(PositionElement.Z) ? realPlayerPosition.getZ() : 0.0f);
            double newX = realX;
            double newZ = realZ;
            int maxValue = GFPExtension.config.maxPosition();
            if (Math.abs(newX) > (double)maxValue) {
                newX = MathUtil.findNewPosition(newX);
            }
            if (Math.abs(newZ) > (double)maxValue) {
                newZ = MathUtil.findNewPosition(newZ);
            }
            Vector3i oldOffset = session.getOffset();
            Vector3i newOffset = MathUtil.makeOffsetChunkSafe(Vector3d.from((double)(realX - newX), (double)0.0, (double)(realZ - newZ)));
            session.setOffset(newOffset);
            if (newOffset.getX() != 0 || newOffset.getZ() != 0) {
                double oldOffsetX = realX - (double)oldOffset.getX();
                double oldOffsetZ = realZ - (double)oldOffset.getZ();
                if (Math.abs(oldOffsetX) <= (double)maxValue && Math.abs(oldOffsetZ) <= (double)maxValue) {
                    session.setOffset(oldOffset);
                }
            }
            newX = realX - (double)session.getOffset().getX();
            newZ = realZ - (double)session.getOffset().getZ();
            ArrayList relatives = new ArrayList();
            packet2.getRelatives().forEach(r -> {
                if (r != PositionElement.X && r != PositionElement.Z) {
                    relatives.add(r);
                }
            });
            event.setPacket((Packet)new ClientboundPlayerPositionPacket(packet2.getId(), newX, packet2.getPosition().getY(), newZ, packet2.getDeltaMovement().getX(), packet2.getDeltaMovement().getY(), packet2.getDeltaMovement().getZ(), packet2.getYRot(), packet2.getXRot(), relatives.toArray(new PositionElement[0])));
            if (oldOffset.getX() == session.getOffset().getX() && oldOffset.getZ() == session.getOffset().getZ()) {
                return;
            }
            if (!session.getSession().isSpawned()) {
                return;
            }
            event.getPostTasks().add(() -> {
                session.getChunkCache().sendChunksWithOffset();
                session.getEntityCache().resendWithOffset();
                session.sendWorldSpawn();
            });
        }
    }

    @Override
    public void onPacketSend(CloudburstPacketEvent event, boolean immediate) {
        SetEntityMotionPacket packet;
        CachedSession session = event.getSession();
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof SetEntityMotionPacket && (packet = (SetEntityMotionPacket)bedrockPacket).getRuntimeEntityId() == session.runtimeId) {
            session.cachedVelocity = packet.getMotion();
        }
    }

    private static boolean isValidMove(Vector3f newPosition) {
        return !ClientPositionPacket.isInvalidNumber(newPosition.getX()) && !ClientPositionPacket.isInvalidNumber(newPosition.getY()) && !ClientPositionPacket.isInvalidNumber(newPosition.getZ());
    }

    private static boolean isInvalidNumber(float val) {
        return Float.isNaN(val) || Float.isInfinite(val);
    }
}

