/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.packets.client;

import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.PlayerActionType;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.PlayerBlockActionData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerAction;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.ClientboundBlockDestructionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundPickItemFromBlockPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundSetCommandBlockPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundSetJigsawBlockPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundSetStructureBlockPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundBlockEntityTagQueryPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundJigsawGeneratePacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundSignUpdatePacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundUseItemOnPacket;
import org.oryxel.gfp.protocol.event.CloudburstPacketEvent;
import org.oryxel.gfp.protocol.event.MCPLPacketEvent;
import org.oryxel.gfp.protocol.listener.BedrockPacketListener;
import org.oryxel.gfp.protocol.listener.JavaPacketListener;
import org.oryxel.gfp.session.CachedSession;

public class ClientPlayerAction
implements JavaPacketListener,
BedrockPacketListener {
    @Override
    public void packetSending(MCPLPacketEvent event) {
        ServerboundPlayerActionPacket packet;
        CachedSession session = event.getSession();
        Packet packet2 = event.getPacket();
        if (packet2 instanceof ServerboundPlayerActionPacket) {
            PlayerAction exemptedAction;
            packet = (ServerboundPlayerActionPacket)packet2;
            PlayerAction playerAction = exemptedAction = session.getSession().getGameMode() == GameMode.CREATIVE ? PlayerAction.START_DIGGING : PlayerAction.FINISH_DIGGING;
            if (session.getSession().getGeyser().getWorldManager().hasOwnChunkCache() && packet.getAction() != exemptedAction && packet.getAction() != PlayerAction.CANCEL_DIGGING) {
                return;
            }
            if (packet.getAction() != PlayerAction.START_DIGGING && packet.getAction() != PlayerAction.FINISH_DIGGING && packet.getAction() != PlayerAction.CANCEL_DIGGING) {
                return;
            }
            event.setPacket((Packet)new ServerboundPlayerActionPacket(packet.getAction(), packet.getPosition().add(session.getOffset()), packet.getFace(), packet.getSequence()));
        }
        if ((packet2 = event.getPacket()) instanceof ServerboundUseItemOnPacket) {
            packet = (ServerboundUseItemOnPacket)packet2;
            event.setPacket((Packet)new ServerboundUseItemOnPacket(packet.getPosition().add(session.getOffset()), packet.getFace(), packet.getHand(), packet.getCursorX(), packet.getCursorY(), packet.getCursorZ(), packet.isInsideBlock(), packet.isHitWorldBorder(), packet.getSequence()));
        }
        if ((packet2 = event.getPacket()) instanceof ServerboundBlockEntityTagQueryPacket) {
            packet = (ServerboundBlockEntityTagQueryPacket)packet2;
            event.setPacket((Packet)new ServerboundBlockEntityTagQueryPacket(packet.getTransactionId(), packet.getPosition().add(session.getOffset())));
        }
        if ((packet2 = event.getPacket()) instanceof ServerboundJigsawGeneratePacket) {
            packet = (ServerboundJigsawGeneratePacket)packet2;
            event.setPacket((Packet)new ServerboundJigsawGeneratePacket(packet.getPosition().add(session.getOffset()), packet.getLevels(), packet.isKeepJigsaws()));
        }
        if ((packet2 = event.getPacket()) instanceof ServerboundPickItemFromBlockPacket) {
            packet = (ServerboundPickItemFromBlockPacket)packet2;
            event.setPacket((Packet)new ServerboundPickItemFromBlockPacket(packet.getPos().add(session.getOffset()), packet.isIncludeData()));
        }
        if ((packet2 = event.getPacket()) instanceof ServerboundSetCommandBlockPacket) {
            packet = (ServerboundSetCommandBlockPacket)packet2;
            event.setPacket((Packet)new ServerboundSetCommandBlockPacket(packet.getPosition().add(session.getOffset()), packet.getCommand(), packet.getMode(), packet.isDoesTrackOutput(), packet.isConditional(), packet.isAutomatic()));
        }
        if ((packet2 = event.getPacket()) instanceof ServerboundSetJigsawBlockPacket) {
            packet = (ServerboundSetJigsawBlockPacket)packet2;
            event.setPacket((Packet)new ServerboundSetJigsawBlockPacket(packet.getPosition().add(session.getOffset()), packet.getName(), packet.getTarget(), packet.getPool(), packet.getFinalState(), packet.getJointType(), packet.getSelectionPriority(), packet.getPlacementPriority()));
        }
        if ((packet2 = event.getPacket()) instanceof ServerboundSetStructureBlockPacket) {
            packet = (ServerboundSetStructureBlockPacket)packet2;
            event.setPacket((Packet)new ServerboundSetStructureBlockPacket(packet.getPosition().add(session.getOffset()), packet.getAction(), packet.getMode(), packet.getName(), packet.getOffset(), packet.getSize(), packet.getMirror(), packet.getRotation(), packet.getMetadata(), packet.getIntegrity(), packet.getSeed(), packet.isIgnoreEntities(), packet.isShowAir(), packet.isShowBoundingBox(), packet.isStrict()));
        }
        if ((packet2 = event.getPacket()) instanceof ServerboundSignUpdatePacket) {
            packet = (ServerboundSignUpdatePacket)packet2;
            event.setPacket((Packet)new ServerboundSignUpdatePacket(packet.getPosition().add(session.getOffset()), packet.getLines(), packet.isFrontText()));
        }
    }

    @Override
    public void packetReceived(MCPLPacketEvent event) {
        Packet packet = event.getPacket();
        if (packet instanceof ClientboundBlockDestructionPacket) {
            ClientboundBlockDestructionPacket packet2 = (ClientboundBlockDestructionPacket)packet;
            event.setPacket((Packet)new ClientboundBlockDestructionPacket(packet2.getBreakerEntityId(), packet2.getPosition().sub(event.getSession().getOffset()), packet2.getStage()));
        }
    }

    @Override
    public void onPacketReceived(CloudburstPacketEvent event) {
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof PlayerAuthInputPacket) {
            PlayerAuthInputPacket packet = (PlayerAuthInputPacket)bedrockPacket;
            CachedSession session = event.getSession();
            if (!session.getSession().getGeyser().getWorldManager().hasOwnChunkCache()) {
                return;
            }
            if (!packet.getInputData().contains(PlayerAuthInputData.PERFORM_BLOCK_ACTIONS)) {
                return;
            }
            for (PlayerBlockActionData blockActionData : packet.getPlayerActions()) {
                if (blockActionData.getBlockPosition() == null || blockActionData.getAction() != PlayerActionType.START_BREAK) continue;
                blockActionData.setBlockPosition(blockActionData.getBlockPosition().add(session.getOffset()));
            }
        }
    }

    @Override
    public void onPacketSend(CloudburstPacketEvent event, boolean immediate) {
        CachedSession session = event.getSession();
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof LevelEventPacket) {
            LevelEventPacket packet = (LevelEventPacket)bedrockPacket;
            if (!session.getSession().getGeyser().getWorldManager().hasOwnChunkCache()) {
                return;
            }
            if (packet.getType() == LevelEvent.BLOCK_START_BREAK) {
                packet.setPosition(packet.getPosition().sub(session.getOffset().toFloat()));
            }
        }
    }
}

