/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.cache;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.util.List;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.registry.JavaRegistry;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.ChunkSection;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.ClientboundLevelChunkWithLightPacket;
import org.oryxel.gfp.session.CachedSession;
import org.oryxel.gfp.shaded.fastutil.longs.Long2ObjectMap;
import org.oryxel.gfp.shaded.fastutil.longs.Long2ObjectOpenHashMap;
import org.oryxel.gfp.util.DimensionUtil;

public class ChunkCache {
    private final CachedSession session;
    private final Long2ObjectMap<ChunkSection[]> chunks = new Long2ObjectOpenHashMap<ChunkSection[]>();
    private final Long2ObjectMap<ClientboundLevelChunkWithLightPacket> chunkPackets = new Long2ObjectOpenHashMap<ClientboundLevelChunkWithLightPacket>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChunksWithOffset() {
        int oldDimension = this.session.getSession().getBedrockDimension().bedrockId();
        DimensionUtil.switchDimension(this.session, DimensionUtils.getTemporaryDimension((int)oldDimension, (int)oldDimension), false);
        DimensionUtil.switchDimension(this.session, oldDimension, true);
        this.session.getSession().setSpawned(false);
        this.session.silentDimensionSwitch = true;
        for (Long2ObjectMap.Entry entry : this.chunks.long2ObjectEntrySet()) {
            ClientboundLevelChunkWithLightPacket oldPacket = (ClientboundLevelChunkWithLightPacket)this.chunkPackets.get(entry.getLongKey());
            if (oldPacket == null) continue;
            ByteBuf oldByteBuf = Unpooled.wrappedBuffer((byte[])oldPacket.getChunkData());
            ByteBuf byteBuf = null;
            try {
                ChunkSection[] sections;
                for (int sectionY = 0; sectionY < this.getChunkHeightY(); ++sectionY) {
                    MinecraftTypes.readChunkSection((ByteBuf)oldByteBuf, (int)((List)BlockRegistries.BLOCK_STATES.get()).size(), (int)this.session.getSession().getRegistryCache().registry(JavaRegistries.BIOME).size());
                }
                byteBuf = ByteBufAllocator.DEFAULT.ioBuffer();
                for (ChunkSection section : sections = (ChunkSection[])entry.getValue()) {
                    MinecraftTypes.writeChunkSection((ByteBuf)byteBuf, (ChunkSection)section);
                }
                byteBuf.writeBytes(oldByteBuf);
                byte[] payload = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(payload);
                this.session.mcplSession.callPacketReceived((Packet)new ClientboundLevelChunkWithLightPacket(oldPacket.getX(), oldPacket.getZ(), payload, oldPacket.getHeightMaps(), oldPacket.getBlockEntities(), oldPacket.getLightData()));
            }
            finally {
                if (byteBuf != null) {
                    byteBuf.release();
                }
                oldByteBuf.release();
            }
        }
    }

    public void addToCache(ClientboundLevelChunkWithLightPacket packet, ChunkSection[] chunks) {
        long chunkPosition = MathUtils.chunkPositionToLong((int)packet.getX(), (int)packet.getZ());
        this.chunks.put(chunkPosition, chunks);
        this.chunkPackets.put(chunkPosition, packet);
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        return this.getChunk(chunkX >> 4, chunkZ >> 4) != null;
    }

    private ChunkSection[] getChunk(int chunkX, int chunkZ) {
        long chunkPosition = MathUtils.chunkPositionToLong((int)chunkX, (int)chunkZ);
        return this.chunks.getOrDefault(chunkPosition, (ChunkSection[])null);
    }

    public void updateBlock(Vector3i vector3i, int block) {
        this.updateBlock(vector3i.getX(), vector3i.getY(), vector3i.getZ(), block);
    }

    public void updateBlock(int x, int y, int z, int block) {
        ChunkSection[] chunk = this.getChunk(x >> 4, z >> 4);
        if (chunk == null) {
            return;
        }
        if (y < this.getMinY() || y - this.getMinY() >> 4 > chunk.length - 1) {
            return;
        }
        ChunkSection section = chunk[y - this.getMinY() >> 4];
        if (section == null) {
            if (block != 0) {
                JavaRegistry registryKey = this.session.getSession().getRegistryCache().registry(JavaRegistries.BIOME);
                chunk[y - this.getMinY() >> 4] = section = new ChunkSection(0, ((List)BlockRegistries.BLOCK_STATES.get()).size(), ((Integer)registryKey.values().get(0)).intValue(), registryKey.size());
            } else {
                return;
            }
        }
        section.setBlock(x & 0xF, y & 0xF, z & 0xF, block);
    }

    public void removeChunk(int chunkX, int chunkZ) {
        long chunkPosition = MathUtils.chunkPositionToLong((int)chunkX, (int)chunkZ);
        this.chunks.remove(chunkPosition);
        this.chunkPackets.remove(chunkPosition);
    }

    public int getMinY() {
        return this.session.getSession().getChunkCache().getChunkMinY() << 4;
    }

    public int getHeightY() {
        return this.session.getSession().getChunkCache().getChunkHeightY() << 4;
    }

    public int getChunkHeightY() {
        return this.session.getSession().getChunkCache().getChunkHeightY();
    }

    @Generated
    public ChunkCache(CachedSession session) {
        this.session = session;
    }

    @Generated
    public CachedSession getSession() {
        return this.session;
    }
}

