/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.protocol.mitm;

import lombok.Generated;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.common.PacketSignal;
import org.geysermc.geyser.network.UpstreamPacketHandler;
import org.oryxel.gfp.protocol.PacketEvents;
import org.oryxel.gfp.protocol.event.CloudburstPacketEvent;
import org.oryxel.gfp.protocol.listener.BedrockPacketListener;
import org.oryxel.gfp.session.CachedSession;

public final class CloudburstReceiveListener
implements BedrockPacketHandler {
    private final CachedSession player;
    private final BedrockPacketHandler oldHandler;

    public PacketSignal handlePacket(BedrockPacket packet) {
        boolean isGeyserHandler = this.oldHandler instanceof UpstreamPacketHandler;
        boolean cancelled = false;
        if (!isGeyserHandler) {
            cancelled = this.oldHandler.handlePacket(packet) == PacketSignal.HANDLED;
        }
        CloudburstPacketEvent event = new CloudburstPacketEvent(this.player, packet);
        for (BedrockPacketListener listener : PacketEvents.getApi().getBedrockListeners()) {
            listener.onPacketReceived(event);
        }
        if (event.isCancelled() || cancelled) {
            return PacketSignal.HANDLED;
        }
        if (isGeyserHandler) {
            return this.oldHandler.handlePacket(event.getPacket());
        }
        return PacketSignal.UNHANDLED;
    }

    public void onDisconnect(String reason) {
        this.oldHandler.onDisconnect(reason);
    }

    @Generated
    public CloudburstReceiveListener(CachedSession player, BedrockPacketHandler oldHandler) {
        this.player = player;
        this.oldHandler = oldHandler;
    }

    @Generated
    public CachedSession getPlayer() {
        return this.player;
    }

    @Generated
    public BedrockPacketHandler getOldHandler() {
        return this.oldHandler;
    }
}

