/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.handler;

import java.util.BitSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.BlockBreakHandler;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.translator.item.CustomItemTranslator;
import org.geysermc.geyser.translator.protocol.bedrock.BedrockInventoryTransactionTranslator;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerAction;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;
import org.oryxel.gfp.session.CachedSession;

public class GFPBlockBreakHandler
extends BlockBreakHandler {
    private final CachedSession cachedSession;

    public GFPBlockBreakHandler(CachedSession cachedSession) {
        super(cachedSession.getSession());
        this.cachedSession = cachedSession;
    }

    protected void handleStartBreak(@NonNull Vector3i position, @NonNull BlockState state, Direction blockFace, long tick) {
        Vector3i offsetPos = position;
        if (this.session.getGeyser().getWorldManager().hasOwnChunkCache()) {
            offsetPos = position.add(this.cachedSession.getOffset());
            state = this.session.getGeyser().getWorldManager().blockAt(this.session, offsetPos);
        }
        GeyserItemStack item = this.session.getPlayerInventory().getItemInHand();
        Vector3i fireBlockPos = BlockUtils.getBlockPosition((Vector3i)offsetPos, (Direction)blockFace);
        Block possibleFireBlock = this.session.getGeyser().getWorldManager().blockAt(this.session, fireBlockPos).block();
        if (possibleFireBlock == Blocks.FIRE || possibleFireBlock == Blocks.SOUL_FIRE) {
            ServerboundPlayerActionPacket startBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.START_DIGGING, BlockUtils.getBlockPosition((Vector3i)position, (Direction)blockFace).add(this.cachedSession.getOffset()), blockFace.mcpl(), this.session.getWorldCache().nextPredictionSequence());
            this.session.sendDownstreamGamePacket((Packet)startBreakingPacket);
        }
        float breakProgress = this.calculateBreakProgress(state, position, item);
        if (!this.session.isInstabuild() && !(breakProgress >= 1.0f)) {
            ItemMapping mapping = item.getMapping(this.session);
            ItemDefinition customItem = mapping.isTool() ? CustomItemTranslator.getCustomItem((DataComponents)item.getComponents(), (ItemMapping)mapping) : null;
            CustomBlockState blockStateOverride = (CustomBlockState)BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.get((Object)state.javaId());
            SkullCache.Skull skull = (SkullCache.Skull)this.session.getSkullCache().getSkulls().get(position);
            this.blockStartBreakTime = 0L;
            if (((BitSet)BlockRegistries.NON_VANILLA_BLOCK_IDS.get()).get(state.javaId()) || blockStateOverride != null || customItem != null || skull != null && skull.getBlockDefinition() != null) {
                this.blockStartBreakTime = tick;
                this.lastBlockBreakFace = blockFace;
            }
            LevelEventPacket startBreak = new LevelEventPacket();
            startBreak.setType((LevelEventType)LevelEvent.BLOCK_START_BREAK);
            startBreak.setPosition(position.toFloat());
            startBreak.setData((int)(65535.0 / BlockUtils.reciprocal((double)breakProgress)));
            this.session.sendUpstreamPacket((BedrockPacket)startBreak);
            BlockUtils.spawnBlockBreakParticles((GeyserSession)this.session, (Direction)blockFace, (Vector3i)position, (BlockState)state);
            this.currentBlockPos = position;
            this.currentBlockState = state;
            this.session.sendDownstreamGamePacket((Packet)new ServerboundPlayerActionPacket(PlayerAction.START_DIGGING, position.add(this.cachedSession.getOffset()), blockFace.mcpl(), this.session.getWorldCache().nextPredictionSequence()));
        } else {
            this.lastInstaMinedPosition = position;
            this.destroyBlock(state, position, blockFace, true);
        }
    }

    protected boolean canBreak(Vector3i vector, BlockState state) {
        if (this.session.getGeyser().getWorldManager().hasOwnChunkCache()) {
            vector = vector.add(this.cachedSession.getOffset());
            state = this.session.getGeyser().getWorldManager().blockAt(this.session, vector);
        }
        if (!this.session.isHandsBusy() && this.session.getWorldBorder().isInsideBorderBoundaries()) {
            switch (this.session.getGameMode()) {
                case SPECTATOR: 
                case ADVENTURE: {
                    return super.canBreak(vector, state);
                }
            }
            Vector3f playerPosition = this.session.getPlayerEntity().getPosition();
            playerPosition = playerPosition.down(EntityDefinitions.PLAYER.offset() - this.session.getEyeHeight());
            playerPosition = playerPosition.add(this.cachedSession.getOffset().toFloat());
            return BedrockInventoryTransactionTranslator.canInteractWithBlock((GeyserSession)this.session, (Vector3f)playerPosition, (Vector3i)vector);
        }
        return false;
    }

    protected void handleAbortBreaking(Vector3i position) {
        if (this.currentBlockPos != null) {
            ServerboundPlayerActionPacket abortBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.CANCEL_DIGGING, this.currentBlockPos.add(this.cachedSession.getOffset()), Direction.DOWN.mcpl(), 0);
            this.session.sendDownstreamGamePacket((Packet)abortBreakingPacket);
        }
        BlockUtils.sendBedrockStopBlockBreak((GeyserSession)this.session, (Vector3f)position.toFloat());
    }

    protected void destroyBlock(BlockState state, Vector3i vector, Direction direction, boolean instamine) {
        Vector3i offset = vector.add(this.cachedSession.getOffset());
        if (this.session.getGeyser().getWorldManager().hasOwnChunkCache()) {
            state = this.session.getGeyser().getWorldManager().blockAt(this.session, offset);
        }
        this.session.sendDownstreamGamePacket((Packet)new ServerboundPlayerActionPacket(instamine ? PlayerAction.START_DIGGING : PlayerAction.FINISH_DIGGING, offset, direction.mcpl(), this.session.getWorldCache().nextPredictionSequence()));
        this.session.getWorldCache().markPositionInSequence(offset);
        if (this.canDestroyBlock(state)) {
            BlockUtils.spawnBlockBreakParticles((GeyserSession)this.session, (Direction)direction, (Vector3i)vector, (BlockState)state);
            BlockUtils.sendBedrockBlockDestroy((GeyserSession)this.session, (Vector3f)vector.toFloat(), (int)state.javaId());
        } else {
            BlockUtils.restoreCorrectBlock((GeyserSession)this.session, (Vector3i)vector, (BlockState)state);
        }
        this.clearCurrentVariables();
    }

    protected void handleContinueDestroy(Vector3i position, BlockState state, Direction blockFace, long tick) {
        if (this.session.getGeyser().getWorldManager().hasOwnChunkCache()) {
            state = this.session.getGeyser().getWorldManager().blockAt(this.session, position.add(this.cachedSession.getOffset()));
        }
        BlockUtils.spawnBlockBreakParticles((GeyserSession)this.session, (Direction)blockFace, (Vector3i)position, (BlockState)state);
        double totalBreakTime = BlockUtils.reciprocal((double)this.calculateBreakProgress(state, Vector3i.ZERO, this.session.getPlayerInventory().getItemInHand()));
        if (this.blockStartBreakTime != 0L) {
            double d;
            long ticksSinceStart = tick - this.blockStartBreakTime;
            totalBreakTime += 2.0;
            if ((double)ticksSinceStart >= d) {
                this.destroyBlock(state, position, blockFace, false);
                return;
            }
            this.lastBlockBreakFace = blockFace;
        }
        LevelEventPacket updateBreak = new LevelEventPacket();
        updateBreak.setType((LevelEventType)LevelEvent.BLOCK_UPDATE_BREAK);
        updateBreak.setPosition(position.toFloat());
        updateBreak.setData((int)(65535.0 / totalBreakTime));
        this.session.sendUpstreamPacket((BedrockPacket)updateBreak);
    }
}

