/*
 * Decompiled with CFR 0.152.
 */
package org.oryxel.gfp.geyser.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.cloudburstmc.protocol.bedrock.BedrockServerSession;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.session.DownstreamSession;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.UpstreamSession;
import org.geysermc.geyser.session.cache.BlockBreakHandler;
import org.geysermc.mcprotocollib.network.ClientSession;
import org.geysermc.mcprotocollib.network.event.session.SessionListener;
import org.oryxel.gfp.handler.GFPBlockBreakHandler;
import org.oryxel.gfp.protocol.mitm.CloudburstReceiveListener;
import org.oryxel.gfp.protocol.mitm.CloudburstSendListener;
import org.oryxel.gfp.protocol.mitm.MCPLMiddleListener;
import org.oryxel.gfp.session.CachedSession;

public class GeyserUtil {
    public static void hookIntoCloudburstMC(CachedSession session) {
        GeyserSession connection = session.getSession();
        session.getSession().setBlockBreakHandler((BlockBreakHandler)new GFPBlockBreakHandler(session));
        try {
            session.cloudburstDownstream = GeyserUtil.findCloudburstSession((GeyserConnection)connection);
            GeyserUtil.injectCloudburstUpstream(session);
            GeyserUtil.injectCloudburstDownstream(session);
        }
        catch (Exception ignored) {
            session.kick("Failed to hook into cloudburst session!");
        }
    }

    public static void hookIntoMCPL(CachedSession player) {
        try {
            ClientSession session = GeyserUtil.findClientSession((GeyserConnection)player.getSession());
            ArrayList<SessionListener> adapters = new ArrayList<SessionListener>(session.getListeners());
            session.getListeners().forEach(arg_0 -> ((ClientSession)session).removeListener(arg_0));
            session.addListener((SessionListener)new MCPLMiddleListener(player, adapters));
            player.mcplSession = session;
        }
        catch (Exception ignored) {
            player.kick("Failed to hook into mcpl session!");
        }
    }

    private static void injectCloudburstDownstream(CachedSession player) {
        BedrockServerSession session = player.cloudburstDownstream;
        BedrockPacketHandler handler = session.getPacketHandler();
        player.downstreamPacketHandler = new CloudburstReceiveListener(player, handler);
        session.setPacketHandler((BedrockPacketHandler)player.downstreamPacketHandler);
    }

    private static void injectCloudburstUpstream(CachedSession player) throws Exception {
        BedrockServerSession session = player.cloudburstDownstream;
        Field upstream = GeyserSession.class.getDeclaredField("upstream");
        upstream.setAccessible(true);
        player.cloudburstUpstream = new CloudburstSendListener(player, session, (UpstreamSession)upstream.get(player.getSession()));
        upstream.set(player.getSession(), (Object)player.cloudburstUpstream);
    }

    private static ClientSession findClientSession(GeyserConnection connection) throws Exception {
        Field upstream = GeyserSession.class.getDeclaredField("downstream");
        upstream.setAccessible(true);
        Object session = upstream.get(connection);
        Field field = DownstreamSession.class.getDeclaredField("session");
        field.setAccessible(true);
        return (ClientSession)field.get(session);
    }

    private static BedrockServerSession findCloudburstSession(GeyserConnection connection) throws Exception {
        Field upstream = GeyserSession.class.getDeclaredField("upstream");
        upstream.setAccessible(true);
        Object session = upstream.get(connection);
        Field field = UpstreamSession.class.getDeclaredField("session");
        field.setAccessible(true);
        return (BedrockServerSession)field.get(session);
    }
}

